 /*
  * gettime.c  --    Uses BIOS interrupt 0x1A to get the timer count 
  *                  in clock ticks.
  *   Copyright Frank D. Greco, 1987
  *   Page 50, Volume 6.1 Programmer's Journal
  */
  
  #include <dos.h>
  
  #define     TOD_INT     0x1a
  
  unsigned long gettime()
  {
      union REGS in, out;
      unsigned long current_tix;      /* 32-bit tick value to be returned */
  
      in.h.ah = 0;                    /* AH = 0    GET clock ticks */
      int86(TOD_INT, &in, &out);      /* Call BIOS timer tick interrupt */ 
  
      current_tix = ( (long) out.x.cx << 16 ) + out.x.dx;
  
  /* If midnite passes, add a day's worth of clock tix to the return value */
  
      return ( out.x.ax & 0xff ) ? current_tix += 0x01800b0L: current_tix;
  }
