UNIT Time;

interface

uses Dos;

procedure RestartTimer; {Think of it like starting a stopwatch.}
function Elapsed:real;  {How many seconds elapsed since I hit the stopwatch?}
function ElapsedStr:string; {result of "Elapsed" in string form.}

implementation

var
   TimerTicking : boolean;
   h1, m1, s1, s1001 : word;

procedure RestartTimer;
begin
     TimerTicking := true;
     gettime(h1, m1, s1, s1001)
end;

function Elapsed:real;

         function AbsTime(h,m,s,s100:word):real;
         begin
              AbsTime := (s100/100.0) + s + (60.0*m) + (3600.0*h)
         end;

var h2, m2, s2, s1002 : word;
    T1, T2 : real;
begin
     if TimerTicking then
     begin
          gettime(h2, m2, s2, s1002);
          T1 := AbsTime(h1, m1, s1, s1001);
          T2 := AbsTime(h2, m2, s2, s1002);
          Elapsed := T2 - T1
     end
     else
         Elapsed := 0.0
end;

function ElapsedStr:string;
var s:string;
begin
     str(Elapsed:6:1,s);
     ElapsedStr := 't = '+s+'s.  '
end;

begin
     TimerTicking := false
end.
