/*
 * MULTIPLT
 *
 * Copyright (C) 1998 - 2000  Michael C. Ring
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear 
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the modified code.  Modifications are to be distributed 
 * as patches to released version.
 *  
 * This software is provided "as is" without express or implied warranty.
 */

/*
 *      Put multiple postscript plots on one sheet of paper.
 *      Post-process the output of FPLOT or GNUPLOT.
 *
 *      $Log: multiplt.c $
 *      Revision 2.4  2000/01/09 04:52:17  mike
 *      add 'main' prototype for DOS compiles
 *
 *      Revision 2.3  2000/01/08 05:04:50  mike
 *      added full prototypes
 *
 *      Revision 2.2  1999/09/30 19:47:05  mring
 *      change ledger to tabloid
 *
 *      Revision 2.1  1999/09/30 02:45:21  mring
 *      check for page size of multiplt also
 *
 *      Revision 2.0  1999/09/27 21:33:55  mring
 *      added support for various page sizes
 *
 *      Revision 1.9  1998/10/20 21:17:16  mring
 *      changed usage message and simplified '--' processing
 *
 *      Revision 1.8  1998/10/20 21:16:24  mring
 *      *** empty log message ***
 *
 *      Revision 1.7  1998/10/16 23:48:37  mring
 *      improved Usage: display
 *
 *      Revision 1.6  1998/10/16 23:45:38  mring
 *      added special filename of '--' to output a blank page
 *
 *      Revision 1.5  1998/10/11 20:29:19  mring
 *      parse and display version of program
 *      other minor clean-ups
 *
 *      Revision 1.4  1998/02/13 22:55:41  mring
 *      removed paper size code
 *
 *      Revision 1.3  1998/02/13 03:06:05  mring
 *      added code to support variable page size
 *
 *      Revision 1.2  1998/02/13 01:21:30  mring
 *      added copyright banner, RCS info
 */

static  char    
RCS_ID[] = "$Id: multiplt.c 2.4 2000/01/09 04:52:17 mike Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

/*
 *      function prototypes 
 */

#ifdef  MSDOS
extern	int	main(int argc, char *argv[]);
#endif

extern	int	get_image_size(char *);
extern	int	scan_to_next_field(char **);
extern	void	parse_version_num(char *);
extern	void	top_header(void);
extern	void	header(int);
extern	void	trailer(void);
extern  char	*replace_crlf(char *);
extern  char    *lowercase(char *);
extern  int	strposition(char *, char *);


#define  TRUE   1
#define  FALSE  0
#define  BORDER 16.0
#define  PLOT_3_BORDER 0.185

unsigned char   g_str[4096];
int             g_num_plots, g_letter_flag;
double		g_6_plot_factor, g_xx_image, g_yy_image, 
		g_xx_output, g_yy_output;

/*
 *   start of main source code
 */

int  main(argc,argv)
int  argc;  char *argv[];
{
char    *cp, *buf, version[32], fn[256];
int     k, findex, oflag, fstart, num_files;
FILE    *ptr;

num_files = argc - 1;

buf    = g_str;
fstart = 0;
findex = 0;

g_xx_output = 792.0;      /* default to letter, 8.5 x 11 */
g_yy_output = 612.0;
g_letter_flag = TRUE;

if (argc >= 2)
  {
   strcpy(buf,argv[1]);
   lowercase(buf);

   /* check if we specified a page size parameter */

   if (buf[0] == '-' && buf[1] == 's')
     {
      num_files--;
      fstart++;
      cp  = buf + 2;
      oflag = TRUE;

      /* scaling is in points; 72 points per inch */

      if (strposition(cp, "letter") == 0)         /* 8.5 x 11 */
        oflag = FALSE;

      if (strposition(cp, "legal") == 0)          /* 8.5 x 14 */
        {
         g_letter_flag = FALSE;
	 oflag = FALSE;
	 g_xx_output = 1008.0;
	 g_yy_output = 612.0;
	}

      if (strposition(cp, "tabloid") == 0)        /* 11 x 17 */
        {
         g_letter_flag = FALSE;
	 oflag = FALSE;
	 g_xx_output = 1224.0;
	 g_yy_output = 792.0;
	}

      if (strposition(cp, "a3") == 0)             /* 297mm x 420mm */
        {
         g_letter_flag = FALSE;
	 oflag = FALSE;
	 g_xx_output = 1190.0;
	 g_yy_output = 842.0;
	}

      if (strposition(cp, "a4") == 0)             /* 210mm x 297mm */
        {
         g_letter_flag = FALSE;
	 oflag = FALSE;
	 g_xx_output = 842.0;
	 g_yy_output = 596.0;
	}

      if (strposition(cp, "a5") == 0)             /* 148mm x 210mm */
        {
         g_letter_flag = FALSE;
	 oflag = FALSE;
	 g_xx_output = 596.0;
	 g_yy_output = 420.0;
	}

      if (strposition(cp, "b4") == 0)             /* 257mm x 364mm */
        {
         g_letter_flag = FALSE;
	 oflag = FALSE;
	 g_xx_output = 1032.0;
	 g_yy_output = 728.0;
	}

      if (strposition(cp, "b5") == 0)             /* 182mm x 257mm */
        {
         g_letter_flag = FALSE;
	 oflag = FALSE;
	 g_xx_output = 728.0;
	 g_yy_output = 516.0;
	}

      if (oflag)
        {
         fprintf(stderr,
         "Unknown Paper Size Option: \'%s\', Defaulting to \'letter\'\n",cp);
	}
     }
  }

if (num_files < 1 || num_files > 9)
  {
   parse_version_num(version);

   fprintf(stderr,
"Usage : multiplt  [-sPaperSize]  PS-file-1 ... PS-file-9    [Version %s]\n\n",
	 version);

   fprintf(stderr,"        Option -s     where valid papersizes are: \n");
   fprintf(stderr,"        \'letter\'      8.5 x 11  (default)\n");
   fprintf(stderr,"        \'legal\'       8.5 x 14\n");
   fprintf(stderr,"        \'tabloid\'      11 x 17\n");
   fprintf(stderr,"        \'a3\'          297mm x 420mm \n");
   fprintf(stderr,"        \'a4\'          210mm x 297mm \n");
   fprintf(stderr,"        \'a5\'          148mm x 210mm \n");
   fprintf(stderr,"        \'b4\'          257mm x 364mm \n");
   fprintf(stderr,"        \'b5\'          182mm x 257mm \n");

   fprintf(stderr,
"\nUse a filename of -- to output an empty plot (dummy placeholder)\n");

   fprintf(stderr,
"Example : force 4 plots to be output in the 6 plot format on A4 paper with : \n");

   fprintf(stderr,
"          multiplt -sa4 f1.ps f2.ps -- -- f3.ps f4.ps \n");
   exit(8);
  }

g_num_plots = num_files;
if (g_num_plots == 5)  g_num_plots = 6;
if (g_num_plots == 7)  g_num_plots = 8;

k = fstart;

top_header();

while (1)
  {
   if (++k == argc)  break;

   strcpy(fn,argv[k]);
   findex++;

   if (strcmp(fn,"--") != 0)
     {
      get_image_size(fn);

      if ((ptr = fopen(fn,"r")) == NULL)
	{
	 fprintf(stderr,"File %s not found\n",fn);
	}
      else
	{
	 header(findex);
   
	 fgets(g_str,4095,ptr);
	 if (strposition(g_str,"%!") != 0)
	   {
	    fprintf(stderr,
	    "Warning! : File %s does not appear to be a postscript file\n",fn);
	   }
   
	 while(fgets(g_str,4095,ptr))    
	   {
	    replace_crlf(g_str);
      
	    if (strposition(g_str,"showpage") == 0)
	       break;
	    else
	       printf("%s\n",g_str);
	   }
      
	 printf("grestore\n");
	 fclose(ptr);
	}
     }
  }

trailer();

exit(0);
return(0);                      /* just to keep the compiler happy ... */
}  /* end main() */
/***********************************************************************/
int	get_image_size(filename)
char    *filename;
{
int	j, k, ii;
char    *cp, *instr;
FILE 	*ptr;

g_xx_image = 792.0;                   /* default image size, 8.5 x 11 */
g_yy_image = 612.0;

if ((ptr = fopen(filename, "r")) == NULL)
  return(1);

instr = g_str;

for (ii=0; ii < 20; ii++)             /* look for the image size in     */
  {			  	      /* the first 20 lines of the file */
   if (fgets(instr,4095,ptr) == NULL)
     break;    

   /*
    *  look for paper size output from 'fplot' OR 'multiplt'
    */

   j = strposition(instr, "%%FplotPageSize:");
   k = strposition(instr, "%%MultipltPageSize:");

   if (j >= 0 || k >= 0)
     {
      cp = instr;
      if (j >= 0)
        cp += j + 14;
      else	
        cp += k + 17;

      scan_to_next_field(&cp);
      g_yy_image = atof(cp);

      scan_to_next_field(&cp);
      g_xx_image = atof(cp);

      if (g_xx_image < 4.0 || g_yy_image < 4.0)
        {
         g_xx_image = 792.0;
         g_yy_image = 612.0;
        }

      break;
     }
  }

fclose(ptr);
return(0);
}
/***********************************************************************/
int	scan_to_next_field(p)
char 	**p;
{
char    *cp;

cp = *p;

while (1)           /* scan until *cp == space */
  {
   if (*cp == '\0') return(0);
   if (*cp == ' ')  break;
   cp++;
  }

while (1)           /* scan until *cp != space, found next field */
  {
   if (*cp == '\0') return(0);
   if (*cp != ' ')  break;
   cp++;
  }

*p = cp;
return(1);
}
/***********************************************************************/
void	parse_version_num(s)
char 	*s;
{
char 	*p;

p = RCS_ID;
scan_to_next_field(&p);
scan_to_next_field(&p);

while (1)
  {
   if ((*s = *p++) == ' ')  break;
   s++;
  }
*s = '\0';
}
/***********************************************************************/
void	top_header()
{
double  dborder, dtmp, dtmp2, xx, yy, xx2, yy2;

dborder = BORDER;
xx      = g_xx_output;
yy      = g_yy_output;
xx2     = g_xx_output / 2.0;
yy2     = g_yy_output / 2.0;

printf("%%!PS\n");
printf("%%%%Creator: multiplt\n");
printf("%%%%MultipltPageSize: %d %d\n",(int)(yy + 0.01),(int)(xx + 0.01));
printf("%%%%Pages: (atend)\n");
printf("%%%%EndComments\n");
printf("/multiplt %d dict def\n",(g_num_plots * 2 + 2));
printf("multiplt begin\n");

if (g_num_plots == 1)
  {
   printf("/XDIM1 0 def\n");
   printf("/YDIM1 0 def\n");
  }

if (g_num_plots == 2)
  {
   printf("/XDIM1 %.1f def\n",dborder);
   printf("/XDIM2 %.1f def\n",dborder);

   printf("/YDIM1 %.1f def\n",(xx - dborder));
   printf("/YDIM2 %.1f def\n",xx2);
  }

if (g_num_plots == 3)
  {
   dtmp = PLOT_3_BORDER * yy;
   
   printf("/XDIM1 %.1f def\n",dtmp);
   printf("/XDIM2 %.1f def\n",dtmp);
   printf("/XDIM3 %.1f def\n",dtmp);
   
   dtmp = (xx - 2.0 * dborder) / 3.0;
   printf("/YDIM1 %.1f def\n",(xx - dborder));
   printf("/YDIM2 %.1f def\n",(xx - dborder - dtmp));
   printf("/YDIM3 %.1f def\n",(xx - dborder - 2.0 * dtmp));
  }

if (g_num_plots == 4)
  {
   printf("/XDIM1 %.1f def\n",dborder);
   printf("/XDIM2 %.1f def\n",dborder);
   printf("/XDIM3 %.1f def\n",yy2);
   printf("/XDIM4 %.1f def\n",yy2);

   printf("/YDIM1 %.1f def\n",dborder);
   printf("/YDIM2 %.1f def\n",xx2);
   printf("/YDIM3 %.1f def\n",dborder);
   printf("/YDIM4 %.1f def\n",xx2);
  }

if (g_num_plots == 6)
  {
   printf("/XDIM1 %.1f def\n",dborder);
   printf("/XDIM2 %.1f def\n",yy2);
   printf("/XDIM3 %.1f def\n",dborder);
   printf("/XDIM4 %.1f def\n",yy2);
   printf("/XDIM5 %.1f def\n",dborder);
   printf("/XDIM6 %.1f def\n",yy2);

   if (g_letter_flag)
     {
      dtmp  = (xx - 2.0 * dborder) / 3.0;
      dtmp2 = 10.0 + dborder / 15.0;
      g_6_plot_factor = dtmp - 2.0 * dtmp2;

      printf("/YDIM1 %.1f def\n",(xx - dborder - dtmp2));
      printf("/YDIM2 %.1f def\n",(xx - dborder - dtmp2));
      printf("/YDIM3 %.1f def\n",(xx - dborder - dtmp - dtmp2));
      printf("/YDIM4 %.1f def\n",(xx - dborder - dtmp - dtmp2));
      printf("/YDIM5 %.1f def\n",(xx - dborder - 2.0 * dtmp - dtmp2));
      printf("/YDIM6 %.1f def\n",(xx - dborder - 2.0 * dtmp - dtmp2));
     }
   else
     {
      dtmp = (xx - 2.0 * dborder) / 3.0;
      printf("/YDIM1 %.1f def\n",(xx - dborder));
      printf("/YDIM2 %.1f def\n",(xx - dborder));
      printf("/YDIM3 %.1f def\n",(xx - dborder - dtmp));
      printf("/YDIM4 %.1f def\n",(xx - dborder - dtmp));
      printf("/YDIM5 %.1f def\n",(xx - dborder - 2.0 * dtmp));
      printf("/YDIM6 %.1f def\n",(xx - dborder - 2.0 * dtmp));
     }
  }

if (g_num_plots == 8)
  {
   printf("/XDIM1 %.1f def\n",dborder);
   printf("/XDIM2 %.1f def\n",yy2);
   printf("/XDIM3 %.1f def\n",dborder);
   printf("/XDIM4 %.1f def\n",yy2);
   printf("/XDIM5 %.1f def\n",dborder);
   printf("/XDIM6 %.1f def\n",yy2);
   printf("/XDIM7 %.1f def\n",dborder);
   printf("/XDIM8 %.1f def\n",yy2);

   dtmp = (xx - 2.0 * dborder) / 4.0;
   printf("/YDIM1 %.1f def\n",(xx - dborder));
   printf("/YDIM2 %.1f def\n",(xx - dborder));
   printf("/YDIM3 %.1f def\n",(xx - dborder - dtmp));
   printf("/YDIM4 %.1f def\n",(xx - dborder - dtmp));
   printf("/YDIM5 %.1f def\n",(xx - dborder - 2.0 * dtmp));
   printf("/YDIM6 %.1f def\n",(xx - dborder - 2.0 * dtmp));
   printf("/YDIM7 %.1f def\n",(xx - dborder - 3.0 * dtmp));
   printf("/YDIM8 %.1f def\n",(xx - dborder - 3.0 * dtmp));
  }

if (g_num_plots == 9)
  {
   dtmp = (yy - 2.0 * dborder) / 3.0;
   printf("/XDIM1 %.1f def\n",dborder);
   printf("/XDIM2 %.1f def\n",dborder);
   printf("/XDIM3 %.1f def\n",dborder);
   printf("/XDIM4 %.1f def\n",(dborder + dtmp));
   printf("/XDIM5 %.1f def\n",(dborder + dtmp));
   printf("/XDIM6 %.1f def\n",(dborder + dtmp));
   printf("/XDIM7 %.1f def\n",(dborder + 2.0 * dtmp));
   printf("/XDIM8 %.1f def\n",(dborder + 2.0 * dtmp));
   printf("/XDIM9 %.1f def\n",(dborder + 2.0 * dtmp));

   dtmp = (xx - 2.0 * dborder) / 3.0;
   printf("/YDIM1 %.1f def\n",dborder);
   printf("/YDIM2 %.1f def\n",(dborder + dtmp));
   printf("/YDIM3 %.1f def\n",(dborder + 2.0 * dtmp));
   printf("/YDIM4 %.1f def\n",dborder);
   printf("/YDIM5 %.1f def\n",(dborder + dtmp));
   printf("/YDIM6 %.1f def\n",(dborder + 2.0 * dtmp));
   printf("/YDIM7 %.1f def\n",dborder);
   printf("/YDIM8 %.1f def\n",(dborder + dtmp));
   printf("/YDIM9 %.1f def\n",(dborder + 2.0 * dtmp));
  }

printf("end\n");
printf("%%%%Page: 1 1\n");
printf("%%%%EndProlog\n");
printf("multiplt begin\n");
}
/***********************************************************************/
void	header(filenum)
int     filenum;
{
double  dtmp, dborder, xx, yy;

dborder = BORDER;

printf("gsave\n");
printf("XDIM%d YDIM%d translate\n",filenum,filenum);

if (g_num_plots == 1 || g_num_plots == 4 || g_num_plots == 9)
   printf("0 rotate\n");
else
   printf("-90 rotate\n");

/* default for g_num_plots == 1 */

xx = g_xx_output / g_xx_image;
yy = g_yy_output / g_yy_image;

if (g_num_plots == 2)
  {
   xx = (g_yy_output - 2.0 * dborder) / g_xx_image;
   yy = (g_xx_output / 2.0 - dborder) / g_yy_image;
  }

if (g_num_plots == 3)
  {
   dtmp = PLOT_3_BORDER * 2.0 * g_yy_output;
   xx = (g_yy_output - dtmp) / g_xx_image;
   yy = (g_xx_output - 2.0 * dborder) / (3.0 * g_yy_image);
  }

if (g_num_plots == 4)
  {
   xx = (g_xx_output / 2.0 - dborder) / g_xx_image;
   yy = (g_yy_output / 2.0 - dborder) / g_yy_image;
  }

if (g_num_plots == 6)
  {
   xx = (g_yy_output / 2.0 - dborder) / g_xx_image;

   if (g_letter_flag)
     {
      yy = g_6_plot_factor / g_yy_image;
     }
   else
     {
      yy = (g_xx_output - 2.0 * dborder) / (3.0 * g_yy_image);
     }
  }

if (g_num_plots == 8)
  {
   xx = (g_yy_output / 2.0 - dborder) / g_xx_image;
   yy = (g_xx_output - 2.0 * dborder) / (4.0 * g_yy_image);
  }

if (g_num_plots == 9)
  {
   xx = (g_xx_output - 2.0 * dborder) / (3.0 * g_xx_image);
   yy = (g_yy_output - 2.0 * dborder) / (3.0 * g_yy_image);
  }

printf("%.5f %.5f scale\n",yy,xx);
}
/***********************************************************************/
void	trailer()
{
printf("end\n");
printf("showpage\n");
printf("%%%%Trailer\n");
printf("%%%%Pages: 1\n");
}
/***********************************************************************/
char	*replace_crlf(s)
char 	*s;
{
char *p;

p = s;

while (1)
  {
   if (*p == 0 || *p == 0x0A || *p == 0x0D)  break;
   p++;
  }
*p = '\0';
return(s);
}
/***********************************************************************/
/*
 *      this function will convert a string to lowercase
 */
char    *lowercase(s)
char    *s;
{
char    *p;

p = s;

while (1)
  {
   if (*p >= 'A' && *p <= 'Z')
     *p += 'a' - 'A';

   if (*p++ == '\0')  break;
  }
return(s);
}
/***********************************************************************/
/*    returns char position of first occurence of s2 in s1
	  or -1 if no match found
*/
int	strposition(s1,s2)
char    *s1, *s2;
{
register char  ch1, ch2;
char           *p0, *p1, *p2;
int            ct;

ct = -1;
p0 = s1;

if (*s2 == '\0')  return(-1);

while (1)
  {
   ct++;
   p1  = p0;
   p2  = s2;
   ch2 = *p2;
   
   while (1)                       /* scan until first char matches */
     {
      if ((ch1 = *p1) == '\0')  return(-1);
      if (ch1 == ch2)           break;
      p1++;
      ct++;
     }

   p2++;                           /* check remainder of 2 strings */
   p1++;
   p0 = p1;

   while (1)
     {
      if ((ch2 = *p2) == '\0')  return(ct);
      if (*p1 != ch2)           break;
      p1++;
      p2++;
     }
  }
}
/***********************************************************************/
