;OBSESSiON Mini Debugger version 1.0 [01/01]
;
;This is just an example in how to make your
;own debugger, or at least how to use int 03
;Fully assembler source included. *FREEWARE*
;
; by           
;                
;                     
;              1997
;[BUGSY/OBSESSiON]
; Contract us at :
;   EMAIL : bugsy@cybernet.dk
;   WWW   : www.cybernet.dk/users/bugsy
;
;

			.model tiny
			.386p
			smart
			stack 200h
			version t310 ; If your tasm version is less than
                                     ; version 3.1 please delete this line.

			.data

CopyrightStr     db   'Mini tracer version 1.0 by BUGSY of OBSESSION (c) 1995', 10, 13, 36
V8086		 db   'Can''t run while processor is in V8086 mode. Unload all memory driveres', 10, 13, 36

			.code

; Use INT 02 to start and stop tracing.
; And remember that this is just an example in how to use INT 03 debugging

Proc     Init Near
  mov    ax, @Data
  mov    ds, ax

  push   ds

  mov    ah, 09h
  lea    dx, CopyrightStr
  int    21h

  smsw   ax
  and    ax, 1
  jz     NoPMode

  lea    dx, V8086
  mov    ah, 09h
  int    21h
  mov    ax, 4c01h
  int    21h

NoPMode:
  cli
  mov    ax, cs
  mov    ds, ax

  mov    ax, 2501h
  lea    dx, SingleStepVec
  int    21h                         ; set new int 01h vector

  mov    ax, 2502h
  lea    dx, NMIVec
  int    21h                         ; set new int 02h vector
  sti

  pop    ds

  mov    ax, es                      ; ProgSize = SS - PSP + (SP div 10h) + 1
  mov    bx, SS
  sub    bx, ax
  mov    cx, SP
  shr    cx, 04h
  inc    cx
  add    bx, cx
  mov    ah, 4Ah
  int    21h                         ; Free all unused memmory

  mov    ax, 3100h                   ; terminate but stay resident
  mov    dx, bx                      ; dx = size of program in paragraphs
  int    02h                         ; Start the tracer
  int    21h                         ; Go TSR
EndP     Init

Proc     SingleStepVec Far
  mov    word ptr cs:OldStack, sp    ; Save old stack
  mov    word ptr cs:OldStack+2, ss

  lss    sp, cs:MySPtr               ; Set new stack

  pusha                              ; Save ALL regs
  push   es ds
  mov    ax, @Data                   ; Setup data seg
  mov    ds, ax

  les    di, cs:[OldStack]           ; es:di points to original stack
  and    word ptr es:[di+4], 0FEFFh  ; Set trap flag on return
  cmp    cs:trace, 0
  je     NoMoreTrace
  or     word ptr es:[di+4], 0100h   ; Set trap flag on return

NoMoreTrace:
  les    di, es:[di]                 ; es:di address for next instruction
  mov    bl, byte ptr es:[di]
  cmp    bl, 0cdh                    ; Next instruction INT ?
  jne    NoInt

  les    di, cs:[OldStack]           ; es:di points to original stack
  add    word ptr es:[di], 0002h     ; add 2 to return address

  xor    ax, ax
  mov    es, ax
  mov    bl, bh
  xor    bh, bh
  shl    bx, 2

  les    di, es:[bx]
  mov    word ptr cs:IntAdd, di
  mov    word ptr cs:IntAdd+2, es

  pop    ds es
  popa
  lss    sp, cs:[OldStack]
  mov    cs:SaveBX, bx
  mov    bx, sp
  push   word ptr ss:[bx+4]
  push   dword ptr cs:[IntAdd]
  mov    bx, cs:SaveBX
  iret

NoInt:
  pop    ds es
  popa
  lss    sp, cs:[OldStack]
  iret
EndP     SingleStepVec

Proc     NMIVec Far
  not    cs:Trace
  jz     NoTrapFlag

  pushf
  mov    bp, sp
  or     word ptr ss:[bp], 0100h     ; set trap flag
  popf

NoTrapFlag:
  iret
EndP     NMIVec

OldStack dd     ?
SaveBX   dw     ?
IntAdd   dd     ?
Trace    db     0
MySPtr   dd     @Code:MyStack + size MyStack
MyStack  db     200h dup (90h)

End Init
