//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVAPP.CPP                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Power View Application implementation|
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_app
#define uses_dc
#define uses_icons
#define uses_system

#define DECLARE_PVAPP
#include "PVuses.h"
#undef DECLARE_PVAPP

static Tcmd_handler _cmd_handler = NULL;
static Tcommands *old_commands = (Tcommands *) MKFP( 0, 1 );

static Titem *need_update = NULL;

static int cursor_hides = 0;

void hide_cursor( void )
{
#ifndef HGR
  if( !cursor_hides++ ) set_cursor( no_cursor );
#endif
}

void show_cursor( void )
{
  --cursor_hides;
}

void req_update( Titem *p )
{
  Titem *i;

  i = need_update;
  while( i != NULL )
  {
    if( i == p ) return;
    i = i->owner;
  }
  need_update = p;
}

void cancel_update( Titem *p )
{
  Titem *i;

  i = need_update;
  while( i != NULL )
  {
    if( i == p )
    {
      need_update = NULL;
      return;
    }
    i = i->owner;
  }
}

static void app_idle( unsigned long time_passed )
{
  if( old_commands != get_cmd() )
  {
    old_commands = get_cmd();
    modal_broadcast( cmAPP_COMMANDS_CHANGED );
  }
  if( need_update != NULL )
  {
    need_update->optimize_bounds();
    need_update = NULL;
  }
  if( !time_passed )
  {
    if( modal_item != NULL ) application->update_cursor();
    application->refresh_screen();
  }
#ifdef MEMMON
  memavail( mem_avail );
#endif
}

//Tapplication publics:

Tapplication::Tapplication( void ):
  Titem( scr_columns, scr_rows )
{
  state_word |= ( isSELECTED+isALIVE+isACCESSABLE );
  desktop_x  = 0;  desktop_y  = 0;
  desktop_xl = xl; desktop_yl = yl;
  master_modal = NEW(Tmaster_modal);
  put_in( master_modal, 0, 0 );
  hook_idle( app_idle );
}

void Tapplication::resize( int newxl, int newyl )
{
  int old_xl, old_yl;

  desktop_x  = 0;     desktop_y  = 0;
  desktop_xl = newxl; desktop_yl = newyl;
  old_xl = xl; old_yl = yl;
  Titem::resize( newxl, newyl );
  master_modal->resize( 0, 0 );
  screen_dc->set_region( 0, 0, old_xl, old_yl );
  screen_dc->validate();
  redraw();
}

static uint m;
static void all_items_or( Titem *group )
{
  Titem *p;

  m |= group->event_mask;
  p = group->first();
  while( p != NULL )
  {
    all_items_or( p );
    p = p->nextl();
  }
}

void Tapplication::update_events_mask( void )
{
  if( application != NULL )
  {
    m = 0;
    all_items_or( this );
    set_system_events_mask( m );
  }
}

void Tapplication::or_events_mask( Titem *p )
{
  set_system_events_mask( get_system_events_mask() | p->event_mask );
}

void Tapplication::refresh_screen( void )
{
  int xx, yy;
  Tdc *bufdc;

  if( xl!=scr_columns || yl!=scr_rows ) resize( scr_columns, scr_rows );
  xx = screen_dc->region_xl; yy = screen_dc->region_yl;
  if( ( xx <= 0 ) || ( yy <= 0 ) ) return;
  bufdc = NEW( Tdc( xx, yy ) );
  bufdc->x = screen_dc->region_x;
  bufdc->y = screen_dc->region_y;
//text_attr = 0xCF; bufdc->fill_dc( ' ' ); bufdc->draw(); delay( 10 );
  set_dc( bufdc );
  paint();
  set_dc( screen_dc );
  bufdc->draw();
  DELETE( bufdc );
  screen_dc->validate();
}

void Tapplication::update_cursor( void )
{
  Titem *p, *l, *t;
  int cursor_type;
  int cursor_x, cursor_y, cx, cy;

  p = modal_item;
  if( ( p == NULL ) || ( cursor_hides != 0 ) ) goto hide;
  while( p->current != NULL ) p = p->current;
  cursor_type = p->curs_type;
  cursor_x = p->curs_x;
  cursor_y = p->curs_y;
  if( ( cursor_type == 0 ) ||
      ( cursor_x < 0 ) || ( cursor_x >= p->xl ) ||
      ( cursor_y < 0 ) || ( cursor_y >= p->yl ) ) goto hide;
  while( p->owner != NULL )
  {
    if( !p->state( isALIVE ) ) goto hide;
    cursor_x += p->x;
    cursor_y += p->y;
    t = p;
    l = p = p->owner->last;
    do
    {
      p = p->next; if( !p->state( isALIVE ) ) continue;
      if( p == t ) break;
      cx = cursor_x - p->x; cy = cursor_y - p->y;
      if( ( cx >= 0 ) && ( cx < p->xl ) &&
          ( cy >= 0 ) && ( cy < p->yl ) ) goto hide;
    }
    while( p != l );
    p = p->owner;
  }
  if( cursor_type == 1 )
    set_cursor( insert_cursor );
  else
    set_cursor( over_cursor );
  goto update;
hide:
  set_cursor( no_cursor );
update:
  screen_dc->set_base( cursor_x, cursor_y );
  screen_dc->update_cursor();
}

//Tapplication protected

void Tapplication::event_handler( Tevent &ev )
{
  if( first() != master_modal ) pop_item( master_modal );
  if( ev.code != evCOMMAND )
    Titem::event_handler( ev );
  else
  {
    switch( ev.CMD_CODE )
    {
      case cmAPP_QUIT:
        stop(cmAPP_QUIT);
        break;
      case cmAPP_REDRAW:
#if !defined( NOICONS ) && !defined( HGR )
        restore_graph_chars();
        set_graph_chars();
#endif
        redraw();
        break;
      default:
        if( _cmd_handler != NULL ) _cmd_handler( ev.CMD_CODE, ev.CMD_INFO );
        return;
    }
    handled( ev );
  }
}

void Tapplication::get_event( Tevent &ev )
{
  union REGS r;

  loop:
    Titem::get_event( ev );
    if( ev.code == evNOTHING )
    {
      idle( ev.TIME_PASSED );
      refresh_screen();
      INTR( 0x28, &r, &r );
      goto loop;
    }
    master_modal->handle_event( ev );
    if( ev.code == evNOTHING ) goto loop;
}

//Tmaster_modal private

Tmaster_modal::Tmaster_modal( void ):
  Titem( 0, 0 )
{
  set_events_mask( ~evCOMMAND, 0 );
  set_state( isON_TOP, 1 );
  set_flags( ifSELECTABLE, 0 );
  set_flags( ifPRE_PROCESS, 1 );
}

//PVapp publics:

void commands_changed( void )
{
  old_commands = (Tcommands *) MKFP( 0, 1 );
}

static int dialog_x = xCENTER;
static int dialog_y = yCENTER;

void _dialog_xy( int x, int y )
{
  dialog_x = x;
  dialog_y = y;
}

void __dialog_xy( int &x, int &y )
{
  x = dialog_x;
  y = dialog_y;
  dialog_x = xCENTER;
  dialog_y = yCENTER;
}

uint exec_dialog( Titem *p )
{
  int dx, dy;
  uint result;

  if( ( application != NULL ) && is_valid( p ) )
  {
    __dialog_xy( dx, dy );
    if( dx == xCENTER ) dx = ( desktop_xl - p->xl ) >> 1;
    if( dy == yCENTER ) dy = ( desktop_yl - p->yl ) >> 1;
    result = application->exec_item( p, desktop_x + dx, desktop_y + dy );
    application->refresh_screen();
    return result;
  }
  return cmCANCEL;
}

Tidle hook_idle( Tidle p )
{
  Tidle result;

  result = idle;
  idle = p;
  return result;
}

void cmd_handler( Tcmd_handler p )
{
  _cmd_handler = p;
}

//STARTUP FUNCTIONS

static void tini_application( void )
{
  if( application != NULL ) DELETE( application );
  application = NULL;
}

void __init_application( void )
{
  application = NEW( Tapplication );
  atexit( tini_application );
}

void __resize_application( void )
{
  application->resize( application->xl, application->yl );
}
