//******************************************************************************
// MATH library: INTEGER 16.16 routines                                       **
//                                                                            **
// Copyright 1997 Adept Software, All Rights Reserved                         **
//******************************************************************************

#ifndef MTH_INT_H
	#define MTH_INT_H

	#include "Adept.H"

//**************************************
// GLOBAL CONSTANTS

	// 16.16 format variables
	#define MTH_1			65536
	#define MTH_QUAD		1073741824	// maxang /4
	#define MTH_QUAD2		2147483648
	#define MTH_QUAD3		3221225472
//	#define MTH_QUAD2		(MTH_QUAD*2)
//	#define MTH_PI			205888
//	#define MTH_2PI			(MTH_PI*2)
//	#define MTH_PI2			(MTH_PI/2)

	#define MTH_SINENTRIES		256
	#define MTH_ANGLE_REDUCE	4194304	// maxang(4294967296) /(sinentries(256)*quadrants(4))

	#define MTH_AngleReduce(Angle,DirMax)	((MTH_Reduce(Angle+MTH_QUAD2/DirMax))*DirMax/MTH_1)

	#define MTH_16(Value)	((Value)*MTH_1)

//**************************************
// GLOBAL VARIABLES

	#undef GLOBAL
	#ifdef MTH_INT_C
		#define GLOBAL
	#else
		#define GLOBAL	extern
	#endif

	GLOBAL	word	MTH_SinTable[];

//**************************************
// GLOBAL ROUTINES

	void	MTH_AngleToXY			(angle Angle,sint16 Value,sint16 *XVal,sint16 *YVal);

	//******************************************************************************
	// BASIC

	word	MTH_Reduce		(int16 Value);
	#pragma aux MTH_Reduce=			\
		"shr eax, 16"				\
		parm [eax]					\
		value [ax];

	sword	MTH_IReduce		(sint16 Value);
	#pragma aux MTH_IReduce=		\
		"sar eax, 16"				\
		parm [eax]					\
		value [ax];

	//**************************************

	int16	MTH_Mul			(int16 Value,int16 Multiplier);
	#pragma aux MTH_Mul=			\
		"mul	edx"				\
		"shrd	eax, edx, 16"		\
		parm	[eax] [edx]			\
		value	[eax];

	sint16	MTH_IMul		(sint16 Value,sint16 Multiplier);
	#pragma aux MTH_IMul=			\
		"imul	edx"				\
		"shrd	eax, edx, 16"		\
		parm	[eax] [edx]			\
		value	[eax];

		// multiply that returns quad word
	/*
		qword	MTH_DMul		(int16 Value,int16 Multiplier);
		#pragma aux MTH_DMul=			\
			"mul	edx"				\
			parm	[eax] [edx]			\
			value	[edx eax];
	*/

	int16	MTH_Div			(int16 Dividend,int16 Divisor);
	#pragma aux MTH_Div parm [eax] [ebx] modify [edx] value [eax]=\
		"xor	edx, edx"			\
		"shld	edx, eax, 16"		\
		"shl	eax, 16"			\
		"div	ebx";

	sint16	MTH_IDiv		(sint16 Dividend,sint16 Divisor);
	#pragma aux MTH_IDiv parm [eax] [ebx] modify [edx] value [eax]=\
		"cdq"						\
		"shld	edx, eax, 16"		\
		"sal	eax, 16"			\
		"idiv	ebx";

	int16	MTH_Ratio		(int16 Value,int16 Multiplier,int16 Divisor);
	#pragma aux MTH_Ratio parm [eax] [edx] [ebx] value [eax]=\
		"mul	edx"				\
		"div	ebx";

	sint16	MTH_IRatio		(sint16 Value,sint16 Multiplier,sint16 Divisor);
	#pragma aux MTH_IRatio parm [eax] [edx] [ebx] value [eax]=\
		"imul	edx"				\
		"idiv	ebx";

	//******************************************************************************
	// TRIGONOMETRY

/*
	sint16  MTH_VectorSin		(sint16 Vector1X,sint16 Vector1Y, sint16 Vector2X,sint16 Vector2Y);
	#pragma aux MTH_VectorSin parm [EAX] [EBX] [ECX] [EDX]	\
			value [EAX]				\
			modify [EBX ECX EDX];
	cos(vector A,vector B)=(A*B)/(len(A)*len(B))
*/

	//**************************************
	// TABLE-BASED
	void	MTH_AngleToXY	(angle Angle,sint16 Value,sint16 *XVal,sint16 *YVal);
	#pragma aux MTH_AngleToXY parm [EAX] [ECX] [ESI] [EDI]	\
			modify [EBX EDX];

	sint16	MTH_Sin	(angle Angle);
	#pragma aux MTH_Sin parm [EAX]	\
			value [EAX]				\
			modify [EBX ECX EDX];

	#define MTH_Cos(Angle)		(MTH_Sin(Angle+MTH_QUAD))

	sint16	MTH_Tan	(angle Angle);
	#pragma aux MTH_Tan parm [EAX]	\
			value [EAX]				\
			modify [EBX ECX EDX];

	angle	MTH_ASin	(sint16 Value);
	#pragma aux MTH_ASin parm [EAX]\
			value [EAX]				\
			modify [EBX ECX EDX];

	#define MTH_ACos(Value)		(MTH_ASin(Value)-MTH_QUAD)

	angle	MTH_ATan	(sint16 X,sint16 Y);
	#pragma aux MTH_ATan parm [EBX] [EAX]	\
			value [EAX]						\
			modify [ECX EDX ESI EDI];

	//******************************************************************************
	// MISC

	// square root
	int16	MTH_Sqrt		(int16 Number);
	#pragma aux MTH_Sqrt parm [EBX]	\
			modify [ECX EDX ESI EDI]\
			value [EAX];
	int16	MTH_DSqrt		(int16 Whole,int16 Frac);
	#pragma aux MTH_DSqrt parm [EBX] [EDI]	\
			modify [ECX EDX ESI]	\
			value [EAX];

	int16	MTH_2D_Dist		(sint16 XDelta,sint16 YDelta);
	#pragma aux MTH_2D_Dist parm [EAX] [EBX]	\
			modify [ECX EDX ESI EDI]	\
			value [EAX];
	int16	MTH_3D_Dist		(sint16 XDelta,sint16 YDelta,sint16 ZDelta);
	#pragma aux MTH_3D_Dist parm [EAX] [EBX] [ECX]	\
			modify [EDX ESI EDI]	\
			value [EAX];

	#pragma intrinsic(MTH_Reduce,MTH_IReduce,MTH_Mul,MTH_IMul,MTH_Div,MTH_IDiv,MTH_Ratio,MTH_IRatio)

#endif

