//******************************************************************************
// ADEPT SOFTWARE STANDARD LIBRARY                                            **
//                                                                            **
// Copyright 1997 Adept Software, All Rights Reserved                         **
//******************************************************************************

#ifndef ADEPT_H
	#define ADEPT_H

	#ifdef WINDOWS
		#include <windows.h>
		#include <stdarg.h>
		#include <stddef.h>
		#include <stdio.h>
		#include <stdlib.h>
		#include <string.h>
	#else
		#include <ctype.h>
		#include <dos.h>
		#include <stdarg.h>
		#include <stddef.h>
		#include <stdio.h>
		#include <stdlib.h>
		#include <string.h>
	#endif

//******************************************************************************
//******************************************************************************
// DATA TYPES

	#define FALSE	0
	#define TRUE	1
	#define NULLVAL	0x80000000

	typedef unsigned char	flag;
	typedef unsigned char	byte;
	typedef signed char		sbyte;
	typedef unsigned short	word;
	typedef signed short	sword;
	typedef unsigned long	dword;
	typedef signed long		sdword;

	// NEW MATH
	typedef	unsigned long	int16;
	typedef	signed long		sint16;
	typedef	unsigned long	angle;

/*
	typedef struct
	{
		dword	Frac,Whole;
	} qword;
	typedef struct
	{
		sdword	Frac,Whole;
	} sqword;
*/

	//**************************************
	// SPECIAL DATA TYPES

		typedef struct
		{
			sdword	PosX,PosY;
		} POINT1;

		typedef struct
		{
			sdword	PosX,PosY,SizeX,SizeY;
		} RECT1;

		typedef struct
		{
			void	*Buffer;
			sdword	SizeX,SizeY;
		} BITMAP1;

//******************************************************************************
//******************************************************************************
// CONSTANTS

	// colors
	enum
	{
		BLACK,BLUE,GREEN,CYAN,RED,MAGENTA,BROWN,LIGHTGRAY,
		DARKGRAY,LIGHTBLUE,LIGHTGREEN,LIGHTCYAN,LIGHTRED,LIGHTMAGENTA,YELLOW,WHITE,
		BLINK=128
	};
	// ascii characters
	enum
	{
		CH_NUL,CH_SOH,CH_STX,CH_ETX,CH_EOT,CH_ENQ,CH_ACK,CH_BELL,
		CH_BACKSPACE,CH_TAB,CH_LINEFEED,CH_VT,CH_FORMFEED,CH_ENTER,CH_SO,CH_SI,
		CH_DLE,CH_DC1,CH_DC2,CH_DC3,CH_DC4,CH_NAK,CH_SYN,CH_ETB,
		CH_CAN,CH_EM,CH_SUB,CH_ESCAPE,CH_FS,CH_GS,CH_RS,CH_US,
	};

	//**************************************
	// SPECIAL CONSTANTS

		// INTERRUPT CONTROLLER REGISTERS
		#define ICR_REG1					0x20
		#define ICR_REG2					0xA0
		#define   ICR_READ_IRR				0x0A
		#define   ICR_READ_ISR				0x0B
		#define   ICR_NOP					0x40
		#define   ICR_EOI					0x20
		#define   ICR_SPECIFIC_EOI			0x60
		#define   ICR_SET_PRIORITY_HIGH0	0xC7
		#define   ICR_SET_PRIORITY_HIGH7	0xC6
		#define   ICR_SET_PRIORITY_HIGH6	0xC5
		#define   ICR_SET_PRIORITY_HIGH5	0xC4
		#define   ICR_SET_PRIORITY_HIGH4	0xC3
		#define   ICR_SET_PRIORITY_HIGH3	0xC2
		#define   ICR_SET_PRIORITY_HIGH2	0xC1
		#define   ICR_SET_PRIORITY_HIGH1	0xC0
		#define   ICR_SPECIAL_MASK_CLEAR	0x48
		#define   ICR_SPECIAL_MASK_SET		0x68
		// clear bits in IMR mean IRQ is enabled
		#define IMR_REG1					0x21
		#define IMR_REG2					0xA1

//		#define IODELAY()					inp(IMR_REG1)

//******************************************************************************
//******************************************************************************
// MACROS

	#define toggle(Var)			(Var=!(Var))
	#define incmax(Var,Max)		(Var=(++(Var)>=(Max))? Max : Var)
	#define incwrap(Var,Max)	(Var=(++(Var)>=(Max))? 0 : Var)
	#define ptradd(Ptr,Value)	((void*) ((byte*)Ptr+(Value)) )
	#define bitson(Var,Bits)	(Var=(Var)|(Bits))
	#define bitsoff(Var,Bits)	(Var^=(Var)&(Bits))
	#define bitstoggle(Var,Bits)	(Var^=(Bits))

	#define makeword(Byte1,Byte2)	((word)(Byte1)|((word)(Byte2)<<8))
	#define makedword(Byte1,Byte2,Byte3,Byte4)	((sdword)(Byte1)|((sdword)(Byte2)<<8)|((sdword)(Byte3)<<16)|((sdword)(Byte4)<<24))

	#define invertword(Word)	(((word)_byte0(Word)<<8)|((word)_byte1(Word)))
	#define invertdword(DWord)	(((dword)_byte0(DWord)<<24)|((dword)_byte1(DWord)<<16)|((dword)_byte2(DWord)<<8)|((dword)_byte3(DWord)))

	#define _byte0(Number)		(((byte*)&(Number))[0])
	#define _byte1(Number)		(((byte*)&(Number))[1])
	#define _byte2(Number)		(((byte*)&(Number))[2])
	#define _byte3(Number)		(((byte*)&(Number))[3])
	#define _word0(Number)		(((word*)&(Number))[0])
	#define _word1(Number)		(((word*)&(Number))[1])
	#define _dword0(Number)		(((dword*)&(Number))[0])

	//**************************************
	// SPECIAL MACROS

		#define strcpymax(Dest,Src,Max)		(strncpy((Dest),(Src),(Max)),((byte*)(Dest))[(Max)-1]=0)

		#define _makeflatptr(Ptr)	((void*)( ((dword)((dword)(Ptr)>>16)<<20) + (word)(Ptr) ))
		#define _makesegptr(Ptr)	((dword)( (dword)((_byte0(Ptr)&0x0000000F) | ( (((dword)_word1(Ptr) +((dword)_word0(Ptr)>>4)) <<16) ) ))
		#define _real_seg(Ptr)		((word)( ((dword)(Ptr))>>4 ))
		#define _real_off(Ptr)		((word)( ((dword)(Ptr))&0x0F ))

		#define _voidptr(Pointer)	(((void**)&(Pointer))[0])

/*		#define biosrtn(inter,_eax,_ebx,_ecx,_edx)	\
			{union	REGPACK	RegData;memset(&RegData,0,sizeof(union REGPACK));	\
			RegData.x.eax=_eax; RegData.x.ebx=_ebx; RegData.x.ecx=_ecx; RegData.x.edx=_edx;	\
			intr(inter,&RegData);}
*/

		// 4gw cli and sti, regular cli and sti can be slower  900h:cli  901h:sti
		dword	_cli(void);
		#pragma aux _cli value [eax]=\
			"mov  eax, 900h"	\
			"int  31h";

		dword	_sti(void);
		#pragma aux _sti value [eax]=\
			"mov  eax, 901h"	\
			"int  31h";

		void	_cliprev(dword);
		#pragma aux _cliprev parm [eax]=\
			"int  31h";

		#define INT_START		{dword PrevCli=_cli();do{
		#define INT_END			}while(FALSE);_cliprev(PrevCli);}

//******************************************************************************
//******************************************************************************
// ROUTINES

	POINT1	POINT1make		(sdword PosX,sdword PosY);
	RECT1	RECT1make		(sdword PosX,sdword PosY,sdword SizeX,sdword SizeY);
	BITMAP1	BITMAP1make		(void *Buffer,dword SizeX,dword SizeY);
	void	*BITMAP1_Encap	(BITMAP1 *Bitmap,dword *SizePtr);
	BITMAP1	*BITMAP1_Decap	(void *Capsule,dword Size);

	flag	ClipRect		(RECT1 Clipper,RECT1 Rect,RECT1 *Result,sdword *IndexXPtr,sdword *IndexYPtr);

	void	*MemAlloc		(dword Size);
	void	MemReAlloc		(void **BufferPtr,dword Size);
	void	MemFree1		(void *Buffer);
	#define MemFree(Buffer)	MemFree1(Buffer),Buffer=NULL

	#ifndef WINDOWS
	dword	fastint			(dword IntNum,dword eax,dword ebx,dword ecx,dword edx);
	#endif
	
	#pragma intrinsic		(POINT1make,RECT1make,BITMAP1make,StrCopy)

//**************************************
// ADEPT LIBRARY STANDARD INCLUDES

	#include "Err_Main.H"
	#include "Mth_Int.H"
	#include "Dat_Link.H"
	#include "Fil_Main.H"

#endif
