Program PlayDigi;

Uses Crt, DigiSnd;

Var
  Resplay : ResplayObject;
  FileName : String;
  Ch : Char;
  Freq, Temp : Integer;


{main program}
begin
  WriteLn('Playback Sample - by Alex Boisvert');
  WriteLn('==================================');
  WriteLn;
  If (ParamCount < 1) or (ParamStr(1)='') then begin
    Write(' Enter filename: ');
    ReadLn(FileName);
  end else FileName := ParamStr(1);
  Val(ParamStr(2),Freq,Temp);
  If (ParamCount < 2) or (Freq = 0) then begin
    Write(' Enter frequency in kHz: ');
    ReadLn(Freq);
  end;
  WriteLn(' Memory Available: ',(MemAvail/1024):0:0,'k');
  Resplay.Init;
  if not Resplay.Setup(0,4, Freq * 4) then begin
    WriteLn(' Cannot Initialize Resplay!');
    Halt;
  end;
  Resplay.Load(FileName);
  WriteLn(' Size of digital sample: ',(Resplay.SoundSize/1024):0:0,'k');
  If not Resplay.EntireFileLoaded then WriteLn(' Entire file not loaded.');
  Resplay.Play;
  Resplay.Done;
  WriteLn(' Done.');
  WriteLn;
end.
