Program Make_Error_descriptor_List;
(*Copyright (c) 1992 KHIRON Software

  All rights reserved. KHIRON Software hereby grants
  permission for free distribution of this software,
  and for use of this software within commercial and
  non-commercial applications. This software itself
  may not be distributed commercially without obtaining
  written permission from KHIRON Software.

  Should you use this software or it's techniques in commercial
  products send me a postcard at the following address to fulfill
  a licensing commitment:

    Richard A. Morris
    C/- KHIRON Software
    P.O. Box 544
    INDOOROOPILLY Qld 4068
    AUSTRALIA
*)
(* This program creates a resourcefile called Errors.Stm which contains a
   tStringList containing standard Turbo Pascal RunTime Error descriptions
   to provide information when your program exits with a runtime error
*)
Uses Objects;
Procedure MakeStringList;
Var
  ErrorStrings : pStrListMaker;
  ErrorStream  : pStream;
  ErrorResource: pResourceFile;
begin
  ErrorStream := New(pBufStream,Init('ERRORS.STM',stCreate,1024));
  ErrorResource := New(pResourceFile,Init(ErrorStream));
  ErrorStrings := new(PStrListMaker,Init(65520,257));
  ErrorStrings^.Put(0,'Program Terminated');
  ErrorStrings^.Put(1,'Invalid DOS function code');
  ErrorStrings^.Put(2,'File not found');
  ErrorStrings^.Put(3,'Path not found');
  ErrorStrings^.Put(4,'Too many open files');
  ErrorStrings^.Put(5,'File access denied');
  ErrorStrings^.Put(6,'Invalid file handle');
  ErrorStrings^.Put(8,'Not enough memory');
  ErrorStrings^.Put(10,'Invalid environment');
  ErrorStrings^.Put(11,'Invalid format');
  ErrorStrings^.Put(12,'Invalid file access code');
  ErrorStrings^.Put(15,'Invalid drive number');
  ErrorStrings^.Put(16,'Cannot remove current directory');
  ErrorStrings^.Put(17,'Cannot rename across drives');
  ErrorStrings^.Put(18,'No more files');
  ErrorStrings^.Put(100,'Disk read error');
  ErrorStrings^.Put(101,'Disk write error');
  ErrorStrings^.Put(102,'File not assigned');
  ErrorStrings^.Put(103,'File not open');
  ErrorStrings^.Put(104,'File not open for input');
  ErrorStrings^.Put(105,'File not open for output');
  ErrorStrings^.Put(106,'Invalid numeric format');
  ErrorStrings^.Put(150,'Disk is write-protected');
  ErrorStrings^.Put(151,'Unknown unit');
  ErrorStrings^.Put(152,'Drive not ready');
  ErrorStrings^.Put(153,'Unknown command');
  ErrorStrings^.Put(154,'CRC error in data');
  ErrorStrings^.Put(155,'Bad Drive request structure length');
  ErrorStrings^.Put(156,'Disk seek error');
  ErrorStrings^.Put(157,'Unknown media type');
  ErrorStrings^.Put(158,'Sector not found');
  ErrorStrings^.Put(159,'Printer out of Paper');
  ErrorStrings^.Put(160,'Device write fault');
  ErrorStrings^.Put(161,'Device read fault');
  ErrorStrings^.Put(162,'Hardware failure');
  ErrorStrings^.Put(200,'Division by zero');
  ErrorStrings^.Put(201,'Range check error');
  ErrorStrings^.Put(202,'Stack overflow error');
  ErrorStrings^.Put(203,'Heap overflow error');
  ErrorStrings^.Put(204,'Invalid pointer operation');
  ErrorStrings^.Put(205,'Floating point overflow');
  ErrorStrings^.Put(206,'Floating point underflow');
  ErrorStrings^.Put(207,'Invalid floating point operation');
  ErrorStrings^.Put(208,'Overlay manager not installed');
  ErrorStrings^.Put(209,'Overlay file read error');
  ErrorStrings^.Put(210,'Object not initialised');
  ErrorStrings^.Put(211,'Call to abstract method');
  ErrorStrings^.Put(212,'Stream registration error');
  ErrorStrings^.Put(213,'Collection index out of range');
  ErrorStrings^.Put(214,'Collection overflow error');
  ErrorResource^.Put(ErrorStrings,'ERRORDESC');
  Dispose(ErrorResource,Done);
  Dispose(ErrorStrings,Done);
end;
begin
  Registertype(RStrListMaker);
  MakeStringList;
  Writeln('Errors.Stm created');
end.
