(*********************************************)
(*                                           *)
(*          FINDER.PAS     January 99        *)
(*                                           *)
(*                                           *)
(*********************************************)


program finder;
uses crt, pcl4p;

var
   RetCode  : Integer;
   Byte : Char;
   i    : Integer;
   Port : Integer;
   RxBufPtr  : Pointer;
   RxBufSeg  : Word;
   TxBufPtr  : Pointer;
   TxBufSeg  : Word;
   TimeMark  : LongInt;
   Expect    : Char;

procedure SayError( Code : Integer );
var
   RetCode : Integer;
begin
   if Code < 0 then RetCode := SioError( Code )
   else if (Code and (FramingError or ParityError or OverrunError)) <> 0 then
      begin (* Port Error *)
         if (Code and FramingError) <> 0 then writeln('Framing Error');
         if (Code and ParityError)  <> 0 then writeln('Parity Error');
         if (Code and OverrunError) <> 0 then writeln('Overrun Error')
      end
end;

procedure MyHalt( Code : Integer );
var
   RetCode : Integer;
begin
   if Code < 0 then SayError( Code );
   RetCode := SioDone(Port);
   if Code <> 0 then writeln('*** HALTING ***');
   Halt;
end;

begin   (* main program *)
   (* fetch PORT # from command line *)
   if ParamCount <> 0 then
      begin
         writeln('USAGE: "FINDER"');
         halt;
      end;
   (* allocate RX buffer *)  
    GetMem(RxBufPtr,1024+16);
    RxBufSeg := Seg(RxBufPtr^) + ((Ofs(RxBufPtr^)+15) SHR 4);
   if SioInfo('I') > 0 then
      begin
        (* allocate TX buffer *)
        GetMem(TxBufPtr,256+16);
        TxBufSeg := Seg(TxBufPtr^) + ((Ofs(TxBufPtr^)+15) SHR 4);
      end;
   (* look at each port in turn *)  
   for Port := COM1 to COM4 do
      begin
        (* setup 1K receive buffer *)
        RetCode := SioRxBuf(Port, RxBufSeg, Size1024);
        if RetCode < 0 then MyHalt( RetCode );
        if SioInfo('I') > 0 then
          begin
            (* setip transmit buffer *)
            RetCode := SioTxBuf(Port, TxBufSeg, Size256);
            if RetCode < 0 then MyHalt( RetCode );
          end;
        (* reset port *)
        RetCode := SioReset(Port,Baud19200);
        (* was port reset ? *)
        if RetCode <> 0 then
          begin
            write('COM',Port+1,': Cannot reset: ');
            SayError(RetCode);
          end
      else 
          begin
            (* Port successfully reset *)
            writeln;
            writeln('COM',1+Port,': Has been reset.');
            (* specify parity, # stop bits, and word length for port *)
            RetCode := SioParms(Port, NoParity, OneStopBit, WordLength8);
            if RetCode < 0 then MyHalt(RetCode);
            (* set FIFO level if have 16550/16650/16750 *)
            RetCode := SioFIFO(Port, LEVEL_4TH);
            if RetCode < 0 then MyHalt(RetCode);
            RetCode := SioRxClear(Port);
            if RetCode < 0 then MyHalt( RetCode );
            (* set DTR & RTS *)
            RetCode := SioDTR(Port,SET_LINE);
            RetCode := SioRTS(Port,SET_LINE);
            (* send CR *)
            RetCode := SioPutc(Port, chr($0d));
            SioDelay(5);
            (* expect DSR *)
            if SioDSR(Port) = 0 then writeln('  DSR is 0, expected <> 0')
            else
              begin
                (* send AT *)
                writeln('  DSR=1, sending AT ...');
                RetCode := SioPutc(Port,chr($0d));
                SioDelay(5);
                RetCode := SioPutc(Port,'A');
                SioDelay(5);
                RetCode := SioPutc(Port,'T');
                SioDelay(5);
                RetCode := SioPutc(Port,chr($0d));
                SioDelay(5);
                (* expect OK back *)
                TimeMark := SioTimer + 60;
                Expect := 'O';
                repeat
                  RetCode := SioGetc(Port,1);
                  if chr(RetCode) = Expect then
                    begin
                      (* character matches *)
                      if Expect = chr($0d) then
                      begin
                        writeln('  Modem found on COM',1+Port);
                        RetCode := SioDone(Port);
                        Halt
                      end;
                      (* update Expect *)
                      if Expect = 'O' then Expect := 'K';
                      if Expect = 'K' then Expect := chr($0d)
                    end
                until SioTimer >= TimeMark;
                (* no response *)
                RetCode := SioDone(Port);
                (* has user pressed any key ? *)
                if KeyPressed then
                  begin
                     writeln('Aborted by user');
                     RetCode := SioDone(Port);
                     Halt
                   end
              end
          end   
      end (*end-for*)
end.
