(**************************************************************************
** This program appends two files together, writting the appended files out
** to a third file.
*)
program append(output, in1, in2, out);
type
   char_file = file of char;
var
   in1 : char_file;     (* first input file *)
   in2 : char_file;     (* second input file *)
   out : char_file;     (* output file *)

   (*******************************************************************
   ** PURPOSE: Writes copies the contents of one file into another.
   ** ARGUMENTS:
   **    'f' - the input file
   **    'g' - the output file
   ** NOTES: It is up to the caller to open and close the files.
   *)
   procedure WriteFile(var f, g: char_file);
   var
      c : char;
   begin
      while not eof(f) do
         begin
            read(f, c);
            write(g, c)
         end
   end;

   (**********************************************
   ** PURPOSE: Writes a help screen and then halts
   *)
   procedure syntax;
   begin
      writeln('Appends two files together and writes the output to a third file');
      writeln('Syntax');
      writeln('   ivm append in1 in2 out');
      writeln('where "in1" is the first input file');
      writeln('and   "in2" is the second input file');
      writeln('and   "out" is the output file');
      halt
   end;

begin
   if paramcount <> 3 then
      syntax;
   rewrite(out);
   reset(in1);
   WriteFile(in1, out);
   close(in1);
   reset(in2);
   WriteFile(in2, out);
   close(out);
   close(in2)
end.
