
/****************************************************************************
*   Function:   int socknbio(int fd, int nbios)                             *
*   Operation:  to modify the Non-Blocking Input/Output Status of a socket  *
*   Returns:    a 0 if status change successful, else -1 for error          *
*   Parameters: fd, a specific already open socket number                   *
*               nbios, non-blocking i/o status                              *
*                 0 means non-blocking is turned off (or BLOCK)             *
*                 1 means non-blocking is turned on  (or NONBLOCK)          *
****************************************************************************/

#include <stdio.h>
#include <sys/ioctl.h>

static int zero = 0;	/* used by ioctl() -> blocking */
static int one = 1;	/* used by ioctl() -> non-blocking */

int socknbio(fd, nbios)
  int fd, nbios;
{
  int rc;
  char msg[128];

  if (nbios == 0)
    rc = ioctl(fd, FIONBIO, &zero);	/* blocking */
  else
    rc = ioctl(fd, FIONBIO, &one);	/* non-blocking */

  if (rc < 0) {
    sprintf(msg, "socknbio(): can't set socket non-blocking status");
    socke(msg);
    return (-1);
  } else {
    return 0;
  }
}
