;;*************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;

;;***************************************
;; debug.inc contains debug routines.

print macro string
    db_print <string>
    endm

db_print macro string
    local return

    db_print_it <'&string&'>
    db_print_it <13,10>
    endm

;;***************************************
print_reg macro string, reg
    db_print_reg <string>, reg
    endm

db_print_reg macro string, reg
    .errb <reg>

    push AX
    mov AX, reg
    db_print_AX <&string>
    pop AX
    endm

;;***************************************
dump macro segment, address, count
    db_dump segment, address, count
    endm

db_dump macro segment, address, count
    push SI
    push CX
    mov CX, count
    mov SI, offset address
    db_dump_in_SI_CX segment
    pop CX
    pop SI
    ENDM


;;***************************************
dump_in_SI_CX macro segment
    db_dump_in_SI_CX segment
    endm

db_dump_in_SI_CX macro segment
    local myloop, no_newline

    push AX
    push BX
    push CX
    push SI

    mov BX, 8
    myloop:
        seg&segment
    lodsb
    db_print_AL <>
        dec BX
        jnz no_newline
        mov BX, 8
        db_print <>
    no_newline:
    dec CX
    jnz myloop
    db_print <>

    pop SI
    pop CX
    pop BX
    pop AX
    endm

;; PRIVATE routeines.  Please do not use directly, they rely on DS being
;; set properly
;;***************************************
db_print_no_nl macro string
    local return

    db_print_it <'&string&'>
    endm

;;***************************************
print_AL macro string
    db_print_AL string
    endm

db_print_AL macro string

    db_print_no_nl <&string>
    db_print_no_nl <  >
    call db_print_hex_in_AL
    endm

;;***************************************
print_AX macro string
   db_print_AX string
   endm

db_print_AX macro string
    .errb <string>

    db_print_no_nl <&string>
    db_print_no_nl < >
    call db_print_hex_in_AX
    db_print    <>

    endm

;;***************************************
db_print_it macro string
    local string_name, return
    .errb <string>

    .data
string_name db &string&,'$'

    .code
    push AX
    push DX

    mov ah, 9
    mov dx, offset string_name
    int 21h

    pop DX
    pop AX
    endm

;;***************************************
;; db_define is called before any of the debug routines are called

DB_DECLARE macro 
    global db_print_hex_digit_in_AL:proc
    global db_print_hex_in_AX:proc
    global db_print_hex_in_AL:proc
ENDM

DB_DEFINE macro 
    local around

    jmp around
global db_print_hex_digit_in_AL:proc
db_print_hex_digit_in_AL:
    push DX
    push AX
    and AL, 0Fh
    cmp AL, 10
    jl digit
    add AL, 'A'-10
    jmp db_print_char
    digit:
    add AL, '0'
    db_print_char:
    mov DL, AL
    mov AH, 2
    int 21h
    pop AX
    pop DX
    ret

;;***************************************
global db_print_hex_in_AL:proc
db_print_hex_in_AL:
    push AX         ;; Save AX
    SHR AL,1
    SHR AL,1
    SHR AL,1
    SHR AL,1
    call db_print_hex_digit_in_AL
    pop AX
    call db_print_hex_digit_in_AL
    ret

;;***************************************
global db_print_hex_in_AX:proc
db_print_hex_in_AX:
    push AX         ;; Save AX
    mov AL, AH
    call db_print_hex_in_AL ;; db_print MSB
    pop AX
    call db_print_hex_in_AL
    ret 

    around:
    ENDM
