SET ATTRIB CENTS
SET FIRST 0
echo
echo Welcome to Scala.
echo This file will give examples for using some Scala commands.
echo
echo EQUAL 13 3/1
echo This creates an equal tempered scale by dividing the twelfth into 13 steps.
!
EQUAL 13 3/1
echo SHOW SCALE
SHOW SCALE
PAUSE
echo
echo You can also look at the consecutive intervals (the keyword SCALE can be
echo omitted:
echo SHOW/INTERVAL
SHOW/INTERVAL
PAUSE
echo
echo Now let's create a Pythagorean scale:
echo PYTHAGOREAN
echo scale size: 12
echo octave: 2/1
echo degree of fifth: 7
echo fifth: 3/2
echo number of fifths downwards: 1, this means start at degree 5
PYTHAGOREAN
12
2/1
7
3/2
1
PAUSE
echo
echo SHOW
SHOW
PAUSE
echo
echo To see all the intervals in the scale, and how many there are of them:
echo SHOW INTERVALS
SHOW INTERVALS
PAUSE
echo
echo To see which are the frequencies of the scale:
echo SHOW/FREQUENCY
SHOW/FREQUENCY 
PAUSE
echo
echo Show several scale properties:
echo SHOW DATA
SHOW DATA
echo
echo See which modes of higher equal temperaments approximate the scale:
echo FIT/MODE
FIT/MODE
PAUSE
echo
echo To convert the current scale into a subset of an equal temperament use
echo the command QUANTIZE, for instance:
echo QUANTIZE 41
echo SHOW/INTERVAL
QUANTIZE 41
SHOW/INTERVAL
PAUSE
echo Let's see which octave based equal temperaments have a good approximation
echo to some interval.
echo Enter an interval now, for instance 7/6:
echo DIVIDE/FIND
DIVIDE/FIND
?
PAUSE
echo
echo More than one scale can be kept in memory. The current one has number 0.
echo To copy the current one to memory 1, do
echo COPY 0 1
echo The command PUSH has the same effect.
COPY 0 1
PAUSE
echo
echo You can select a mode (subset) from a scale, for instance:
echo MODE DORIAN
echo or do it directly without looking up a name: MODE 2 1 2 2 2 1 2
echo SHOW
MODE DORIAN
SHOW
echo 
echo To undo this command we could do COPY 1 0, or POP.
echo To show scale 1 instead of the current scale you can do SHOW SCALE 1,
echo or even SHOW 1.
echo The first degree to be shown can be changed, for instance to omit degree 0
echo which is always 1/1, with
echo SET FIRST 1
SET FIRST 1
PAUSE
echo 
echo To see all settings like this one can do
echo SHOW SETTINGS
SHOW SETTINGS
PAUSE
echo
echo Now create a simple Euler-Fokker genus [33335], genus diatonicum
echo EULER
echo number of dimensions: 2
echo pitch 1: 3/2
echo multiplicity: 4
echo pitch 2: 5/4
echo multiplicity: 1
echo octave added: 2/1
EULER
2
3/2
4
5/4
1
2/1
SHOW
PAUSE
echo
echo Some pitches have become higher than an octave.
echo To bring them back within one octave we do:
echo REDUCE 2/1
echo But this leaves the scale in an unordered way. This requires:
echo SORT
echo This is the result:
REDUCE 2/1
SORT
SHOW
echo The reason that this is not done by the EULERFOKKER command is that one
echo might want to use another value than 2/1 for the octave. The command
echo REDUCE is an important one, and used in combination with more commands.
PAUSE
echo
echo To find out between which pairs of pitches a certain interval is 
echo (approximately) in the scale, do for instance:
echo SHOW LOCATION 4/3
SHOW LOCATION 4/3
PAUSE
echo
echo The value in the right column when a scale is shown can be changed by the
echo SET ATTRIBUTE command. For instance to show the factorisation:
echo SET ATTRIBUTE PRIME
echo SHOW
SET ATTRIBUTE PRIME
SHOW
PAUSE
echo
echo Or to show string lengths, for instance with a used length of 500:
echo SET ATTRIBUTE RECIPROCAL
SET ATTRIBUTE RECIPROCAL
echo SET RECIPROCAL 500.0
SET RECIPROCAL 500.0
echo SHOW
SHOW
PAUSE
echo
echo Or to show note names, for example from 53-tone equal temperament:
echo SET ATTRIBUTE NOTATION E53
SET ATTRIBUTE NOTATION E53
echo SHOW
SHOW
PAUSE
echo
echo We can also show this scale in the form of a lattice. This pictures the
echo scale structure in terms of fifths, thirds or other intervals like the
echo harmonic seventh.
echo The factors of 2 in the ratios shall be ignored.
echo Horizontally are the fifths (factor 3), vertically the major thirds (5).
echo LATTICE 3 5
LATTICE 3 5
echo
echo The 0 indicates the position of degree 0 with value 1/1.
echo Pseudo 3-dimensional lattices can also be shown, just add the third
echo interval as an extra parameter.
PAUSE
echo
echo Scala can quickly calculate non-octave equal tempered scale approximations
echo to a set of (just) intervals. Create a scale with the intervals to be
echo approximated, for instance:
echo INPUT
echo 3
echo 7/6
echo 13/8
echo 7/4
INPUT
3
7/6
13/8
7/4
PAUSE
echo
echo Then issue the command FIT:
echo FIT
FIT
PAUSE
echo
echo The linear approximation is the approximation with consecutive scale
echo degrees, i.e. the first pitch is approximated by the given value times one,
echo the second by the given value times two, etc.
echo Next, different multiplication factors are given for each approximated 
echo pitch and on the line below the step size, how many of it is one octave
echo and the variance (root mean square of the differences).
PAUSE
echo
echo Commands that alter the current scale can be undone, but only the last
echo one. A copy of the previous contents of the current scale is kept in the
echo highest scale memory. The command that copies it back is:
echo UNDO
PAUSE
echo
echo Scala can calculate different properties of equal tempered scales.
echo For instance of 19-tET:
echo EQUAL/DATA 19 2/1
EQUAL/DATA 19 2/1
PAUSE
echo
echo There are many more things that can be done with Scala than can be shown
echo in a short example file. Try them out. For instance you can now try
echo saving and loading a scale or the CALCULATE command.
echo Do HELP SHOW to see which other information can be produced, and invoke 
echo HELP for the other topics listed.
echo Invoke TIP to get a tip-of-the-day.
echo TIP
TIP
PAUSE
echo
echo Good luck!
SET ATTRIB CENTS
