/* This code is designed to be inserted into a TURBO-C source. */
/* Variable __TURBOC__ is defined by the turbo-c compiler. */
/* Usage: Call mousereset(). Call mousehook(). Mouse setup done!

          If you enter a menu, where mouse action should be slower,
          then call menumouse(1). On menu exit call menumouse(0).

          Upon program exit call mousereset(). This resets the
          mouse driver (either a device or tsr from mouse manufacturer)
          interrupt service routine [warning: REQUIRED!].
*/
#ifdef __TURBOC__
#pragma inline
/*
 * MOUSE SENSITIVITY. A curious feature in mouse code is sensitivity to
 * movement: settling down on a character is subject to much error. In the
 * code below this problem is attacked.
 *
 *     Ideally, the cursor should lock onto a line and not be bumped off
 *     easily as the cursor scans left and right. Further, up and down
 *     motion should lock the cursor onto a column. I should like to scan
 *     up and down columns of numbers with the mouse exactly as I do with
 *     the cursor keys. The code below is an attempt to realize these
 *     features that falls short of perfection.
 *
 * MOUSE DRIVER DEFAULTS. The TSR resets the mouse driver and but sets no
 * defaults for the mouse controls: X,Y sensitivity, doubler.
 */

#define leftkey                 4b00h
#define rightkey                4d00h
#define upkey                   4800h
#define downkey                 5000h
#define retkey                  1c0dh
#define esckey                  011bh

#define mouse                   51         /* interrupt 33h */
#define resetmousedriver         0         /* reset mouse driver */
#define pressmouse               5         /* mouse button press status */
#define mousemotion             11         /* mouse cursor motion */
#define seteventhandler         12         /* set mask and event handler */
#define eventmask               0000000000001011b
/* evenmask bits 0,1,4: movement, left & right press */

/*
 Mouse driver resets to 8 and 16 respectively with function 00h.
 Znix and Merit both worked well with settings 8/16.
*/
int hsens=8,vsens=16;
static int hpos=0;      /* store mouse cursor position X */
static int vpos=0;      /* store mouse cursor position Y */

static
stuffbuffer(){
asm     cli                     /* Prevent interrupts from stuffing buffer */
asm     push es                 /* typeahead buffer start at *[0040:0080] */
asm     push bx                 /* and end at *[0040:0082]. */
                                /* At segment 40h and offset 01ah is */
asm     mov di,40h              /* the offset into the typeahead buffer */
asm     mov es,di               /* for the character at the head. At */
asm     mov bx,es:[1ch]         /* segment 40h and offset 01ch is the */
asm     mov si,bx               /* offset into the typeahead buffer for */
asm     add bx,2                /* the last character. The buffer is full */
asm     cmp bx,es:[1ah]         /* if *[01ch]+2 == *[01ah]. */
asm     je quit                 /* Full? Then don't add any more chars */
asm     cmp bx,es:[82h]         /* Offset less than end of buffer? */
asm     jl isroom               /* Yes. Then go ahead and stuff it. */
asm     mov bx,es:[80h]         /* Else wrap around to buffer start */
isroom:
asm     mov es:[si],cx          /* CX=scan code to be stuffed */
asm     mov es:[1ch],bx         /* BX=new offset to last buffer character */
quit:
asm     pop bx
asm     pop es
asm     sti                     /* let other routines stuff the buffer */
}

static
manystuffbuffer(){
/* AX=amount in mickeys mouse cursor has moved. */
/* BX=sensitivity in mickeys */
/* CX=key scan code to stuff into keyboard buffer */
manyloop:
asm     call stuffbuffer
asm     sub ax,bx
asm     cmp ax,bx
asm     jge manyloop
}

static
far mouseeventhandler() {
asm     push ax
asm     push bx
asm     push cx
asm     push dx
asm     push ds                 /* ds=mouse driver data segment */
asm     mov ax, SEG _DATA       /* Get data segment for our data */
asm     mov ds,ax               /* Set data segment */
/*
 Press Mouse supplies: BX=button status, CX=X mickeys, DX=Y mickeys
                       The signed integers CX, DX measure UP==+, RIGHT==+
                       Clears all button counts on each call.
*/
asm     mov ax,pressmouse       /* get status of button press */
asm     mov bx,0                /* for left button */
asm     int mouse
asm     and ax,1                /* Press left button? */
asm     jz check_rightbutton    /* No? Then check right button. */
asm     mov cx,retkey           /* Yes. Then plug in RETURN key. */
asm     call stuffbuffer        /* near function call */
check_rightbutton:
asm     mov ax,pressmouse       /* get status of button press */
asm     mov bx,2                /* for right button */
asm     int mouse
asm     and ax,2                /* press right button? */
asm     jz checkcursor          /* No? Then check cursor keys. */
asm     mov cx,esckey           /* Yes. Then plug in ESC key. */
asm     call stuffbuffer        /* near function call */
checkcursor:
asm     mov ax,mousemotion      /* Has the mouse cursor moved? */
asm     int mouse
asm     mov ax,ds:hpos          /* save new horizontal position */
asm     add ax,cx               /* cx=X coord supplied by mouse driver */
asm     mov ds:hpos,ax
asm     cmp ax,0                /* Has the mouse cursor moved? */
asm     je  motionvertical      /* No change, then check vertical */
asm     jg motionhorizontal     /* Make positive */
asm     not ax
motionhorizontal:
asm     mov bx,ds:hsens
asm     cmp ax,bx
asm     jl motionvertical       /* didn't move enough for a change */
asm     cmp ds:hpos,0
asm     mov cx,rightkey
asm     jg  stuffit1            /* If positive, then stuff cursor Right */
asm     mov cx,leftkey
stuffit1:
asm     jmp stuffit2
motionvertical:
asm     mov ax,ds:vpos          /* save new vertical position */
asm     add ax,dx               /* dx=Y coord supplied by mouse driver */
asm     mov ds:vpos,ax
asm     cmp ax,0
asm     je eventreturn          /* no change, all done */
asm     jg testvertsens         /* If positive, then stuff cursor Up */
asm     not ax
testvertsens:
asm     mov bx,ds:vsens
asm     cmp ax,bx
asm     jl eventreturn          /* didn't move enough for a change */
asm     cmp ds:vpos,0
asm     mov cx,downkey
asm     jg stuffit2
asm     mov cx,upkey
stuffit2:
asm     call manystuffbuffer    /* stuff key CX into keyboard buffer */
asm     mov ds:vpos,0           /* reset vertical saved position */
asm     mov ds:hpos,0           /* reset horizontal saved position */
eventreturn:
asm     pop ds
asm     pop dx
asm     pop cx
asm     pop bx
asm     pop ax
}

/* Returns 1 if it worked, 0 if it didn't */
mousereset(){
asm     mov ax,hsens            /* Don't hookup mouse if hsens==0 */
asm     cmp ax,0                /* hsens,vsens set in PI.SET */
asm     je nomouse
asm     mov ax,resetmousedriver /* reset mouse driver to defaults */
asm     int mouse
asm     cmp ax,0                /* bx=number of buttons, not used yet */
asm     mov ax,0
asm     je nomouse              /* exit if no mouse driver loaded */
asm     mov ax,1
nomouse:;
}

mousehook(){
asm     mov ax,cs               /* Hook mouse driver to event handler */
asm     mov es,ax               /* es=segment of event handler */
asm     mov dx,offset mouseeventhandler
asm     mov ax,seteventhandler  /* mouse driver function code */
asm     mov cx,eventmask        /* signal mask for interrupt */
asm     int mouse
}

static int vsensx,hsensx;

/* Slow down the mouse in menus */
menumouse(flag) int flag; {
  if(flag){
    vsensx=vsens; hsensx=hsens;
    vsens= 2*vsens; hsens= 8*hsens;
  } else {
    vsens=vsensx; hsens=hsensx;
  }
}

#else
menumouse(){}
#endif
