.TH SMBPD 1 "1 December 1996" "DOS network application"
.SH NAME
smbpd \- SMB network printer daemon for DOS
.SH SYNOPSIS
.B smbpd
[\fB\-n\fI#\fR] [\fB\-t\fR] [\fB\-i\fR]
[\fB\-s\fR] [\fB\-b\fI#\fR] [\fB\-\fI#\fR]
[\fB\-a\fIhostlist\fR] [\fB\-d\fIhostlist\fR] [\fB\-l\fIhost\fR]
[\fB\-v\fR] [\fB\-z\fIsize\fR]
.SH DESCRIPTION
.I smbpd
is a small program that turns an XT or AT running DOS into a dedicated
SMB printer server. You can send jobs to the printers from any
machine running WfWg, W95, NT or smbclient (from the Samba package).
It can handle up to 3 parallel printer ports.
Serial printers can be handled by running the interrupt I/O driver
TSRCOMM, which is in LPTCOM.ZIP and diverting LPTn to COMn.
.SH INSTALLATION
.I smbpd
requires:  Parallel or serial printer ports connected to
printers,  a network interface card and a FTP Software specification
Packet Driver for it, and a valid WATTCP configuration file, WATTCP.CFG.
.LP
Please read the notes in TODO to see what gotchas you need to look
out for to be able to run this young version of the software.
.LP
To install, edit the file WATTCP.CFG, filling in the entries. Then edit
your autoexec.bat file to load the packet driver, then
.IR smbpd .
Something like this:
.sp
.nf
a:\\smbpd\\ni5210 0x60 2 0x300 0xcc00
rem If you wish to put your wattcp.cfg in a particular directory
set wattcp_cfg=a:\\smbpd\\wattcp.cfg
a:\\smbpd\\smbpd
.fi
.LP
Turn your printers on before starting
.I smbpd
or it will not detect the printers. Alternatively, use the \fB\-n\fP
flag in
.IR smbpd .
.LP
.I smbpd
outputs tones (C,D,E) for as many printers as detected.
.I smbpd
displays status on console, including changes in printer status.
.LP
You can now send jobs from clients. The printers served are
called lpt1 through lpt3, in any mixture of case. You can also set the
printer names in WATTCP.CFG by assigning to PRINTER[123]NAME.
.I smbpd
is multithreaded and can have as many connections as printers active.
Control-F1 through F3 can be used to abort jobs on the corresponding
printers.
.LP
You may wish to restrict access to
.I smbpd
to certain machines only. The \fB\-a\fP and \fB\-d\fP options are for
this.
.I smbpd
allows connections only from machines on the same subnet (as determined
from the subnet mask) by default.
See the discussion under the \fB\-s\fP option.
.LP
The client handling of
.I smbpd
is different from the usual
.I lpd
servers. SMB allows a client to remain connected to a printer
(called a share) for long periods. So in
.I smbpd
the printer is not allocated to the client until an open print file
request is received. The printer then becomes unavailable to other
clients (a printer queue full error is returned) until the print
file is closed and the printer released.
.LP
Since there is no spooling, print output is sent to the printer
immediately so partial output may appear even if the job is
cancelled partway through.
.LP
Another consequence of
.IR smbpd 's
strategy is that while there are a maximum of 3 printers served,
the limit on the number of clients connected is higher, currently at 30.
To change this limit, edit MAXCONN in netio.h.
.LP
The other thing to note is that to avoid preallocating precious
space to a connection, the print buffer is associated with the
printer and is used for print data SMBs only when the connection
has actually opened a print file.
.SH OPTIONS
.TP
.BI \- xy
disable printers
.I x
and
.I y
(numbers between 1 and 3)
.TP
.BI \-n #
.I #
printers, no matter what BIOS claims
.TP
.B \-t
don't indicate available printers with tones
.TP
.B \-i
reinitialise printer via hardware line on job abort
.TP
.BI \-b xy
Print directly to hardware port of printers
.I x
and
.I y
instead of using the BIOS print service. This only works on real
parallel ports, i.e. not redirected to serial ports, files or network
connections, and is only likely to improve things with fast printer
interfaces, in particular those with memory buffers, such as laser
printers.  On low speed printers, it isn't likely to make things faster
since the bottleneck is the printer.
.TP
.B \-s
Indicates local subnet is not special.
If you want to open up access to the whole Internet, use
.BI -d x.x.x.x
alone, where
.I x.x.x.x
is an address that will never be used by a client, for instance,
the address of the SMBPD host.
.TP
.BI \-a list
Comma separated list of up to 20 domain names allowed connection.
.TP
.BI \-d list
Comma separated list of up to 20 domain names denied connection.
.sp
.br
\fB\-a\fP and \fB\-d\fP are mutually exclusive.
Domain names can also be network addresses, which have all 0s for the
hostid portion, as determined from the subnet mask, in which all
hosts on the network are affected by the allow or deny.
.TP
.BI \-l host
log diagnostics via SYSLOG protocol to
.I host
.TP
.BI \-p n
SMB protocol to serve at; 0 is CORE, 1 is LANMAN1, 2 is LANMAN2.
Default is LANMAN2.
.TP
.B \-v
Show more messages, repeat this option to increase verbosity.
.TP
.BI \-z size
Set the maximum size of SMB messages, a minimum of 1024 and
a maximum of 63*1024 is silently enforced.
.SH "CONFIGURATION FILE SETTINGS"
Assigning to PRINTER1NAME, PRINTER2NAME, and PRINTER3NAME in WATTCP.CFG
will give names other than the default lpt[123] to the printers.
.SH "OTHER FILES"
.SH "SEE ALSO"
.SH FILES
WATTCP.CFG, LPTCOM.ZIP
.SH DIAGNOSTICS
Hopefully self explanatory.
.SH COPYRIGHT
.I smbpd
is under the Artistic License, which allows you to freely distribute
the program provided the sources accompany, or are made available on
request. See Artistic for details.
.SH AUTHOR
Ken Yap (ken@syd.dit.csiro.au)
.SH DATE
December 1996
