/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       pkttype.c
**     SYSTEM   NAME:       PKT
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v2.00
**     CREATION DATE:       1990/4/12
**
** DESCRIPTION: PDS type functions (release & access)
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   PKTTYPE.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/PKT/VCS/PKTTYPE.C_V  $
**              
**                 Rev 1.0   25 Oct 1990 14:34:20   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/C600/BEHOLDER/NPD/PKT/VCS/PKTTYPE.C_V   1.0   25 Oct 1990 14:34:20   etstjan  $";
#endif
#include <error.h>
#include "pktinc.h"                         /* main include file */

/*************************************************************************
** NAME:        PktAccessType                           [API]
** SYNOPSIS:    int PktAccessType(PktInt, fpType, Typelen,
**                                fpRecFunc, pHandle)
**              int PktInt          Int number [0x60-0x80]
**              char far *fpType    Ptr to Type string or NULL
**              unsigned Typelen    Length of Type string or 0
**              int (far *fpRecFunc)() Ptr to receive function
**              unsigned *pHandle   Pointer to type handle
** DESCRIPTION: Starts reception of type packets from device
**              driver.
**              Initiates reception of packets of specified
**                type to receive function <fpRecFunc>,
**                which should be: PktReceiver[0..3].
**                You can select a device number from 0 to 3.
**              If <fpType>=NULL and <Typelen>=0, ALL packets
**                will be received.
** RETURNS:     PKT_OK = 0      Successfull call
**              PKT_NO_CLASS    No IF of specified Class
**              PKT_NO_TYPE     No IF of specified Type
**              PKT_NO_NUMBER   No IF of specified Number
**              PKT_BAD_TYPE    Bad packet Type specified
**              PKT_NO_SPACE    Insufficient memory
**              PKT_TYPE_INUSE  Type already 'accessed'
** SEE ALSO:    PktInit, PktReleaseType
*************************************************************************/
int PktAccessType(int PktInt, char far *fpType, int Typelen,
                  int (far *fpRecFunc)(), int *pHandle)
{
    int ret, Handle, i;
    PKTDEV *pDev = PktDevTable[PktInt-PKTINTOFFS];
    PKTINFO *pInfo = &(pDev->Info);

    ERR_DEB( ERR_NPD, 5, "PktAccessType");

    for (i=0;i<PKTMAXHANDLES && pDev->usHandleTable[i];i++);
    if (i==PKTMAXHANDLES)
        return PktError(PktInt, AH_ACCESS, PKT_NO_SPACE);

    ERR_DEB( ERR_NPD, 6, "PdsAccessType: Class: %d, Type: %d, Number: %d",
            pInfo->Class, pInfo->Type, pInfo->Number);
    ret = PdsAccessType( PktInt, pInfo->Class, pInfo->Type, pInfo->Number,
                         fpType, Typelen, fpRecFunc, &Handle);
    if (!ret) 
    {
        pDev->usHandleTable[i] = Handle;
        if (pHandle) *pHandle = Handle;
    }
    return ret;
}


/*************************************************************************
** NAME:        PktReleaseType                          [API]
** SYNOPSIS:    int PktReleaseType(PktInt, Handle)
**              int PktInt          Int number [0x60-0x80]
**              unsigned Handle     Type handle
** DESCRIPTION: Ends reception of type packets from device
**              driver.
**                previously iniated by a call
**                to PktAccessType().
** RETURNS:     PKT_OK = 0      Successfull call
**              PKT_BAD_HANDLE  Invalid Handle number
** SEE ALSO     PktAccessType
*************************************************************************/
int PktReleaseType(int PktInt, int Handle)
{
    int i, ret;
    PKTDEV *pDev = PktDevTable[PktInt-PKTINTOFFS];

    ERR_DEB( ERR_NPD, 5, "PktReleaseType %d, %d",PktInt,Handle);
    ret=PdsReleaseType(PktInt,Handle);
    if (!ret)
        for (i=0;i<PKTMAXHANDLES;i++)
            if (pDev->usHandleTable[i]==Handle)
                pDev->usHandleTable[i]=0;
    ERR_DEB( ERR_NPD, 5, "PktReleaseType return %d",ret);
    return ret;
}


