#************************************************************************
#* MODULE INFORMATION*
#*********************
#*     FILE     NAME:       DPU.MAK
#*     SYSTEM   NAME:       BEHOLDER
#*     ORIGINAL AUTHOR(S):  Jan van Oorschot
#*     VERSION  NUMBER:     1.00
#*     CREATION DATE:       16-10-90
#*
#* DESCRIPTION: Global makefile for the Network DisPatcher's
#*              Packet Driver Handling Library.
#************************************************************************
#* CHANGES INFORMATION **
#************************
#* REVISION:    $Revision:   1.2  $
#* WORKFILE:    $Workfile:   DPU.mak  $
#* LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/NPD/DPU/VCS/DPU.MAV  $
#  
#     Rev 1.2   01 Feb 1991 14:32:48   etstjan
#  No explicit note
#  
#     Rev 1.1   26 Oct 1990 14:42:02   etstjan
#  
#     Rev 1.0   25 Oct 1990 15:37:26   etstjan
#  Initial revision.
#************************************************************************
HOMEDIR=..\..
NEWTREE=.^\
MODEL=L
MODE=r
CFLAGS=/W4 /Ox /A$(MODEL) /L$(MODE) /I$(HOMEDIR)\INCLUDE /I..\INCLUDE
LFLAGS=/STACK:8000
MFLAGS = HOMEDIR=$(HOMEDIR) CFLAGS="$(CFLAGS)" LFLAGS="$(LFLAGS)" MODE=$(MODE) MODEL=$(MODEL)
ID=$(HOMEDIR)\INCLUDE
LD=$(HOMEDIR)\LIB
PUTNOTE="No explicit note"

SYSTEM=DPU
LIBS=$(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
CS=DPUPERC.C DPUINI.C DPUFILE.C DPUDUMP.C DPULOGO.C DPUSTAT.C DPUPREF.C DPUUTI.C DPUFILT.C
AS=
CTS=
HS=DPU.H DPUINC.H
MAKS=$(SYSTEM).mak
DOCS=
SRCS=$(CS) $(AS) $(HS) $(DOCS) $(CTS) DPUMAN.CMD
OBJS=DPUPERC.OBJ DPUINI.OBJ DPUFILE.OBJ DPUDUMP.OBJ DPULOGO.OBJ DPUSTAT.OBJ DPUPREF.OBJ DPUUTI.OBJ DPUFILT.OBJ
TOBJS=
EXES=
TEXES= 
EXPORTS=$(ID)\DPU.H \
        $(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
#************************************************************************
#*  Supported make commands:
#*
#*      all     -->     do a full make of this system part
#*      compile -->     do a compile of all c-files
#*      lib     -->     collect all obj's in a lib
#*      exe     -->     make exe's
#*      clean   -->     throw out all garbage
#*      collect -->     copy all .lib and .h files to global directories
#*      put     -->     do a PVCS put of the sources 
#*      get     -->     do a PVCS get of the sources
#*      getlock -->     do a PVCS get of the sources and put a lock on them
#*      makedir -->     Make all subdirectories in the given
#*                      tree $(NEWTREE)
#************************************************************************
all:  lib 
    @echo ....Ready  $(MODEL)$(SYSTEM)$(MODE).lib


compile:    $(OBJS)

lib: $(MODEL)$(SYSTEM)$(MODE).lib

exe:   $(EXE) $(TEXES)

clean:
    @-del *.obj
    @-del *.lib
    @-del *.bak
    @-del *.exe


collect: $(EXPORTS)
    !-copy $(**F) $**


put:    $(SRCS)
    !PUT -l -n -m$(PUTNOTE) $**
    PUT  -l -n -m$(PUTNOTE) $(SYSTEM).mak

getlock:    $(SRCS)
    !-GET -l $**


get:    $(SRCS)
    !-GET  $**

makedir:
    mkdir $(NEWTREE)\VCS

#************************************************************************
#*  actual components and relations
#************************************************************************
$(MODEL)$(SYSTEM)$(MODE).lib : $(OBJS)
    !LIB $@ -+$**;
    copy $(MODEL)$(SYSTEM)$(MODE).lib $(LD)


$(SRCS) :

$(EXPORTS) :
