/*****************************************************************************
*   Module to handle libraries.						     *
*									     *
* Written by:  Gershon Elber			IBM PC Ver 1.0,	Oct. 1989    *
*****************************************************************************/

#ifndef EELIBS_H
#define EELIBS_H

#include "PriorQue.h"

/* The snap distance will be same as one pixel in the library definition, so */
/* when libraries are scaled up on loading every pin will be destinuishable. */
#define LIB_SCALE_DRAW	DEFAULT_SNAP_DISTANCE

typedef struct LibraryStruct {
    char Name[9];				  /* Name of library loaded. */
    int NumOfParts;			/* Number of parts this library has. */
    PriorQue *Entries;			 /* Parts themselves are saved here. */
    struct LibraryStruct *Pnext;	      /* Point on next lib in chain. */
} LibraryStruct;

void LoadLibrary(void);
void LoadLibraryName(char *FullLibName, char *LibName);
void LoadLibraries(char *LoadLibraryList);
void FreeLibrary(char *LibName);
char **GetLibNames(void);
void ViewLibrary(void);
void DrawLibPart(DrawLibItemStruct *DrawLibItem, int DrawMode, int Color);
void DrawLibPartClear(DrawLibItemStruct *DrawLibItem, int DrawMode);
void SnapLibItemPoint(int OrigX, int OrigY, int *ClosestX, int *ClosestY,
					    DrawLibItemStruct *DrawLibItem);
NetListStruct *FindLibItemNetList(int lx1, int ly1, int lx2, int ly2,
				  BooleanType l1Bus,
				  DrawGenericStruct *Phead,
				  DrawLibItemStruct *DrawLibItem);
BooleanType LibItemInBox(int x1, int y1, int x2, int y2,
					DrawLibItemStruct *DrawLibItem);
BooleanType PlaceLibItem(DrawLibItemStruct *DrawLibItem);
DrawGenericStruct *LibCreateNewPart(void);
BooleanType RePosLibItem(DrawLibItemStruct *DrawLibItem, int PopPosition);
BooleanType CanDrawChipName(char *LibName);

#endif  EELIBS_H
