#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <time.h>
#include <dos.h>
#include <dir.h>
#include <alloc.h>
#include <time.h>
#include "conv.h"
#include "..\primary.h"

FILE *fin,*fout, *rep;

int Lib;	/* input format for library files */
int Line = 1;

char Infile[0x80],Outfile[0x80],SLine[0x80];

void main(argc,argv)
int argc;
char *argv[];
{
	char buf[0x100];
	int x;
	if((argc!=2) & (argc !=3)){
		fprintf(stderr,"EEFilter: <-l> <File>\n");
		exit(-1);
	}
	if(argc==2)
		Lib=0;	/* Basic EEDraw file, */
	else if((strcmp(argv[1],"-l"))==0)
		Lib=1;
	else if((strcmp(argv[1],"-z"))==0){
		fprintf(stderr,"Usage: EEFilter <-l> Filename\n");
		fprintf(stderr,"EEDraw/EELibs Conversion Utility\n");
		exit(0);
	}
	if(Lib==0 && argc==2)
		sprintf(Infile,"%s",argv[1]);
	else if(Lib==0 && argc==3)
		sprintf(Infile,"%s",argv[2]);
	else if(Lib==1 && argc==3)
		sprintf(Infile,"%s",argv[2]);
	else {
		fprintf(stderr,"EEFilter: <-l> <File>\n");
		exit(-1);
	}
	if((fin=fopen(Infile,"r"))==NULL){
		fprintf(stderr,"Cant open file %s for reading\n",Infile);
		exit(-1);
	}
	sprintf(Outfile,"EEFilter.jnk");
	if((fout=fopen(Outfile,"w"))==NULL){
		fprintf(stderr,"Can't open Tempery file for writting\n");
		exit(-1);
	}
	if((rep=fopen("EEFilter.rep","a"))!=NULL){
		fprintf(rep,"Basic report for filter,\n");
		fprintf(rep,"Input File %s\n",Infile);
		fprintf(rep,"Output file %s\n",Outfile);
		fprintf(rep,"Mode %d\n**********\n\n",Lib);
		fclose(rep);
	}

	if(Lib==0){	/* EED Sytle File */
		fgets(buf,0x100,fin);
		fprintf(fout,"EEDraw EEDRAW PROGRAM Version 2.4\n");
		Copy_Line(1);
		Line=2;
		Sch_Layer_Head();
		do_eed();
	} else if(Lib==1){
		fgets(buf,0x100,fin);
		fprintf(fout,"EEDRAW-LIB Version 1.1\n");
		do_lib();
	}
	fclose(fin);
	fclose(fout);
	x=do_move();
	exit(x);
}

/* Copy N Lines from the input to the output */
void Copy_Line(Num)
int Num;
{
	char buf[0x100];
	while(Num!=0){
		fgets(buf,0x100,fin);
		fprintf(fout,"%s",buf);
		Num--;
	}
}

void Sch_Layer_Head()
{
	fprintf(fout,"EELAYER 12 0\n");
    	fprintf(fout,"Wire   15  2  0\n");
     	fprintf(fout,"Bus   14  2  1\n");
    	fprintf(fout,"Gate    3  1  2\n");
    	fprintf(fout,"IEEE    4  1  3\n");
  	fprintf(fout,"PinFun    1  1  4\n");
  	fprintf(fout,"PinNum   14  1  5\n");
  	fprintf(fout,"PinNam    1  1  6\n");
  	fprintf(fout,"RefDes   14  1  7\n");
    	fprintf(fout,"Attr   14  1  8\n");
  	fprintf(fout,"Device    3  1  9\n");
   	fprintf(fout,"Notes    1  2 10\n");
  	fprintf(fout,"NetNam    4  1 11\n");
     	fprintf(fout,"Pin   15  1 12\n");
	fprintf(fout,"EELAYER END\n");
	Line = Line + 15;
}
void do_eed()
{
	char buf[0x100];
	char cmd,flag;
	int v1,v2,v3,v4,v5;
	do {
		buf[0]='\0';
		cmd='\0';
		fgets(buf,0x100,fin);
		sscanf(buf,"%c %d %d %d %d %d",&cmd,&v1,&v2,&v3,&v4,&v5);
		switch(cmd){
			case 'P' :
				sscanf(buf,"%c %c %d",&cmd,&flag,&v1);
				fprintf(fout,"%c %c 0 %s",cmd,flag,&buf[4]);
				Copy_Line(v1);
				Line = Line + 1 + v1;
				break;
			case 'T' :
				fprintf(fout,"%c 10 %s",cmd,&buf[2]);
				Copy_Line(1);
				Line = Line +2;
				break;
			case 'L' :
				fprintf(fout,"%s",buf);
				Copy_Line(2);
				Line = Line + 3;
				break;
			case 'C' :
				fprintf(fout,"C %d %d %d\n",LAYER_WIRE, v1,v2);
				Line ++;
				break;
			default  :
				if((rep=fopen("eefilter.rep","a"))!=NULL){
					fprintf(rep,"\n*******\nErrors\n");
					fprintf(rep,"Error: found line %d\n",
						Line);
					fprintf(rep,"Line :%s:\n",buf);
					fclose(rep);
				}
				break;
		} 
	}while(!feof(fin));	/* outer loop of basic filter */
}
void do_lib()
{ 
	char buf[0x100];
	char cmd;
	int v1,v2,v3,v4,v5;
	do {
    	buf[0]='\0';
    	cmd='\0';
    	fgets(buf,0x100,fin);
	if((buf[1]==' ') & ((buf[0] >= 'A') & (buf[0] <= 'Z'))){
		sscanf(buf,"%c %d %d %d %d %d",&cmd,&v1,&v2,&v3,&v4,&v5);
		switch(cmd){
			case '#' :
				fprintf(fout,"%s",buf);
				break;
			case 'P' :
				sscanf(buf,"%c %d",&cmd,&v1);
				fprintf(fout,"%c %d %s",cmd,LAYER_GATE,&buf[2]);
				Line = Line + 1;
				break;
			case 'L' :
				fprintf(fout,"%c %d %s",cmd,LAYER_GATE,&buf[2]);
				Line++;
				break;
			case 'S' :
				fprintf(fout,"%c %d %s",cmd,LAYER_GATE,&buf[2]);
				Line++;
				break;
			case 'A' :
				fprintf(fout,"%c %d %s",cmd,LAYER_GATE,&buf[2]);
				Line++;
				break;
			case 'C' :
				fprintf(fout,"%c %d %s",cmd,LAYER_GATE,&buf[2]);
				Line++;
				break;
			case 'T' :
				fprintf(fout,"%c %d %s",cmd,LAYER_PINNAM,
					&buf[2]);
				Line = Line++;
				break;
		 
			default  :
				if((rep=fopen("eefilter.rep","a"))!=NULL){
					fprintf(rep,"\n*******\nErrors\n");
					fprintf(rep,"Error: found line %d\n",
						Line);
					fprintf(rep,"Line :%s:\n",buf);
					fclose(rep);
				}
				break;
		} 

/* end of switch statemant, check words in other half of ELSE statment */

	    } else {
		fprintf(fout,"%s",buf);
	    }
/* end of word checks */
	}while(!feof(fin));	/* outer loop of basic filter */
}
int do_move()
{
	char c;
	if((fin=fopen(Outfile,"r"))==NULL){
		fprintf(stderr,"Cant reopen temp file for reading\n");
		return(-1);
	}
	if((fout=fopen(Infile,"w"))==NULL){
		fprintf(stderr,"Cant open %s for writting\n",Infile);
		return(-1);
	}
	while((c=getc(fin))!=EOF)
		putc(c,fout);
	return(0);
}
