/*****************************************************************************
*   Module to handle libraries.						     *
*									     *
* Written by:  Gershon Elber			IBM PC Ver 1.0,	Oct. 1989    *
*****************************************************************************/

#ifndef EELIBS_H
#define EELIBS_H

#include "priorque.h"

/* The snap distance will be same as one pixel in the library definition, so */
/* when libraries are scaled up on loading every pin will be destinuishable. */
#define LIB_SCALE_DRAW	DEFAULT_SNAP_DISTANCE

typedef struct LibraryStruct {
    char Name[9];				  /* Name of library loaded. */
    int NumOfParts;			/* Number of parts this library has. */
    PriorQue *Entries;			 /* Parts themselves are saved here. */
    struct LibraryStruct *Pnext;	      /* Point on next lib in chain. */
} LibraryStruct;

void LoadLibraryName(char *FullLibName, char *LibName);
void LoadLibraries(char *LoadLibraryList);
void DrawLibPart(DrawLibItemStruct *DrawLibItem);

#endif  EELIBS_H
