/*
	bench - integer mode graphics demonstration and benchmark  	

	bugs...

screen measurements: 191 mm wide by 158 mm high on Z-150
                     8.25 in wide by 5.375 in high on IBM
*/
#pragma ex+

#include <stdio.h>
#include "g.h"


char buf[80];
int no_characters=0;	/* nonzero if calls to character functions are
							to be avoided (presumably because they aren't
							yet implemented)  			*/

long int t1, t2, t3, min_rate, max_rate, overhead;
long tics();
int i, j, k;
int q, x0, y0, x1, y1, x2, y2, delx, dely, del1, del2;
int w0, w1, w2, z2;
int starting_screen = 0;
double intensity;
double d1, d2, d3, minimum_rate, maximum_rate;
char *preamble[]=
{"We, the people of the United States, in order to form a more perfect\n",
"Union, establish justice, insure domestic tranquillity, provide for the\n",
"common defense, promote the general welfare, and secure the blessings\n",
"of liberty to ourselves and our posterity, do ordain and establish this\n",
"Constitution for the United States of America.\n\n\n",
0};

main(argc, argv) int argc; char **argv;
{	double f;
	initialize_parameters(argc, argv);
	init_graphics();
	if(starting_screen)
		{switch(starting_screen)
			{
			case 1: goto SCR_1;
			case 2: goto SCR_2;
			case 3: 
			case 4: 
			case 5: 
			case 6: 
			case 7: goto SCR_3;
			case 8: goto SCR_8;
			case 9: goto SCR_9;
			case 10: goto SCR_10;
			case 11: goto SCR_11;
			case 12: goto SCR_12;
			case 13: goto SCR_13;
			case 14: goto SCR_14;
			case 15: goto SCR_15;
			case 16: goto SCR_16;
			case 17: goto SCR_17;
			case 18: goto SCR_18;
			case 19: goto SCR_19;
			case 20: goto SCR_20;
			}
		}
						/*
								initial information screen
						*/
SCR_1:
	if(!no_characters)
		{gotoxy(0, char_height);
		sprintf(buf, "1: Interface version %s \nfor the %s\n\n",
			interface_version, machine);
		(*draw_text)(buf);
		sprintf(buf, "screen width %d pixels\nheight %d pixels\n",
			pixels_wide, pixels_high);
		(*draw_text)(buf);
		sprintf(buf, "screen width %d characters\nheight %d rows\n",
			char_columns, char_rows);
		(*draw_text)(buf);
		sprintf(buf, "%d colors\n", max_color+1);
		(*draw_text)(buf);
		(*draw_text)("\nThis text is in the default colors,\n");
		(*draw_text)("which should be white on black.\n");
#ifdef JKHJJ
		print_prim_attr(&prim_attr);
#endif
		wait(); clear_graphics();
		}
						/*
								display text at various intensities
						*/
SCR_2:
	if(!no_characters)
		{set_intensity(1.);						/* white characters */
		set_background_intensity(0.);			/* black background */
		gotoxy(0, char_height);
		(*draw_text)("2: text intensities\n\n            requested  reported ");
		y1=3*char_height;
		for (intensity=0.; intensity<=1.; intensity+=1./13.)
			{set_intensity(intensity);
			gotoxy(0, y1+=char_height); (*draw_text)("fg intensity  ");
			sprintf(buf, "%5.3f     %5.3f", intensity, inquire_intensity());
			set_intensity(1.);
			set_background_intensity(0.);
			(*draw_text)(buf);
			}
		x1 = .5*pixels_wide; y1 = 3*char_height;
		for (f = 0.; f < 1.; f += .0625)
			{i = f*(max_color+1);
			set_color(i);
			gotoxy(x1, y1+=char_height);
			sprintf(buf, "color %2d  ", i);
			(*draw_text)(buf);
			set_intensity(1.);
			if(i == 0) (*draw_text)("white");
			if(i == max_color) (*draw_text)("black");
			}

		wait(); clear_graphics();
		}

						/*
								draw barber-pole patterns in top 
								right & bottom left corners
						*/
SCR_3:
	set_intensity(.4);
	box(0, 0, pixels_wide-1, pixels_high-1);
	set_intensity(1.);
	set_background_intensity(0.);
	if(no_characters)
		{puts("\n character routine demo omitted ");
		for(i=1; i<1000; i++) for(j=1; j<100; j++) ;
		set_intensity(1.);
		}
	else
		char_placement();
	wait(); clear_graphics();

						/*
							diamonds
						*/
SCR_8:
	set_intensity(1.);
	set_background_intensity(0.);
	if(!no_characters)
		{gotoxy(1, pixels_high-2*char_height);
		(*draw_text)("8: lines end ");
		gotoxy(1, pixels_high-1*char_height);
		(*draw_text)("accurately?");
		}
	set_intensity(.7);
	dely=pixels_high/45;
	w0=(pixels_wide-1)/4;
	y1=((pixels_high/2.)/dely)*dely;
	y2=0;
	while(y2<pixels_high)	{(*draw_line)(0, y1, w0-1, y2); y2+=dely;}
	while(y2>0)				{y2-=dely; (*draw_line)(2*w0, y1, w0+1, y2);}
	delx=pixels_wide/70;
	x2=pixels_wide/2; x1=((pixels_wide/4.)/delx)*delx+x2; y2=pixels_high-1;
	while(x2<pixels_wide)	{(*draw_line)(x1, 0, x2, y1); x2+=delx;}
	while(x2>pixels_wide/2)	{x2-=delx; (*draw_line)(x1, y2, x2, y1+2);}
	wait(); clear_graphics();

						/*
							displaying the available colors
						*/
SCR_9:
	if(max_color>1)
		{show_colors();
		wait(); clear_graphics();
		}

	if(erasing)
		{

						/*
							drawing & erasing rectangles
						*/
SCR_10:
		rectangles();
		wait(); clear_graphics();

						/*
							creating & erasing rectangles of different
							intensities
						*/
SCR_11:
		set_intensity(1.);
		set_background_intensity(0.);
		if(!no_characters)
			{gotoxy(0, pixels_high-1*char_height);
			(*draw_text)("11: drawing and erasing algorithms match?");
			}
		x1=0; x2=.6*pixels_wide;
		for (intensity=.938; intensity>0.; intensity-=.125)
			{if(!no_characters)
				{gotoxy(0, (int)(.7*pixels_high+2.*char_height));
				set_intensity(1.);
				set_background_intensity(0.);
				sprintf(buf, "intensity %5.3f", intensity);
				(*draw_text)(buf);
				}
			set_intensity(intensity);
			rectangle(.4, x1);
			x1=x2-x1;
			}
		wait(); clear_graphics();
		}

						/*
							timed squares
						*/
SCR_12:
	set_intensity(1.);
	set_background_intensity(0.);
	if(!no_characters)
		{gotoxy(pixels_wide-char_width*11, pixels_high-1);
		(*draw_text)("12: timing");
		}
	timed_squares();
	d1=t1; d2=t2; d3=t3;
	del1=d2-d1; del2=d3-d2;
	if(!erasing) {del1=2*del1; del2=2*del2; clear_graphics();}
	if(!no_characters)
		{gotoxy(0, char_height);
		if(d2 > d1)
			{sprintf(buf, "large square: %3.0f tics, or %3.0f lines/sec\n",
			d2 - d1, 32000./del1);
			(*draw_text)(buf);
			}
		if(d3 > d2)
			{sprintf(buf, "small square: %3.0f tics, or %3.0f lines/sec\n\n",
			d3 - d2, 32000./del2);
			(*draw_text)(buf);
			}
		}
	else
		{if(d1 > d2)
			printf(buf, "large square: %3.0f tics, or %3.0f lines/sec\n",
			d2 - d1, 32000./del1);
		if(d2 > d1)
			printf(buf, "small square: %3.0f tics, or %3.0f lines/sec\n\n",
			d3 - d2, 32000./del2);
		}
	if(d2 > d1 && d3 > d2 && del2 > del1)
		{maximum_rate=(32000.*9)/(10*(del2)-(del1));
		minimum_rate=(32000.*maximum_rate)/(2*maximum_rate*(del1)-16000.);
		overhead=(100*minimum_rate)/maximum_rate;
/*		sprintf(buf, "maximum drawing speed = %4.0f lines/sec  \n", maximum_rate);
			(*draw_text)(buf); */
		sprintf(buf, "minimum drawing speed = %4.0f lines/sec  \n", minimum_rate);
			(*draw_text)(buf);
		sprintf(buf, "(for which %ld%% is overhead independent of line length) \n",
			overhead);
			(*draw_text)(buf);
		}

	wait(); clear_graphics();

						/*
							draw stripes of negative and positive width 
							and bow tie of horizontal lines					
						*/	
SCR_13:
	set_intensity(1.);
	set_background_intensity(0.);
	if(!no_characters)
		{gotoxy(0, pixels_high-1*char_height);
		(*draw_text)("13: accurate horizontal lines?");
		}
	set_intensity(.7);
	for(x1=20, k=-13; k<19; x1+=abs(k)+9, k++)
		{i=x1;
		for(y1=0; y1<39 && i+k<pixels_wide; i++, y1++)
			(*draw_line)(i, y1, i+k, y1);
		}
	x1=0; x2=pixels_high/3;
	for(y1=40; y1<pixels_high && x1<pixels_wide ; y1++)
		{(*draw_line)(x1, y1, x2, y1);
		x2++;
		x1+=2;
		}
	wait(); clear_graphics();
	if(erasing)
		{
		set_intensity(1.);
		set_background_intensity(0.);
		if(!no_characters)
			{gotoxy(0, pixels_high-1*char_height);
			(*draw_text)("13: erasing horizontal lines?");
			}
		y2 = pixels_high - 2*char_height - 1;
		solid_square(.7, 0, 0, pixels_wide - 1, y2);
		set_intensity(.7);
		for(x1=20, k=-13; k<19; x1+=abs(k)+9, k++)
			{i=x1;
			for(y1=0; y1<39 && i+k<pixels_wide; i++, y1++)
				(*erase_line)(i, y1, i+k, y1);
			}
		x1=0; x2=pixels_high/3;
		for(y1=40; y1<y2 && x1<pixels_wide ; y1++)
			{(*erase_line)(x1, y1, x2, y1);
			x2++;
			x1+=2;
			}
		wait(); clear_graphics();
		}
	if(flipping)
		{
		set_intensity(1.);
		set_background_intensity(0.);
		if(!no_characters)
			{gotoxy(0, pixels_high-1*char_height);
			(*draw_text)("13: flipping horizontal lines?");
			}
		fan();
		for(x1=20, k=-13; k<19; x1+=abs(k)+9, k++)
			{i=x1;
			for(y1=0; y1<39 && i+k<pixels_wide; i++, y1++)
				(*flip_line)(i, y1, i+k, y1);
			}
		x1=0; x2=pixels_high/3;
		for(y1=40; y1<y2 && x1<pixels_wide ; y1++)
			{(*flip_line)(x1, y1, x2, y1);
			x2++;
			x1+=2;
			}
		wait(); 
		for(x1=20, k=-13; k<19; x1+=abs(k)+9, k++)
			{i=x1;
			for(y1=0; y1<39 && i+k<pixels_wide; i++, y1++)
				(*flip_line)(i, y1, i+k, y1);
			}
		x1=0; x2=pixels_high/3;
		for(y1=40; y1<y2 && x1<pixels_wide ; y1++)
			{(*flip_line)(x1, y1, x2, y1);
			x2++;
			x1+=2;
			}
		wait();


		set_intensity(1.);
		set_background_intensity(0.);
		if(!no_characters)
			{gotoxy(0, pixels_high-1*char_height);
			(*draw_text)("13: flipping lines?           ");
			}
		x1 = pixels_wide/2; y1 = 0;
		x2 = pixels_wide/2, y2 = pixels_high-1;
		for ( ; x1 && y2; x1--)
			{flip_box(x1, y1, x2, y2);
			flip_box(x1--, y1++, x2++, y2--);
			}
		flip_star();
		wait(); 
		flip_star();

		wait(); clear_graphics();
		}

						/*
							draw bow tie of vertical lines
						*/
SCR_14:
	set_intensity(1.);
	set_background_intensity(0.);
	if(!no_characters)
		{gotoxy(0, pixels_high-1*char_height);
		(*draw_text)("14: accurate vertical lines?");
		}
	x1=20;
	set_intensity(.5);
	for(y1=0, y2=pixels_high/5 ; y1<(pixels_high*7)/8 ; x1++, y2++, y1+=2)
		(*draw_line)(x1, y1, x1, y2);
	k=-10;
	for(x1=35 ; x1+20<pixels_wide ; x1+=abs(k)+9)
		{x2=x1;
		for(y1=11 ; y1<25 ; y1++)
			{(*draw_line)(x2, y1, x2, y1+k);
			x2++;
			}
		k++;
		}
	wait(); clear_graphics();

						/*
							right triangle (near-vertical lines)
						*/
SCR_15:
	set_intensity(1.);
	set_background_intensity(0.);
	if(!no_characters)
		{gotoxy(0, pixels_high-3*char_height);
		(*draw_text)("15: centered step in near-vertical\n");
		(*draw_text)("and near-horizontal lines?");
		}
	j=0;
	set_intensity(.7);
	for (i=3; i<100; i=i+3)
		{(*draw_line)(i, 0, i-1, j);
		(*draw_line)(0, i, j, i-1); j=j+1;
		}
	wait(); clear_graphics();

						/*
							this should draw a vertical line
						*/
SCR_16:
	if(!no_characters)
		{gotoxy(0, char_height);
		(*draw_text)("16: display of zero-length horizontal lines");
		}
	for (i=50;i<100; i++) (*draw_line)(pixels_wide/2, i, pixels_wide/2, i);
	wait(); clear_graphics();

						/*
							color bars
						*/
SCR_17:
	if(!no_characters) gotoxy(0, char_height);
	(*draw_text)("17: color & intensity bars \n");
	x1=pixels_wide-1;
	y2=char_height;
	for (i=0; i<=max_color && y2<pixels_high; i++)
		{set_color(i);
		for (j=0; j<pixels_high/(max_color+1)/2 && j<7; j++) 
			{(*draw_line)(0, y2, x1, y2); y2++;
			}
		y2 += 3;
		}
	gotoxy(3*char_width, 6*char_height); (*draw_text)("text");

						/*
							intensity bars
						*/
	x1=0; x2=pixels_wide/3;
	y1=pixels_high-1;
	for (intensity=0.; intensity<=1.; intensity+=3./(pixels_high-y2))
		{set_intensity(intensity);
		(*draw_line)(x1, y1, x2, y1); y1--;
		}
	wait();
	if(erasing)
		{
						/*
							erasing color bars
						*/
/* an 'A' on row r, column c  has lower left corner on raster (y value)
			y = 	r*char_height + y_offset 
	at pixel
			x = 	c*char_width + x_offset			*/
SCR_18:
		if(!no_characters)
			{gotoxy(0, char_height);
			(*draw_text)("18: erasing                                  ");
			}
		y1=char_height;
		x1=12*char_width;
		x2=pixels_wide*7/10;
		if(!no_characters) gotoxy(x1, char_height);
		for (i=0; i<=max_color && x1<pixels_wide; i++)
			{set_intensity(1.);
			set_background_intensity(0.);
			if(!no_characters)
				{sprintf(buf, "%3d", i); (*draw_text)(buf);
				}
			set_color(i);
			x1 += 3*char_width;
			(*erase_line)(x1-3, y1, x1-3*char_width-3, y2);
			(*erase_line)(x1-2, y1, x1-3*char_width-2, y2);
			(*erase_line)(x1-1, y1, x1-3*char_width-1, y2);
			}
		wait(); clear_graphics();
		}
SCR_19:
	if(!no_characters)
		{gotoxy(0, pixels_high - 1);
		set_color(0);
		set_background_color(max_color);
		(*draw_text)("19: text colors                              ");
		x1 = y1 = 0;
		gotoxy(0, y1 += char_height);
		(*draw_text)("fore  back");
		gotoxy(0, y1 += char_height);
		(*draw_text)("    ");
		for (i = 0; i <= max_color && x1 < pixels_wide; i++)
			{sprintf(buf, " %2d ", i);
			(*draw_text)(buf);
			}
		for (j = 0; j <= max_color && y1 < pixels_high; j++)
			{gotoxy(0, y1 += char_height);
			set_color(0);
			set_background_color(max_color);
			sprintf(buf, " %2d ", j);
			(*draw_text)(buf);
			set_color(j);
	
			for (x1 = i = 0; i <= max_color && x1 < pixels_wide; i++)
				{set_background_color(i);
				(*draw_text)(" jrv");
				x1 += 4*char_width;
				}
			}

		wait(); clear_graphics();
		}

SCR_20:
	if(!no_characters)
		{gotoxy(0, pixels_high - 1);
		set_color(0);
		set_background_color(max_color);
		(*draw_text)("20: bars                                     ");
		for (i = 0; i <= max_color && i < 8; i++)
			{set_color(i);
			x1 = 0;
			x2 = pixels_wide/2 - 1;
			y2 = pixels_high - 2.*char_height;
			for (y1 = char_height; y1 < y2; y1++)
				(*draw_line)(x1, y1, x2, y1);
			}
/*		for (i = 0; i <= max_color && i < 8; i ++)
			{set_color(i);
			x1 = 0;
			x2 = pixels_wide/2 - 1;
			y2 = pixels_high - 2.*char_height;
			x1 = x2; x2 = pixels_wide - 1;
			bar(x1, char_height, x2, y2); 
			}
*/
		wait(); clear_graphics();
		}

	finish_graphics();
}

fan()
{	int x1, x2, y1, y2;

	set_intensity(.7);
	x1 = pixels_high & (~31); 
	x2 = 0;
	y2 = pixels_high - 2*char_height - 1;
	while(x1 < pixels_wide)
		{
		while(x1&32)
			{
			if(x1 >= pixels_wide) break;		
			(*draw_line)(x1++, 0, x2++, y2);
			}
		x1 += 32;
		}
}

box(x1, y1, x2, y2) int x1, y1, x2, y2;
{	(*draw_line)(x1, y1, x1, y2); 
	(*draw_line)(x1, y2, x2, y2); 
	(*draw_line)(x2, y2, x2, y1); 
	(*draw_line)(x2, y1, x1, y1);
	}

flip_box(x1, y1, x2, y2) int x1, y1, x2, y2;
{
	(*flip_line)(x1, y1, x2, y1);
	(*flip_line)(x2, y1, x2, y2);
	(*flip_line)(x2, y2, x1, y2);
	(*flip_line)(x1, y2, x1, y1);
}

flip_star()
{	int x1, x2, y1, y2, i;

	x2=pixels_wide*best_height-1; x1=x2/2;
	y2=(pixels_high - char_height*2)*best_width-1; y1=y2/2;
	for (i=0; i<20; i++) {(*flip_line)(x1, y1, 0, (int)((i*y2)/20));}
	for (i=0; i<20; i++) {(*flip_line)(x1, y1, (int)((i*x2)/20), y2);}
	for (i=20; i>0; i--) {(*flip_line)(x1, y1, x2, (int)((i*y2)/20));}
	for (i=20; i>0; i--) {(*flip_line)(x1, y1, (int)((i*x2)/20), 0);}
}

char s1[]="6: vertical clipping ";
char s2[]="7: horizontal clipping ";

char_placement()
{	int i, n;
	char **sv;

	switch(starting_screen)
		{
		case 0:
		case 3: goto CHAR_SCR_3;
		case 4: goto CHAR_SCR_4;
		case 5: goto CHAR_SCR_5;
		case 6: goto CHAR_SCR_6;
		case 7: goto CHAR_SCR_7;
		}
						/*
							display scattered characters
						*/
CHAR_SCR_3:
	gotoxy(0, char_height);
	set_intensity(1.);
	set_background_intensity(0.);
	(*draw_text)(" 3: character size \n and placement?");
	gotoxy(char_width, 8*char_height);
	sprintf(buf, "screen height:width ratio %5.3f:%5.3f\n",
		best_height, best_width);
	(*draw_text)(buf);
	q=0; 
	for(i=0; i<64; i++)
		{n=(q>>3)+(q&7); 
		gotoxy(
			((q&7)+pixels_wide/char_width-8)*char_width,
			((q>>3)+1)*char_height);
		(*draw_char)('a'+n);
		gotoxy(
			(q&7)*char_width,
			(pixels_high-1+((q>>3)-7)*char_height));
/*			((q>>3)+pixels_high/char_height-7)*char_height); */
		(*draw_char)('a'+n);
		q=(q+17)%64;
		}
	gotoxy(char_width, 5*char_height);
	set_intensity(1.);
	x2=pixels_wide-1; x1=x2-8*char_width;
	y1=0; y2=y1+char_height*8;
	box(x1, y1, x2, y2);          /* upper right corner */
	x1=0; x2=x1+char_width*8;
	y2=pixels_high-1; y1=y2-8*char_height; 
	box(x1, y1, x2, y2);          /* lower left corner */
	wait(); clear_graphics();

						/*
							time the writing of characters
						*/
CHAR_SCR_4:
	gotoxy(0, char_height);
	(*draw_text)("4: text display speed");
	t1=tics(); n=0;
	do
		{
		gotoxy(0,(pixels_high-char_height*7)/2);
		set_intensity(.5);
		for (sv=preamble; *sv; sv++) {n+=strlen(*sv); (*draw_text)(*sv);}
		t2 = tics();
		} while((t2 - t1) < 100 && n < 5000);
	set_intensity(1.);
	set_background_intensity(0.);
	if(t2!=t1)
		{sprintf(buf, "          displayed %3.0f char/sec", (100.*n)/(t2-t1));
		(*draw_text)(buf);
		}
	else (*draw_text)("(timing disabled)");
	wait(); clear_graphics();

						/*
							time the writing of characters
						*/
CHAR_SCR_45:
	gotoxy(0, char_height);
	(*draw_text)("4: text display speed");
	t1=tics(); n=0;
	do
		{
		gotoxy(0,(pixels_high-char_height*7)/2);
		set_intensity(0.);
		set_background_intensity(.5);
		for (sv=preamble; *sv; sv++) {n+=strlen(*sv); (*draw_text)(*sv);}
		t2 = tics();
		} while((t2 - t1) < 100 && n < 5000);
	set_intensity(1.);
	set_background_intensity(0.);
	if(t2!=t1)
		{sprintf(buf, "          displayed %3.0f char/sec", (100.*n)/(t2-t1));
		(*draw_text)(buf);
		}
	else (*draw_text)("(timing disabled)");
	wait(); clear_graphics();

						/*
							check placement of char
						*/
CHAR_SCR_5:
/*
	x0=5;
	for (y0=5; x0<pixels_wide; y0++, x0+=5*char_width)
		{gotoxy(x0, y0); sprintf(buf,"y=%d", y0); (*draw_text)(buf);
		}
*/
	n=(char_rows-4)/2;
	if(n>char_columns/5) n=char_columns/5;
	x0=x1=pixels_wide/2-n*char_width;
	y0=y1=2*char_height;
	for (i=n; i; i--)
		{x2=x1; y2=y1;
		for (j=n; j; j--)
			{gotoxy(x2, y2); (*draw_char)('/');
			x2+=2*char_width; y2++;
			}
		x1++; y1+=2*char_height;
		}
	set_intensity(.4);
	x2=2*n*char_width; y2=2*n*char_height;  /* line lengths */
	n++;  /* # lines in each direction */
	x1=x0=x0-char_width/2; y1=y0=y0-(char_height*3)/2;  /* top left corner */
	for (i=n; i; i--)
		{(*draw_line)(x1, y1, x1+x2, y1+n);
		x1++; y1+=2*char_height;
		}
	for (i=n; i; i--)
		{(*draw_line)(x0, y0, x0+n, y0+y2);
		x0+=2*char_width; y0++;
		}
	set_intensity(1.); gotoxy(0, pixels_high - char_height);
	set_background_intensity(0.);
	(*draw_text)("5: Accuracy of \n   character placement?");
	wait(); clear_graphics();

						/*
							check vertical clipping
						*/
CHAR_SCR_6:
	set_intensity(.4);
	box(0, 0, pixels_wide-1, pixels_high-1);
	set_intensity(1.);
	set_background_intensity(0.);
	gotoxy((pixels_wide-char_width*strlen(s1))/2, pixels_high/2);
	(*draw_text)(s1);
	i=0;
	for (y2=pixels_wide/char_width; y2>2*char_height; y2-=char_height)
		{x1=12; y1=y2;
		while(x1<pixels_wide)
			{gotoxy(x1,char_height/2+y1); (*draw_char)('a'+i);
			gotoxy(x1,pixels_high+char_height/2-y1); (*draw_char)('A'+i);
			x1+=char_width; y1--;
			}
		i++;
		}
	wait(); clear_graphics();

						/*
							check horizontal clipping
						*/
CHAR_SCR_7:
	set_intensity(.4);
	box(0, 0, pixels_wide-1, pixels_high-1);
	set_intensity(1.);
	set_background_intensity(0.);
	gotoxy((pixels_wide-char_width*strlen(s2))/2, pixels_high/2);
	(*draw_text)(s2);
	i=0;
	for (x2=2*pixels_high/char_height; x2>char_width; x2-=char_width)
		{x1=x2; y1=2*char_height;
		while(y1<pixels_high)
			{gotoxy(x1-char_width/2,y1); (*draw_char)('a'+i);
			gotoxy(pixels_wide-x1-char_width/2,y1); (*draw_char)('A'+i);
			x1--; y1+=char_height;
			}
		i++;
		}
}

rectangle(size, move) double size; int move;
{	int x1, y1, x2, y2, i;

	x2=size*pixels_wide*best_height-1; x1=x2/2;
	y2=size*pixels_high*best_width-1; y1=y2/2;
	for (i=0; i<20; i++) {(*draw_line)(move+x1, y1, move+0, (i*y2)/20);}
	for (i=0; i<20; i++) {(*draw_line)(move+x1, y1, move+(i*x2)/20, y2);}
	for (i=20; i>0; i--) {(*draw_line)(move+x1, y1, move+x2, (i*y2)/20);}
	for (i=20; i>0; i--) {(*draw_line)(move+x1, y1, move+(i*x2)/20, 0);}
	for (i=0; i<20; i++) {(*erase_line)(move+x1, y1, move+0, (i*y2)/20);}
	for (i=0; i<20; i++) {(*erase_line)(move+x1, y1, move+(i*x2)/20, y2);}
	for (i=20; i>0; i--) {(*erase_line)(move+x1, y1, move+x2, (i*y2)/20);}
	for (i=20; i>0; i--) {(*erase_line)(move+x1, y1, move+(i*x2)/20, 0);}
}

rectangles()
{	int x1, x2, y1, y2, w1, w2, dx, dy;

						/*
							drawing a rectangle
						*/
	set_intensity(1.);
	set_background_intensity(0.);
	if(!no_characters)
		{gotoxy(0, pixels_high-2*char_height);
		(*draw_text)("10: lines in different");
		gotoxy(0, pixels_high-1*char_height);
		(*draw_text)("directions symmetric?");
		}
	set_intensity(.6);
	dx=pixels_wide/40; dy=pixels_high/30;
	x1=pixels_wide/4; y1=pixels_high/4;
	w1=w2=0;
	while(w2<pixels_high/2)	{(*draw_line)(x1, y1, w1, w2); w2+=dy;} y2=w2;
	while(w1<pixels_wide/2)	{(*draw_line)(x1, y1, w1, w2); w1+=dx;}
	while(w2>0) 			{(*draw_line)(x1, y1, w1, w2); w2-=dy;}
	while(w1>0) 			{(*draw_line)(x1, y1, w1, w2); w1-=dx;}

						/*
							erasing a rectangle
						*/
	if(erasing)
		{set_intensity(1.);
		set_background_intensity(0.);
		x1=pixels_wide/2; x2=pixels_wide-1;

		y1 = 0; 
		dy = pixels_high/30;
		y2 = pixels_high/2 + dy - 1; y2 -= y2%dy;
		dx = pixels_wide/16;
		dy = pixels_high/16;
		solid_square(1.0, x1, y1, x2, y2);
		if(max_color > 1)
			{solid_square(.75, x1+=dx, y1+=dy, x2-=dx, y2-=dy);
			solid_square(.50, x1+=dx, y1+=dy, x2-=dx, y2-=dy);
			solid_square(.25, x1+=dx, y1+=dy, x2-=dx, y2-=dy);
			}
/*		for(y1=0; y1<y2; y1++) draw_line(x1, y1, x2, y1); */
		dx=pixels_wide/40; dy=pixels_high/30;
		x1=pixels_wide/4*3; y1=pixels_high/4;
		x2=pixels_wide-1; y2=0;
		x1=x2-pixels_wide/4;
		while(y2<pixels_high/2)	{(*erase_line)(x1, y1, x2, y2); y2+=dy;}
		while(x2>pixels_wide/2)	{(*erase_line)(x1, y1, x2, y2); x2-=dx;}
		while(y2>0)				{(*erase_line)(x1, y1, x2, y2); y2-=dy;}
		while(x2<pixels_wide-1)	{(*erase_line)(x1, y1, x2, y2); x2+=dx;}
		}
}

solid_square(gray, x1, y1, x2, y2) double gray; int x1, y1, x2, y2;
{	int y;
	set_intensity(gray);
	if(y2 < y1) {y = y1; y1 = y2; y2 = y;}
	for (y = y1; y <= y2; y++)
		(*draw_line)(x1, y, x2, y);
}

timed_squares()
{	int x1, x2, y1, y2;
	long i;

	t1=tics();
	x2=pixels_wide*best_height-1; x1=x2/2;
	y2=pixels_high*best_width-1; y1=y2/2;
	for (i=0; i<40; i++) {(*draw_line)(x1, y1, 0, (int)((i*y2)/40));}
	for (i=0; i<40; i++) {(*draw_line)(x1, y1, (int)((i*x2)/40), y2);}
	for (i=40; i>0; i--) {(*draw_line)(x1, y1, x2, (int)((i*y2)/40));}
	for (i=40; i>0; i--) {(*draw_line)(x1, y1, (int)((i*x2)/40), 0);}
	if(erasing)
		{for (i=0; i<40; i++) {(*erase_line)(x1, y1, 0, (int)((i*y2)/40));}
		for (i=0; i<40; i++) {(*erase_line)(x1, y1, (int)((i*x2)/40), y2);}
		for (i=40; i>0; i--) {(*erase_line)(x1, y1, x2, (int)((i*y2)/40));}
		for (i=40; i>0; i--) {(*erase_line)(x1, y1, (int)((i*x2)/40), 0);}
		}
	t2=tics();
	x2=x2/10; x1=x2/2;
	y2=y2/10; y1=y2/2;
	for (i=0; i<40; i++) {(*draw_line)(x1, y1, 0, (int)((i*y2)/40));}
	for (i=0; i<40; i++) {(*draw_line)(x1, y1, (int)((i*x2)/40), y2);}
	for (i=40; i>0; i--) {(*draw_line)(x1, y1, x2, (int)((i*y2)/40));}
	for (i=40; i>0; i--) {(*draw_line)(x1, y1, (int)((i*x2)/40), 0);}
	if(erasing)
		{for (i=0; i<40; i++) {(*erase_line)(x1, y1, 0, (int)((i*y2)/40));}
		for (i=0; i<40; i++) {(*erase_line)(x1, y1, (int)((i*x2)/40), y2);}
		for (i=40; i>0; i--) {(*erase_line)(x1, y1, x2, (int)((i*y2)/40));}
		for (i=40; i>0; i--) {(*erase_line)(x1, y1, (int)((i*x2)/40), 0);}
		}
	t3=tics();
}

						/*
							displaying the available colors
						*/
show_colors()
{	int nc, delx, dely, x1, y1, x2, y2, i;
	if(!no_characters)
		{gotoxy(pixels_wide/2-10*char_width, (pixels_high+char_height)/2);
		sprintf(buf, "9: all %d colors displayed?", max_color+1);
		(*draw_text)(buf);
		}
	nc=max_color+1;
	delx=.8*pixels_wide/max_color/2;
	dely=.8*pixels_high/max_color/2;
	x2=pixels_wide/2; x1=x2-max_color*delx;
	y1=pixels_high/2; y2=y1-max_color*dely;
	for(i=0; i<=max_color; i++)
		{set_color(i);
		(*draw_line)(0, y1, x1, y1);
		(*draw_line)(x1, y1, x2, y2);
		(*draw_line)(x2, y2, x2, 0);
		(*draw_line)(x1, pixels_high-1-y1, x2, pixels_high-y2);
		(*draw_line)(0, pixels_high-1-y1, x1, pixels_high-1-y1);
		(*draw_line)(x2, pixels_high-y2, x2, pixels_high-1);
		y1 -= dely; x1 += delx; x2 += delx; y2 += dely;
		}
}

wait()
{	char c;
#ifdef __TURBOC__
	c=getch();
#else
	c=ci();
#endif
	if((c=='q')|(c=='x')) {finish_graphics(); exit();}
}

#ifdef JKHJJ
typedef struct PRIM_ATTR
	{int	color_count;               /* # colors                          */
	int     intensity_count;           /* # intensities                     */
	int     intensities_in_hardware;   /* nonzero if supported in hardware  */
	int     hardware_linestyles;       /* # linestyles in hardware          */
	int     software_linestyles;       /* # linestyles in software          */
	int     linewidth_count;           /* # linewidths                      */
	int     linewidths_in_hardware;    /* nonzero if supported in hardware  */
	int     linewidth_minimum;         /*                                   */
	int     linewidth_maximum;         /*                                   */
	int     hardware_pens;             /*                                   */
	int     software_pens;             /*                                   */
	int     charfont_count;            /* # fonts                           */
	int     charsize_count;            /* # character sizes                 */
	int     charsize_in_hardware;      /* nonzero if supported in hardware  */
	int     charsize_minimum;          /*                                   */
	int     charsize_maximum;          /*                                   */
	int     hardware_markers;          /* # markers in hardware             */
	int     software_markers;          /* # markers in software             */
	int     pick_id_count;             /* # pick IDs in hardware            */
	};

/* print_prim_attr - print primitive attribute structure */
print_prim_attr(pa) PRIM_ATTR *pa;
{	sprintf(buf, "Primitive attributes...\n");
	(*draw_text)(buf);
	sprintf(buf, "color_count=               %d \n", pa->color_count);
	(*draw_text)(buf);
	sprintf(buf, "intensity_count=           %d \n", pa->intensity_count);
	(*draw_text)(buf);
	sprintf(buf, "intensities_in_hardware=   %d \n", pa->intensities_in_hardware);
	(*draw_text)(buf);
	sprintf(buf, "hardware_linestyles=       %d \n", pa->hardware_linestyles);
	(*draw_text)(buf);
	sprintf(buf, "software_linestyles=       %d \n", pa->software_linestyles);
	(*draw_text)(buf);
	sprintf(buf, "linewidth_count=           %d \n", pa->linewidth_count);
	(*draw_text)(buf);
	sprintf(buf, "linewidths_in_hardware=    %d \n", pa->linewidths_in_hardware);
	(*draw_text)(buf);
	sprintf(buf, "linewidth_minimum=         %d \n", pa->linewidth_minimum);
	(*draw_text)(buf);
	sprintf(buf, "linewidth_maximum=         %d \n", pa->linewidth_maximum);
	(*draw_text)(buf);
	sprintf(buf, "hardware_pens=             %d \n", pa->hardware_pens);
	(*draw_text)(buf);
	sprintf(buf, "software_pens=             %d \n", pa->software_pens);
	(*draw_text)(buf);
	sprintf(buf, "charfont_count=            %d \n", pa->charfont_count);
	(*draw_text)(buf);
	sprintf(buf, "charsize_count=            %d \n", pa->charsize_count);
	(*draw_text)(buf);
	sprintf(buf, "charsize_in_hardware=      %d \n", pa->charsize_in_hardware);
	(*draw_text)(buf);
	sprintf(buf, "charsize_minimum=          %d \n", pa->charsize_minimum);
	(*draw_text)(buf);
	sprintf(buf, "charsize_maximum=          %d \n", pa->charsize_maximum);
	(*draw_text)(buf);
	sprintf(buf, "hardware_markers=          %d \n", pa->hardware_markers);
	(*draw_text)(buf);
	sprintf(buf, "software_markers=          %d \n", pa->software_markers);
	(*draw_text)(buf);
	sprintf(buf, "pick_id_count=             %d \n", pa->pick_id_count);
	(*draw_text)(buf);
}

#endif

getint(s) char *s;
{	int x, i;
	char buffer[128], c;

	puts(s); gets(buffer);
	x=0; i=0;
	while(c=buffer[i++]) x=x*10+c-'0';
	return x;
}

/*							dummy routines		*/
/*
pixel_insert(i, j) int i, j;
{	printf("inserting pixel at address %d with mask %d \n", i, j);
	wait();
}
byte_insert(i, j) int i, j;
{	printf("inserting byte %d at address %d \n", j, i);
	wait();
}
*/
/*
	tics - report hundreths of a second since midnight
*/
long tics()
{

#ifdef __TURBOC__
#include <sys\timeb.h>
	struct timeb TimeBuf;
	ftime(&TimeBuf);
	return 100L*TimeBuf.time + TimeBuf.millitm/10;
#else
	return 0L;
	int hr, min, sec, hun;
	_timer(&hr, &min, &sec, &hun);
	return (( (long) hr*60+min)*60+sec)*100+hun;
#endif
}

/* #ifndef __TURBOC__
/* _timer()
/* {
/* #asm
/* 	push bp
/* 	mov	ah,2ch
/* 	int	21h
/* 	pop bp
/* 	mov	bx,[bp+4]
/* 	mov	[bx],ch		;hours
/* 	mov	byte [bx+1],0
/* 	mov	bx,[bp+6]
/* 	mov	[bx],cl		;minutes
/* 	mov	byte [bx+1],0
/* 	mov	bx,[bp+8]
/* 	mov	[bx],dh		;seconds
/* 	mov	byte [bx+1],0
/* 	mov	bx,[bp+10]
/* 	mov	[bx],dl		;hundreths
/* 	mov	byte [bx+1],0
/* #endasm
/* }
/* #endif
/* */

#define FIRST_OPTION 1  /* first "dash option", where 0 is program name */
initialize_parameters(argc, argv) int argc; char **argv;
{	int i;
/*	file; */

	if(argc>1 && strcmp(argv[1], "?")==0) help();
	argc--; argv++;
	while(argc>0)
		{/* printf("read_data: parsing \"%s\" \n", *argv); */
		i=get_parameter(argc, argv);
		argv=argv+i; argc=argc-i;
		}
}

/* get_parameter - process one command line option
		(return # parameters used) */
get_parameter(argc, argv) int argc; char **argv;
{	if(streq(*argv, "-c")) {no_characters=1; return 1;}
	else if(streq(*argv, "-e")) {erasing=0; return 1;}
	else if(streq(*argv, "-n")) {starting_screen = atoi(argv[1]); return 2;}
	else gripe(argv);
}

int streq(a, b) char *a, *b;
{	while(*a)
		{if(*a!=*b)return 0;
		a++; b++;
		}
	return 1;
}

gripe(argv) char **argv;
{	puts(*argv); puts(" isn\'t a legal argument \n");
	help();
}

help()
{	printf("sample usage...\nbench  [options]\n");
	printf("options are:\n");
	printf("-c   omit calls to character functions \n");
	printf("-e   omit calls to erasing routine \n");
	printf("-n <num>  start on specific screen\n");
	exit();
}
