\ UNLOAD PROGRAM, BY TOM ALMY.
 \ THIS PROGRAM IS COPYRIGHT (C) 1985 BY TOM ALMY,
 \ ALL RIGHTS RESERVED.

\ Registered users of ForthCMP may use this program to create 
\ INTEL hex format files for EPROM programmers.


 \ INTEL is a trademark of INTEL CORPORATION
 \ CP/M is a trademark of DIGITAL RESEARCH
 \ MS is a trademark OF MICROSOFT


\ SETUP
256 MSDOS
SCONSTANT SDEFSTR COM"
SCONSTANT DDEFSTR HEX"
HEX
6000 CONSTANT BUFSIZ   ( LARGE I/O Buffers! )
DECIMAL
32 CONSTANT MAXRECSIZE ( maximum size of HEX record )

INCLUDE DOS1
INCLUDE FILTER
VARIABLE ADDR  ( address in file of current byte )
VARIABLE CHECKSUM  ( Calculated checksum for record )
DSEG CREATE CHARBUF MAXRECSIZE ALLOT ( Character buffer )

0 0 IN/OUT 
: NOTICE 
   ." UNLOAD (.COM TO .HEX) PROGRAM " CR
   ." COPYRIGHT (C) 1985 BY THOMAS ALMY " CR ;           

0 0 IN/OUT
: USAGE   ( print usage information )
  CR 
  ." USAGE:  UNLOAD [-startloc] [infile] [outfile] " CR
  ." infile IS THE COM FILE TO CONVERT (EXTENSION .COM DEFAULT)"  CR
  ." outfile IS THE INTEL HEX OUTPUT FILE (EXTENSION .HEX DEFAULT)" CR
  ." If files not specified, then standard input and output used." CR
  ." To specify outfile without infile, use '-' for infile" CR
  ." startloc IS UNSIGNED HEX STARTING LOCATION."  CR
  ."         IF OMITTED, 100 IS ASSUMED (MS-DOS DEFAULT)"   CR
  ABORT ;
  
0 0 IN/OUT
: SETUP    HEX
  SETFILES IF USAGE THEN
  OPTIONSTRING 2@ ?DUP IF 
        OVER C@ [CHAR] ? = IF USAGE THEN     \ Added =
	2DUP + 0 C<-
	0. 2SWAP  >NUMBER 2DROP D>S ADDR ! \ Added 1-
  ELSE
	DROP 256 ADDR ! ( msdos default )  
  THEN
  ;


HEX
1 0 IN/OUT
: NIBOUT   0F AND DUP 9 > IF [CHAR] A [CHAR] 9 - 1- + THEN
   [CHAR] 0 + EMIT ;

1 0 IN/OUT
: BYTEOUT  DUP CHECKSUM +! DUP 4 RSHIFT NIBOUT NIBOUT ;

1 0 IN/OUT
: INTOUT  DUP 8 RSHIFT BYTEOUT BYTEOUT ;

0 0 IN/OUT
: MARKER [CHAR] : EMIT  CHECKSUM OFF ;

0 0 IN/OUT
: CKSOUT  CHECKSUM @ NEGATE BYTEOUT ;

DECIMAL

1 0 IN/OUT
: DATAREC ( LENGTH -- )
  ?DUP IF ( no record if no length )
   MARKER DUP BYTEOUT ADDR @ INTOUT 0 BYTEOUT
   DUP ADDR +!
   0 DO CHARBUF I + C@ BYTEOUT LOOP
   CKSOUT CR THEN ;

0 0 IN/OUT
: EOFREC   MARKER 0 BYTEOUT 0 INTOUT 1 BYTEOUT CKSOUT CR ;

0 1 IN/OUT
: FETCHDATA ( -- LENGTH )
   MAXRECSIZE DUP 
   0 DO  KEY  DUP 0< IF ( end of file ) 2DROP I LEAVE THEN CHARBUF I + C! LOOP 
   ;

0 0 IN/OUT
: MAKEHEX
  BEGIN  FETCHDATA  DUP  DATAREC
    MAXRECSIZE <> UNTIL
  EOFREC ;

: MAIN
    SETBUFS	\ set up I/O buffers before any KEY or EMIT
    NOTICE	\ print welcome message
    SETUP	\ open files and check argument string
    MAKEHEX	\ do the work
    BYE		\ close files and exit
;

INCLUDE DOS2
INCLUDE FORTHLIB
END
