; implement a sort-of UUdecoder
;

include enc.inc

CodeTop = 34
Begin   = '<'

.model tiny
.code
org 100h
Origin=EncLoadedAt-100h
Top:
  cld
  push cs
  pop es
  push di         ; save place where AB has finished and UU is coming [*]
  lea di,[bp+63h] ; and here is the input pointer
  mov al,Begin    ; look for a <
  mov cx,12000    ; over the next 12000 bytes
  repnz scasb
  jnz Error       ; Not found???
  mov si,di       ; Set source pointer to AFTER the said <
  pop di          ; restore the place where UU decoding will happen
  push di         ; and save it for later

DecTop:
  lodsb
  cmp al,CodeTop-1
  jz Decoded
  sub al,CodeTop
  jb DecTop  ; Skip what we do not understand
  cmp al,64
  jae DecTop
  mov ah,al
  lodsb
  sub al,CodeTop
  rcr ah,1   ; carry clear
  rcl al,1
  rcr ah,1
  rcl al,1   ; Whee!  al is now right for byte 1
  stosb
  lodsb
  sub al,CodeTop
  rcr ah,1
  rcl al,1
  rcr ah,1
  rcl al,1   ; Whee!  al is now right for byte 2
  stosb
  lodsb
  sub al,CodeTop
  rcr ah,1
  rcl al,1
  rcr ah,1
  rcl al,1   ; Whee!  al is now right for byte 3
  stosb
  jmp DecTop

Error:
  mov ax,4cffh
  int 21h

Decoded:
; Great!  We have now finished decoding

  push di         ; di points after the decoding
                  ; this space is free since it was filled before
                  ; with the encoded original
; Append the loader
  mov si,offset BegMoveData+Origin
  mov cx,offset EndMoveData-offset BegMoveData
  rep movsb
  pop di          ; restore di to end of decoded data
  jmp di

; This stuff now had better be relocatable.  On entry di points to its
; head.
BegMoveData:
; Copy the (now) decoded programme to ds:100=cs:100=es:100
  mov cx,di   ; cx=end of decoded data
  pop si      ; si=start of decoded data from [*]
  sub cx,si   ; length of decoded program
  inc cx
  shr cx,1    ; cx>=2*Length of decoded program
  mov di,100h
  rep movsw

  mov ax,100h
  push ax
  xor ax,ax  ; I am sure some are not needed, so I commented them out
  mov bx,ax
  mov cx,ax
  mov dx,ax
  mov si,ax
  mov di,ax
  mov bp,ax
  ret         ; jump to 100h
EndMoveData:

end Top  ; to fool tlink into making a .com file which we rename to .bin

