#include <stdio.h>
#include <time.h>
#include <sys/stat.h>

char sig[]="ENC.COM.";
#define SIGLEN 8
char buf[SIGLEN];

main()
{
  FILE *f=fopen("obf.bin","rb");
  FILE *o;
  time_t rt;
  struct stat sb;

  if(NULL==f)
  {
    fputs("Error opening obf.bin.\n",stderr);
    return 1;
  }
  fread(buf,SIGLEN,1,f);
  if(strncmp(buf,sig,SIGLEN))
  {
    fprintf(stderr,"Sorry.  Bad signature in obf.bin.\n");
    return 2;
  }
  fstat(fileno(f),&sb);
  o=fopen("enc.inc","w");
  if(NULL==o)
  {
    fputs("Error opening enc.inc.\n",stderr);
    return 3;
  }
  time(&rt);
  fprintf(o,"; enc.inc automatically generated by fixenc.exe (fixenc.c)\n"
            "; do not service this file\n"
            "; remade after each modification of obf.bin (obf.asm)\n"
            ";; last generation on %s\n\n"
            "; This below is the magic offset for things!\n"
            "; It tells enc.asm where it is being loaded in memory:\n"
            "     EncLoadedAt=0%Xh ;; NOT USER SERVICEABLE\n"
            "; End autogenerated code.\n"
            , ctime(&rt)
            , (unsigned int)(sb.st_size-1+0x100));
  return 0;
}
