/*********************************************************************/
/*        Cup Of Fungus Software File Finder V1.0 (C) 1992           */
/*********************************************************************/
/*                   Last edit 11/12/92 12:33am                      */
/*     Still needs support for drive letter as command line arg      */
/*********************************************************************/

#include <dir.h>
#include <dos.h>
#include <io.h>
#include <string.h>
#include <ctype.h>

void search_subdir(struct ffblk ffblk, unsigned long int *file_num, char *name);
void scan_dir(unsigned long int *file_num, char *name);
void fixsize(char *size_str, long num);
void fixdate(char *date_str, unsigned date);
void fixtime(char *time_str, unsigned time);
void two_col(char *str);
void fixattr(char *attr_str, char *name);
void disclaimer(void);

long int totalbytes; /* this global stinks but I'm doing it in a hurry */

void main(int argc, char *argv[])
{
	struct ffblk ffblk;
	unsigned long int numspace, *file_num;
	int length, i;
	char buffer[128], size_str[14];

	if(argc==1) {
		disclaimer();
		printf("Usage: XFIND filename\n");
		exit(1);
	}

	length = strlen(argv[1]);
	for (i=0; i<length; i++) {
		argv[1][i] = toupper(argv[1][i]);
	}
	numspace=0;
	file_num=&numspace;
	totalbytes=0;
	getcwd(buffer,128);
	chdir("\\");
	disclaimer();
	search_subdir(ffblk, file_num, argv[1]);
	fixsize(size_str, totalbytes);
	if(*file_num==0)
		printf("No Files Found\n");
	else
		printf("%lu Files Found.   %s Total Bytes.\n", *file_num, size_str);
	chdir(buffer);
}

void search_subdir(struct ffblk ffblk, unsigned long int *file_num, char *name)
{
	int done, failed;
	char dotdir[] = {'.','\0'};

	/* I think the 255 will "see" any DOS attribute because   */
	/* of the hexadecimal definitions of the attribs in dir.h */
	done=findfirst("*.*",&ffblk,255);
	/* This checks for the . and .. entries in the dir listing. */
	/* If found, they are skipped.  This is necessary because   */
	/* the root dir doesn't have these, and always skipping     */
	/* the first two entries misses the first two dirs in the   */
	/* root directory.  Thus the necessity of this check.       */
	if(strcmp(ffblk.ff_name,dotdir)==0) {
		done=findnext(&ffblk);
		done=findnext(&ffblk);
	}
	if(!done) {
		scan_dir(file_num, name);
		do {
			failed=chdir(ffblk.ff_name);
			/* If successful chdir returns 0 */
			/* so !failed means we went into */
			/* a subdirectory.               */
			if(!failed) {
				search_subdir(ffblk, file_num, name);
				chdir("..");
			}
			done=findnext(&ffblk);
		} while(!done);
	}
}

void scan_dir(unsigned long int *file_num, char *name)
{
	int unfound;
	struct ffblk filename;
	char buffer[128], size_str[14], date_str[9], time_str[10], attr_str[8];

	/* I think the 255 will "see" any DOS attribute because   */
	/* of the hexadecimal definitions of the attribs in dir.h */
	unfound=findfirst(name,&filename,255);
	if(!unfound) {
        	getcwd(buffer, 128);
		printf("%s\n", buffer);
		do {
			(*file_num)++;
			totalbytes+=filename.ff_fsize;
			fixsize(size_str, filename.ff_fsize);
			fixdate(date_str, filename.ff_fdate);
			fixtime(time_str, filename.ff_ftime);  
			fixattr(attr_str, filename.ff_name);
			printf("     %-12s  %14s  %8s  %9s  %7s\n", filename.ff_name, size_str, date_str, time_str, attr_str);
				unfound=findnext(&filename);
		} while(!unfound);
		printf("\n");
        }
}

void fixsize(char *string, long num)
{
	int i, k, l, numcom;
	char nstr[11];

	ltoa(num, nstr, 10);
	i=l=strlen(nstr);
	numcom=(int)l/3;
	if(l%3==0) numcom--;
	for(k=0;k<l+numcom;k++) string[k]=' ';
	string[l+numcom]='\0';
	i--; k=0;
	while(i>=0) {
		string[i+numcom]=nstr[i];
		k++; i--;
		if(k%3==0) {
			string[i+numcom]=',';
		     	numcom--; 
		}
	}
}

void fixdate(char *date_str, unsigned date)
{
	unsigned day, month, year, l;
	char ds[3], ms[3], ys[3];

	strcpy(date_str,"\0");
	day=(date & 31);
	month=(date & 480)>>5;
	year=((date & 65024)>>9)+80;

	itoa(day,ds,10);
	two_col(ds);
	itoa(month,ms,10);
	itoa(year,ys,10);

	strncat(date_str,ms,3);
	l=strlen(date_str);
	date_str[l]='/';
	date_str[++l]='\0';
	strncat(date_str,ds,3);
	l=strlen(date_str);
	date_str[l]='/';
	date_str[++l]='\0';
	strncat(date_str,ys,3);
}

void fixtime(char *time_str, unsigned time)
{
	unsigned seconds, minutes, hours, l;
	char ss[3], ms[3], hs[3], half;

	strcpy(time_str,"\0");
	seconds=(time & 31)*2;
	minutes=(time & 2016)>>5;
	hours=(time & 63488)>>11;

	itoa(seconds,ss,10);
	two_col(ss);
	itoa(minutes,ms,10);
	two_col(ms);
	if(hours>12) {
		half='p';
		hours-=12;
	} else if(hours==12) {
		half='p';
	} else if(hours==0) {
		half='a';
		hours=12;
	} else half='a';
	itoa(hours,hs,10);

	strncat(time_str,hs,3);
	l=strlen(time_str);
	time_str[l]=':';
	time_str[++l]='\0';
	strncat(time_str,ms,3);
	l=strlen(time_str);
	time_str[l]=':';
	time_str[++l]='\0';
	strncat(time_str,ss,3);
	l=strlen(time_str);
	time_str[l]=half;
	time_str[++l]='\0';
}

void two_col(char *str)
{
	if(strlen(str)==1) {
		str[1]=str[0];
		str[0]='0';
		str[2]='\0';
	}
}   

void fixattr(char *attr_str, char *name)
{
	int attrib, i;

	attrib=_chmod(name, 0);
	attr_str[0]='[';
	for(i=1;i<=5;i++) attr_str[i]='-';
	attr_str[6]=']';
	attr_str[7]='\0';
	attr_str[2]='W';

	if(attrib & FA_DIREC) attr_str[1]='D';  /* shows directory attrib */
	if(attrib & FA_RDONLY) attr_str[2]='R'; /* read only attrib */
	if(attrib & FA_HIDDEN) attr_str[3]='H'; /* hidden attrib */
	if(attrib & FA_SYSTEM) attr_str[4]='S'; /* system attrib */
	if(attrib & FA_ARCH) attr_str[5]='A';   /* archive attrib */
}

void disclaimer(void)
{
	printf("\nCup of Fungus Software, File Finder V1.0\n");
	printf("Copyright (C) Cup Of Fungus Software 1992\n\n");
}