/*
 * Decompiled with CFR 0.152.
 */
package sync;

import java.io.Console;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.PatternSyntaxException;
import sync.FilePair;
import sync.FileUnit;
import sync.FileUnitComparator;
import sync.FilterNode;
import sync.SyncIO;
import sync.TerminatingException;

public class Sync {
    private static final String PROGRAM_TITLE = "Sync 2.1   Copyright 2007 Zach Scrivena   2007-12-09";
    static final String TIME_FORMAT_STRING = "%1$tF %1$tT.%1$tL";
    private static boolean isWindowsOperatingSystem = false;
    private static boolean simulateOnly = false;
    private static boolean ignoreWarnings = false;
    private static String logName = null;
    static PrintWriter log = null;
    static PrintWriter stdout = null;
    static PrintWriter stderr = null;
    private static boolean noRecurse = false;
    private static SyncMode syncMode;
    private static boolean matchName;
    private static final boolean matchSize = true;
    private static boolean matchTime;
    private static boolean matchCrc;
    private static long matchTimeTolerance;
    private static String matchNstcString;
    private static FileUnitComparator matchFileUnitComparator;
    private static FileUnitComparator searchFileUnitComparator;
    private static FileUnitComparator nameOnlyFileUnitComparator;
    private static String sourceName;
    private static String targetName;
    private static File source;
    private static File target;
    private static char defaultActionOnRenameMatched;
    private static char defaultActionOnTimeSyncMatched;
    private static char defaultActionOnDeleteUnmatched;
    static char defaultActionOnOverwrite;
    private static FilterNode sourceFilter;
    private static FilterNode targetFilter;
    private static boolean filterRelativePathname;
    private static boolean filterLowerCase;
    private static int reportNumWarnings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Console console = System.console();
        if (console == null) {
            stdout = new PrintWriter(System.out);
            stderr = new PrintWriter(System.err);
        } else {
            stdout = console.writer();
            stderr = console.writer();
        }
        SyncIO.printFlush("\nSync 2.1   Copyright 2007 Zach Scrivena   2007-12-09");
        int exitCode = 0;
        try {
            isWindowsOperatingSystem = System.getProperty("os.name").toUpperCase(Locale.ENGLISH).contains("WINDOWS") && File.separatorChar == '\\';
            Sync.processArguments(args);
            SyncIO.printLog("\nSync 2.1   Copyright 2007 Zach Scrivena   2007-12-09");
            switch (syncMode) {
                case DIRECTORY: {
                    Sync.syncDirectory();
                    break;
                }
                case FILE: {
                    Sync.syncFile();
                }
            }
            SyncIO.print("\n\nSync is done!\n\n");
        }
        catch (TerminatingException e) {
            exitCode = e.getExitCode();
            if (exitCode != 0) {
                SyncIO.printToErr("\n\nERROR: " + e.getMessage() + "\n");
                SyncIO.print("\nSync aborted.\n\n");
            }
        }
        catch (Exception e) {
            SyncIO.printToErr("\n\nERROR: An unexpected error has occurred:\n" + Sync.getExceptionMessage(e) + "\n");
            exitCode = 1;
            SyncIO.print("\nSync aborted.\n\n");
        }
        finally {
            stdout.flush();
            stderr.flush();
            if (log != null) {
                log.flush();
                log.close();
                log = null;
            }
        }
        System.exit(exitCode);
    }

    private static void processArguments(String[] args) {
        String howHelp = "\nTo display help, run Sync without any command-line arguments.";
        if (args.length == 0) {
            Sync.printUsage();
            throw new TerminatingException(null, 0);
        }
        if (args.length < 2) {
            throw new TerminatingException("Insufficient arguments:\nThe source and target directories/files must be specified.\nTo display help, run Sync without any command-line arguments.");
        }
        source = new File(args[args.length - 2]);
        try {
            source = source.getCanonicalFile();
        }
        catch (Exception e) {
            throw new TerminatingException("Source \"" + source.getPath() + "\" is not a valid directory/file:\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
        }
        target = new File(args[args.length - 1]);
        try {
            target = target.getCanonicalFile();
        }
        catch (Exception e) {
            throw new TerminatingException("Target \"" + target.getPath() + "\" is not a valid directory/file:\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
        }
        if (source.isDirectory()) {
            if (target.exists() && !target.isDirectory()) {
                throw new TerminatingException("Target \"" + target.getPath() + "\" is a file.\nFor DIRECTORY synchronization, the target (if it exists) must also be a directory." + "\nTo display help, run Sync without any command-line arguments.");
            }
            syncMode = SyncMode.DIRECTORY;
            sourceName = SyncIO.trimTrailingSeparator(source.getPath()) + File.separatorChar;
            targetName = SyncIO.trimTrailingSeparator(target.getPath()) + File.separatorChar;
        } else if (source.exists()) {
            if (target.isDirectory()) {
                throw new TerminatingException("Target \"" + target.getPath() + "\" is a directory.\nFor FILE synchronization, the target (if it exists) must also be a file." + "\nTo display help, run Sync without any command-line arguments.");
            }
            syncMode = SyncMode.FILE;
            sourceName = SyncIO.trimTrailingSeparator(source.getPath());
            targetName = SyncIO.trimTrailingSeparator(target.getPath());
        } else {
            throw new TerminatingException("Source \"" + source.getPath() + "\" does not exist." + "\nTo display help, run Sync without any command-line arguments.");
        }
        ArrayList<String> includeSource = new ArrayList<String>();
        ArrayList<String> excludeSource = new ArrayList<String>();
        ArrayList<String> includeTarget = new ArrayList<String>();
        ArrayList<String> excludeTarget = new ArrayList<String>();
        boolean regexFilter = false;
        int n = args.length - 2;
        for (int i = 0; i < n; ++i) {
            String a;
            File f;
            String sw = args[i];
            if ("--simulate".equals(sw) || "-s".equals(sw)) {
                simulateOnly = true;
                ignoreWarnings = true;
                continue;
            }
            if ("--ignorewarnings".equals(sw)) {
                ignoreWarnings = true;
                continue;
            }
            if ("--log".equals(sw) || "-l".equals(sw)) {
                if (logName != null) {
                    throw new TerminatingException("Switch --log can be specified at most once.\nTo display help, run Sync without any command-line arguments.");
                }
                String timestamp = String.format("%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS", Calendar.getInstance(Locale.ENGLISH));
                f = new File("sync." + timestamp + ".log");
                if (f.exists()) {
                    for (long k = 0L; k < Long.MAX_VALUE && (f = new File("sync." + timestamp + "." + k + ".log")).exists(); ++k) {
                        f = null;
                    }
                    if (f == null) {
                        throw new TerminatingException("Failed to create an unused filename for log file:\nRan out of suffixes n in \"sync." + timestamp + ".n.log\"; try specifying a filename, e.g. --log:\"record.txt\"." + "\nTo display help, run Sync without any command-line arguments.");
                    }
                }
                try {
                    logName = f.getCanonicalPath();
                    continue;
                }
                catch (Exception e) {
                    throw new TerminatingException("Failed to create log file \"" + f.getPath() + "\":\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
                }
            }
            if (sw.startsWith("--log:") || sw.startsWith("-l:")) {
                if (logName != null) {
                    throw new TerminatingException("Switch --log can be specified at most once.\nTo display help, run Sync without any command-line arguments.");
                }
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    throw new TerminatingException("Empty --log parameter:\nA log filename must be specified, e.g. --log:\"record.txt\".\nTo display help, run Sync without any command-line arguments.");
                }
                f = new File(a);
                if (f.exists()) {
                    throw new TerminatingException("Log file \"" + f.getPath() + "\" already exists:\nA nonexistent file must be specified." + "\nTo display help, run Sync without any command-line arguments.");
                }
                try {
                    logName = f.getCanonicalPath();
                    continue;
                }
                catch (Exception e) {
                    throw new TerminatingException("Failed to create log file \"" + f.getPath() + "\":\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
                }
            }
            if ("--norecurse".equals(sw) || "-r".equals(sw)) {
                noRecurse = true;
                continue;
            }
            if ("--noname".equals(sw) || "-n".equals(sw)) {
                matchName = false;
                continue;
            }
            if ("--notime".equals(sw) || "-t".equals(sw)) {
                matchTime = false;
                continue;
            }
            if ("--nocrc".equals(sw) || "-c".equals(sw)) {
                matchCrc = false;
                continue;
            }
            if (sw.startsWith("--time:")) {
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    throw new TerminatingException("Empty --time parameter:\nTime-tolerance (in milliseconds) must be a nonnegative integer, e.g. --time:2000.\nTo display help, run Sync without any command-line arguments.");
                }
                try {
                    matchTimeTolerance = Long.parseLong(a);
                }
                catch (Exception e) {
                    matchTimeTolerance = -1L;
                }
                if (matchTimeTolerance >= 0L) continue;
                throw new TerminatingException("Invalid --time parameter \"" + a + "\":\nTime-tolerance (in milliseconds) must be a nonnegative integer, e.g. --time:2000." + "\nTo display help, run Sync without any command-line arguments.");
            }
            if (sw.startsWith("--rename:")) {
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    throw new TerminatingException("Empty --rename parameter:\nParameter must be \"y\" or \"n\", e.g. --rename:y.\nTo display help, run Sync without any command-line arguments.");
                }
                if ("y".equals(a)) {
                    defaultActionOnRenameMatched = (char)89;
                    continue;
                }
                if ("n".equals(a)) {
                    defaultActionOnRenameMatched = (char)78;
                    continue;
                }
                throw new TerminatingException("Invalid --rename parameter \"" + a + "\":\nParameter must be \"y\" or \"n\", e.g. --rename:y." + "\nTo display help, run Sync without any command-line arguments.");
            }
            if (sw.startsWith("--synctime:")) {
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    throw new TerminatingException("Empty --synctime parameter:\nParameter must be \"y\" or \"n\", e.g. --synctime:y.\nTo display help, run Sync without any command-line arguments.");
                }
                if ("y".equals(a)) {
                    defaultActionOnTimeSyncMatched = (char)89;
                    continue;
                }
                if ("n".equals(a)) {
                    defaultActionOnTimeSyncMatched = (char)78;
                    continue;
                }
                throw new TerminatingException("Invalid --synctime parameter \"" + a + "\":\nParameter must be \"y\" or \"n\", e.g. --synctime:y." + "\nTo display help, run Sync without any command-line arguments.");
            }
            if (sw.startsWith("--overwrite:")) {
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    throw new TerminatingException("Empty --overwrite parameter:\nParameter must be \"y\" or \"n\", e.g. --overwrite:y.\nTo display help, run Sync without any command-line arguments.");
                }
                if ("y".equals(a)) {
                    defaultActionOnOverwrite = (char)89;
                    continue;
                }
                if ("n".equals(a)) {
                    defaultActionOnOverwrite = (char)78;
                    continue;
                }
                throw new TerminatingException("Invalid --overwrite parameter \"" + a + "\":\nParameter must be \"y\" or \"n\", e.g. --overwrite:y." + "\nTo display help, run Sync without any command-line arguments.");
            }
            if (sw.startsWith("--delete:")) {
                if (syncMode != SyncMode.DIRECTORY) {
                    throw new TerminatingException("Switch --delete can be used for only DIRECTORY synchronization.\nTo display help, run Sync without any command-line arguments.");
                }
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    throw new TerminatingException("Empty --delete parameter:\nParameter must be \"y\" or \"n\", e.g. --delete:y.\nTo display help, run Sync without any command-line arguments.");
                }
                if ("y".equals(a)) {
                    defaultActionOnDeleteUnmatched = (char)89;
                    continue;
                }
                if ("n".equals(a)) {
                    defaultActionOnDeleteUnmatched = (char)78;
                    continue;
                }
                throw new TerminatingException("Invalid --delete parameter \"" + a + "\":\nParameter must be \"y\" or \"n\", e.g. --delete:y." + "\nTo display help, run Sync without any command-line arguments.");
            }
            if ("--force".equals(sw)) {
                defaultActionOnRenameMatched = (char)89;
                defaultActionOnTimeSyncMatched = (char)89;
                defaultActionOnOverwrite = (char)89;
                defaultActionOnDeleteUnmatched = (char)89;
                continue;
            }
            if ("--path".equals(sw) || "-p".equals(sw)) {
                if (syncMode != SyncMode.DIRECTORY) {
                    throw new TerminatingException("Switch --path can be used for only DIRECTORY synchronization.\nTo display help, run Sync without any command-line arguments.");
                }
                filterRelativePathname = true;
                continue;
            }
            if ("--lower".equals(sw) || "-w".equals(sw)) {
                if (syncMode != SyncMode.DIRECTORY) {
                    throw new TerminatingException("Switch --lower can be used for only DIRECTORY synchronization.\nTo display help, run Sync without any command-line arguments.");
                }
                filterLowerCase = true;
                continue;
            }
            if ("--regex".equals(sw)) {
                regexFilter = true;
                continue;
            }
            if (sw.startsWith("--include:") || sw.startsWith("-i:")) {
                if (syncMode != SyncMode.DIRECTORY) {
                    throw new TerminatingException("Switch --include can be used for only DIRECTORY synchronization.\nTo display help, run Sync without any command-line arguments.");
                }
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    throw new TerminatingException("Empty --include parameter:\nA GLOB (or REGEX) expression must be specified, e.g. --include:\"*.{mp3,jpg}\".\nTo display help, run Sync without any command-line arguments.");
                }
                includeSource.add(a);
                includeTarget.add(a);
                continue;
            }
            if (sw.startsWith("--exclude:") || sw.startsWith("-x:")) {
                if (syncMode != SyncMode.DIRECTORY) {
                    throw new TerminatingException("Switch --exclude can be used for only DIRECTORY synchronization.\nTo display help, run Sync without any command-line arguments.");
                }
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    throw new TerminatingException("Empty --exclude parameter:\nA GLOB (or REGEX) expression must be specified, e.g. --exclude:\"*.{mp3,jpg}\".\nTo display help, run Sync without any command-line arguments.");
                }
                excludeSource.add(a);
                excludeTarget.add(a);
                continue;
            }
            if (sw.startsWith("--includesource:") || sw.startsWith("-is:")) {
                if (syncMode != SyncMode.DIRECTORY) {
                    throw new TerminatingException("Switch --includesource can be used for only DIRECTORY synchronization.\nTo display help, run Sync without any command-line arguments.");
                }
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    throw new TerminatingException("Empty --includesource parameter:\nA GLOB (or REGEX) expression must be specified, e.g. --includesource:\"*.{mp3,jpg}\".\nTo display help, run Sync without any command-line arguments.");
                }
                includeSource.add(a);
                continue;
            }
            if (sw.startsWith("--excludesource:") || sw.startsWith("-xs:")) {
                if (syncMode != SyncMode.DIRECTORY) {
                    throw new TerminatingException("Switch --excludesource can be used for only DIRECTORY synchronization.\nTo display help, run Sync without any command-line arguments.");
                }
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    throw new TerminatingException("Empty --excludesource parameter:\nA GLOB (or REGEX) expression must be specified, e.g. --excludesource:\"*.{mp3,jpg}\".\nTo display help, run Sync without any command-line arguments.");
                }
                excludeSource.add(a);
                continue;
            }
            if (sw.startsWith("--includetarget:") || sw.startsWith("-it:")) {
                if (syncMode != SyncMode.DIRECTORY) {
                    throw new TerminatingException("Switch --includetarget can be used for only DIRECTORY synchronization.\nTo display help, run Sync without any command-line arguments.");
                }
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    throw new TerminatingException("Empty --includetarget parameter:\nA GLOB (or REGEX) expression must be specified, e.g. --includetarget:\"*.{mp3,jpg}\".\nTo display help, run Sync without any command-line arguments.");
                }
                includeTarget.add(a);
                continue;
            }
            if (sw.startsWith("--excludetarget:") || sw.startsWith("-xt:")) {
                if (syncMode != SyncMode.DIRECTORY) {
                    throw new TerminatingException("Switch --excludetarget can be used for only DIRECTORY synchronization.\nTo display help, run Sync without any command-line arguments.");
                }
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    throw new TerminatingException("Empty --excludetarget parameter:\nA GLOB (or REGEX) expression must be specified, e.g. --excludetarget:\"*.{mp3,jpg}\".\nTo display help, run Sync without any command-line arguments.");
                }
                excludeTarget.add(a);
                continue;
            }
            throw new TerminatingException("\"" + sw + "\" is not a valid switch." + "\nTo display help, run Sync without any command-line arguments.");
        }
        if (includeSource.isEmpty()) {
            if (excludeSource.isEmpty()) {
                sourceFilter = null;
            } else {
                sourceFilter = new FilterNode(FilterNode.LogicType.NOR);
                for (String s : excludeSource) {
                    try {
                        sourceFilter.addFilter(new FilterNode(regexFilter ? FilterNode.FilterType.REGEX : FilterNode.FilterType.GLOB, false, isWindowsOperatingSystem ? s.replace("/", "\\\\") : s));
                    }
                    catch (PatternSyntaxException e) {
                        throw new TerminatingException("Failed to compile the specified " + (regexFilter ? "REGEX" : "GLOB") + " expression \"" + s + "\":\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
                    }
                }
            }
        } else if (excludeSource.isEmpty()) {
            sourceFilter = new FilterNode(FilterNode.LogicType.OR);
            for (String s : includeSource) {
                try {
                    sourceFilter.addFilter(new FilterNode(regexFilter ? FilterNode.FilterType.REGEX : FilterNode.FilterType.GLOB, false, isWindowsOperatingSystem ? s.replace("/", "\\\\") : s));
                }
                catch (PatternSyntaxException e) {
                    throw new TerminatingException("Failed to compile the specified " + (regexFilter ? "REGEX" : "GLOB") + " expression \"" + s + "\":\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
                }
            }
        } else {
            FilterNode includes = new FilterNode(FilterNode.LogicType.OR);
            FilterNode excludes = new FilterNode(FilterNode.LogicType.NOR);
            for (String s : includeSource) {
                try {
                    includes.addFilter(new FilterNode(regexFilter ? FilterNode.FilterType.REGEX : FilterNode.FilterType.GLOB, false, isWindowsOperatingSystem ? s.replace("/", "\\\\") : s));
                }
                catch (PatternSyntaxException e) {
                    throw new TerminatingException("Failed to compile the specified " + (regexFilter ? "REGEX" : "GLOB") + " expression \"" + s + "\":\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
                }
            }
            for (String s : excludeSource) {
                try {
                    excludes.addFilter(new FilterNode(regexFilter ? FilterNode.FilterType.REGEX : FilterNode.FilterType.GLOB, false, isWindowsOperatingSystem ? s.replace("/", "\\\\") : s));
                }
                catch (PatternSyntaxException e) {
                    throw new TerminatingException("Failed to compile the specified " + (regexFilter ? "REGEX" : "GLOB") + " expression \"" + s + "\":\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
                }
            }
            sourceFilter = new FilterNode(FilterNode.LogicType.AND);
            sourceFilter.addFilter(includes);
            sourceFilter.addFilter(excludes);
        }
        if (includeTarget.isEmpty()) {
            if (excludeTarget.isEmpty()) {
                targetFilter = null;
            } else {
                targetFilter = new FilterNode(FilterNode.LogicType.NOR);
                for (String s : excludeTarget) {
                    try {
                        targetFilter.addFilter(new FilterNode(regexFilter ? FilterNode.FilterType.REGEX : FilterNode.FilterType.GLOB, false, isWindowsOperatingSystem ? s.replace("/", "\\\\") : s));
                    }
                    catch (PatternSyntaxException e) {
                        throw new TerminatingException("Failed to compile the specified " + (regexFilter ? "REGEX" : "GLOB") + " expression \"" + s + "\":\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
                    }
                }
            }
        } else if (excludeTarget.isEmpty()) {
            targetFilter = new FilterNode(FilterNode.LogicType.OR);
            for (String s : includeTarget) {
                try {
                    targetFilter.addFilter(new FilterNode(regexFilter ? FilterNode.FilterType.REGEX : FilterNode.FilterType.GLOB, false, isWindowsOperatingSystem ? s.replace("/", "\\\\") : s));
                }
                catch (PatternSyntaxException e) {
                    throw new TerminatingException("Failed to compile the specified " + (regexFilter ? "REGEX" : "GLOB") + " expression \"" + s + "\":\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
                }
            }
        } else {
            FilterNode includes = new FilterNode(FilterNode.LogicType.OR);
            FilterNode excludes = new FilterNode(FilterNode.LogicType.NOR);
            for (String s : includeTarget) {
                try {
                    includes.addFilter(new FilterNode(regexFilter ? FilterNode.FilterType.REGEX : FilterNode.FilterType.GLOB, false, isWindowsOperatingSystem ? s.replace("/", "\\\\") : s));
                }
                catch (PatternSyntaxException e) {
                    throw new TerminatingException("Failed to compile the specified " + (regexFilter ? "REGEX" : "GLOB") + " expression \"" + s + "\":\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
                }
            }
            for (String s : excludeTarget) {
                try {
                    excludes.addFilter(new FilterNode(regexFilter ? FilterNode.FilterType.REGEX : FilterNode.FilterType.GLOB, false, isWindowsOperatingSystem ? s.replace("/", "\\\\") : s));
                }
                catch (PatternSyntaxException e) {
                    throw new TerminatingException("Failed to compile the specified " + (regexFilter ? "REGEX" : "GLOB") + " expression \"" + s + "\":\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
                }
            }
            targetFilter = new FilterNode(FilterNode.LogicType.AND);
            targetFilter.addFilter(includes);
            targetFilter.addFilter(excludes);
        }
        if (sourceFilter == null && targetFilter == null) {
            if (filterRelativePathname) {
                throw new TerminatingException("Switch --path cannot be used when no filter is specified.\nTo display help, run Sync without any command-line arguments.");
            }
            if (filterLowerCase) {
                throw new TerminatingException("Switch --lower cannot be used when no filter is specified.\nTo display help, run Sync without any command-line arguments.");
            }
        }
        if (simulateOnly) {
            if (defaultActionOnRenameMatched != '\u0000') {
                throw new TerminatingException("Switch --rename cannot be used in simulation mode.\nTo display help, run Sync without any command-line arguments.");
            }
            if (defaultActionOnTimeSyncMatched != '\u0000') {
                throw new TerminatingException("Switch --synctime cannot be used in simulation mode.\nTo display help, run Sync without any command-line arguments.");
            }
            if (defaultActionOnOverwrite != '\u0000') {
                throw new TerminatingException("Switch --overwrite cannot be used in simulation mode.\nTo display help, run Sync without any command-line arguments.");
            }
            if (defaultActionOnDeleteUnmatched != '\u0000') {
                throw new TerminatingException("Switch --delete cannot be used in simulation mode.\nTo display help, run Sync without any command-line arguments.");
            }
            defaultActionOnRenameMatched = (char)89;
            defaultActionOnTimeSyncMatched = (char)89;
            defaultActionOnOverwrite = (char)89;
            defaultActionOnDeleteUnmatched = (char)89;
        }
        if (logName != null) {
            try {
                log = new PrintWriter(logName);
            }
            catch (Exception e) {
                throw new TerminatingException("Failed to create log file \"" + logName + "\":\n" + Sync.getExceptionMessage(e) + "\nTo display help, run Sync without any command-line arguments.");
            }
        }
        if (syncMode == SyncMode.FILE) {
            matchName = false;
        }
        matchNstcString = Sync.getNstcString(matchName, true, matchTime, matchCrc);
        matchFileUnitComparator = new FileUnitComparator(matchName, true, matchTime, matchCrc);
        searchFileUnitComparator = new FileUnitComparator(matchName, true, false, false);
        nameOnlyFileUnitComparator = new FileUnitComparator(true, false, false, false);
    }

    private static void syncDirectory() {
        StringBuilder s = new StringBuilder();
        s.append("\n\nDIRECTORY SYNCHRONIZATION");
        if (simulateOnly) {
            s.append(" (SIMULATION MODE)");
        }
        if (log != null) {
            s.append("\n\nLog file: \"" + logName + "\"");
        }
        s.append("\n\nSource directory: \"" + sourceName + "\"" + "\nTarget directory: \"" + targetName + "\"\n");
        s.append("\nFile-matching attributes: " + matchNstcString + "\n");
        if (matchTimeTolerance > 0L) {
            s.append(", with " + matchTimeTolerance + "-millisecond time-tolerance\n");
        }
        if (sourceFilter != null) {
            s.append("\nSource file/directory filter: " + sourceFilter.toString());
        }
        if (targetFilter != null) {
            s.append("\nTarget file/directory filter: " + targetFilter.toString());
        }
        if (sourceFilter != null || targetFilter != null) {
            s.append("\nFilter mode: " + (filterLowerCase ? "lower-case " : "") + (filterRelativePathname ? "relative pathname" : "filename") + "\n");
        }
        SyncIO.printFlush(s.toString());
        if (source.equals(target)) {
            throw new TerminatingException("The source directory \"" + sourceName + "\" cannot be the same as the target directory \"" + targetName + "\".");
        }
        if (sourceName.startsWith(targetName)) {
            throw new TerminatingException("The source directory \"" + sourceName + "\" cannot be a subdirectory of the target directory \"" + targetName + "\".");
        }
        if (targetName.startsWith(sourceName)) {
            throw new TerminatingException("The target directory \"" + targetName + "\" cannot be a subdirectory of the source directory \"" + sourceName + "\".");
        }
        int sourceNameLength = sourceName.length();
        int targetNameLength = targetName.length();
        int reportNumSourceDirsScanned = 0;
        int reportNumSourceFilesScanned = 0;
        int reportNumTargetFilesScanned = 0;
        int reportNumSourceFilesMatched = 0;
        int reportNumSyncTime = 0;
        int reportNumSyncTimeSuccess = 0;
        int reportNumRenameOperations = 0;
        int reportNumRenameOperationsSuccess = 0;
        int reportNumUnmatchedSourceFiles = 0;
        int reportNumUnmatchedSourceFilesCopied = 0;
        int reportNumUnmatchedTargetFilesDirs = 0;
        int reportNumUnmatchedTargetFilesDirsDeleted = 0;
        ArrayDeque<FilePair> contentStack = new ArrayDeque<FilePair>();
        ArrayDeque<FilePair> timeStack = new ArrayDeque<FilePair>();
        FilePair marker = new FilePair(null, null);
        contentStack.push(new FilePair(source, target));
        block2: while (!contentStack.isEmpty()) {
            String error;
            FilePair pair = (FilePair)contentStack.pop();
            if (pair == marker) {
                boolean success;
                FilePair timePair = (FilePair)timeStack.pop();
                File timeSourceDir = timePair.source;
                File timeTargetDir = timePair.target;
                if (!timeSourceDir.isDirectory() || !timeTargetDir.isDirectory()) continue;
                long sourceTime = timeSourceDir.lastModified();
                long targetTime = timeTargetDir.lastModified();
                boolean syncTime = false;
                if (targetTime != sourceTime) {
                    if (sourceFilter == null) {
                        syncTime = true;
                    } else {
                        String timeTargetDirName = SyncIO.trimTrailingSeparator(timeTargetDir.getPath()) + File.separatorChar;
                        String name = null;
                        if (timeTargetDirName.length() == targetNameLength) {
                            name = "";
                        } else {
                            String string = name = filterRelativePathname ? timeTargetDirName.substring(targetNameLength) : SyncIO.trimTrailingSeparator(timeTargetDir.getName()) + File.separatorChar;
                        }
                        if (filterLowerCase) {
                            name = name.toLowerCase(Locale.ENGLISH);
                        }
                        if (sourceFilter.matches(name)) {
                            syncTime = true;
                        }
                    }
                }
                if (!syncTime || simulateOnly || (success = timeTargetDir.setLastModified(sourceTime))) continue;
                Sync.reportWarning("Failed to set last-modified time of target subdirectory \"" + SyncIO.trimTrailingSeparator(timeTargetDir.getPath()) + File.separatorChar + "\":\n " + String.format(Locale.ENGLISH, TIME_FORMAT_STRING, new Date(targetTime)) + " ---> " + String.format(Locale.ENGLISH, TIME_FORMAT_STRING, new Date(sourceTime)) + ".");
                continue;
            }
            File sourceDir = pair.source;
            String sourceDirName = SyncIO.trimTrailingSeparator(sourceDir.getPath()) + File.separatorChar;
            File targetDir = pair.target;
            String targetDirName = SyncIO.trimTrailingSeparator(targetDir.getPath()) + File.separatorChar;
            String relativePathname = sourceDirName.substring(sourceNameLength);
            SyncIO.printFlush("\n\nSUBDIRECTORY: \"" + (relativePathname.isEmpty() ? "." + File.separatorChar : relativePathname) + "\"");
            if (targetDir.exists() && !targetDir.isDirectory()) {
                Sync.reportWarning("The target \"" + targetDir.getPath() + "\" already exists but is not a directory; could it be a file?\nThis subdirectory will be ignored.");
                continue;
            }
            File[] sFileList = sourceDir.listFiles();
            if (sFileList == null) {
                Sync.reportWarning("Failed to get contents of source subdirectory \"" + sourceDirName + "\".\nThis subdirectory will be ignored.");
                continue;
            }
            ArrayList<FileUnit> sFiles = new ArrayList<FileUnit>();
            ArrayList<FileUnit> sDirs = new ArrayList<FileUnit>();
            for (File f : sFileList) {
                FileUnit u = new FileUnit(f);
                if (u.isDirectory) {
                    sDirs.add(u);
                    continue;
                }
                boolean addFile = false;
                if (sourceFilter == null) {
                    addFile = true;
                } else {
                    String name;
                    String string = name = filterRelativePathname ? u.file.getPath().substring(sourceNameLength) : u.name;
                    if (filterLowerCase) {
                        name = name.toLowerCase(Locale.ENGLISH);
                    }
                    if (sourceFilter.matches(name)) {
                        addFile = true;
                    }
                }
                if (!addFile) continue;
                sFiles.add(u);
            }
            ++reportNumSourceDirsScanned;
            reportNumSourceFilesScanned += sFiles.size();
            ArrayList<FileUnit> tFiles = new ArrayList<FileUnit>();
            ArrayList<FileUnit> tDirs = new ArrayList<FileUnit>();
            if (targetDir.isDirectory()) {
                File[] tFileList = targetDir.listFiles();
                if (tFileList == null) {
                    Sync.reportWarning("Failed to get contents of target subdirectory \"" + targetDirName + "\".\nThis subdirectory will be ignored.");
                    continue;
                }
                for (File f : tFileList) {
                    FileUnit u = new FileUnit(f);
                    if (u.isDirectory) {
                        tDirs.add(u);
                        continue;
                    }
                    boolean addFile = false;
                    if (targetFilter == null) {
                        addFile = true;
                    } else {
                        String name;
                        String string = name = filterRelativePathname ? u.file.getPath().substring(targetNameLength) : u.name;
                        if (filterLowerCase) {
                            name = name.toLowerCase(Locale.ENGLISH);
                        }
                        if (targetFilter.matches(name)) {
                            addFile = true;
                        }
                    }
                    if (!addFile) continue;
                    tFiles.add(u);
                }
            } else {
                if (targetDir.exists()) {
                    Sync.reportWarning("Target \"" + targetDir.getPath() + "\" already exists but is not a directory; could it be a file?" + "\nThis subdirectory will be ignored.");
                    continue;
                }
                boolean createDir = false;
                if (sourceFilter == null) {
                    createDir = true;
                } else {
                    String name = null;
                    if (targetDirName.length() == targetNameLength) {
                        name = "";
                    } else {
                        String string = name = filterRelativePathname ? targetDirName.substring(targetNameLength) : SyncIO.trimTrailingSeparator(targetDir.getName()) + File.separatorChar;
                    }
                    if (filterLowerCase) {
                        name = name.toLowerCase(Locale.ENGLISH);
                    }
                    if (sourceFilter.matches(name)) {
                        createDir = true;
                    }
                }
                if (createDir && !simulateOnly) {
                    targetDir.mkdirs();
                    if (!targetDir.isDirectory()) {
                        Sync.reportWarning("Failed to create target subdirectory \"" + targetDirName + "\".\nThis subdirectory will be ignored.");
                        continue;
                    }
                }
            }
            reportNumTargetFilesScanned += tFiles.size();
            Collections.sort(sFiles, matchFileUnitComparator);
            FileUnit w = null;
            for (FileUnit u : sFiles) {
                if (w != null && matchFileUnitComparator.compare(u, w) == 0) {
                    Sync.reportWarning("File-matching key clash in source subdirectory \"" + sourceDirName + "\":\nThe following source files have the same " + matchNstcString + ":" + "\n [1] \"" + u.file.getPath() + "\"" + "\n [2] \"" + w.file.getPath() + "\"" + "\nThe files in this subdirectory will be ignored.");
                    timeStack.push(new FilePair(sourceDir, targetDir));
                    contentStack.push(marker);
                    if (noRecurse) continue block2;
                    for (int i = sDirs.size() - 1; i >= 0; --i) {
                        File sDir = ((FileUnit)sDirs.get((int)i)).file;
                        File tDir = new File(targetDir, sDir.getName());
                        contentStack.push(new FilePair(sDir, tDir));
                    }
                    continue block2;
                }
                w = u;
            }
            boolean uniqueMatching = Sync.performSourceTargetFileMatching(sFiles, tFiles);
            ArrayList<FileUnit> sFilesMatched = new ArrayList<FileUnit>();
            ArrayList<FileUnit> sFilesUnmatched = new ArrayList<FileUnit>();
            TreeMap<File, FileUnit> tFilesDirsUnmatched = new TreeMap<File, FileUnit>();
            for (FileUnit u : sFiles) {
                if (u.match == null) {
                    sFilesUnmatched.add(u);
                    continue;
                }
                sFilesMatched.add(u);
            }
            for (FileUnit u : tFiles) {
                if (u.match != null) continue;
                tFilesDirsUnmatched.put(u.file, u);
            }
            Sync.performSourceTargetDirMatching(sDirs, tDirs);
            for (FileUnit u : tDirs) {
                if (u.match != null) continue;
                tFilesDirsUnmatched.put(u.file, u);
            }
            int numSyncTime = 0;
            int numSyncName = 0;
            if (!sFiles.isEmpty()) {
                int numSourceFilesMatched = sFilesMatched.size();
                SyncIO.print("\n\n No. of source files matched: " + numSourceFilesMatched + " of " + sFiles.size());
                for (FileUnit u : sFilesMatched) {
                    SyncIO.print("\n [M" + ++reportNumSourceFilesMatched + ":" + (u.sameName ? "n" : " ") + (u.sameSize ? "s" : " ") + (u.sameTime ? "t" : " ") + (matchCrc ? (u.sameCrc ? "c" : " ") : "") + "] \"" + u.name + "\"" + (u.sameName ? "" : " <---> \"" + u.match.name + "\""));
                    if (!u.sameName) {
                        ++numSyncName;
                    }
                    if (u.sameTime) continue;
                    ++numSyncTime;
                }
                if (!uniqueMatching) {
                    Sync.reportWarning("Matching between files in source subdirectory \"" + sourceDirName + "\" and target subdirectory \"" + targetDirName + "\" involves arbitrarily broken ties.");
                }
            }
            if (numSyncTime > 0) {
                boolean syncTime = false;
                if (defaultActionOnTimeSyncMatched == 'Y') {
                    SyncIO.print("\n\n Synchronizing last-modified time of " + numSyncTime + " matched target " + (numSyncTime == 1 ? "file:" : "files:"));
                    syncTime = true;
                } else if (defaultActionOnTimeSyncMatched == 'N') {
                    SyncIO.print("\n\n Skipping last-modified time synchronization of " + numSyncTime + " matched target " + (numSyncTime == 1 ? "file" : "files"));
                } else if (defaultActionOnTimeSyncMatched == '\u0000') {
                    SyncIO.print("\n\n Synchronize last-modified time of " + numSyncTime + " matched target " + (numSyncTime == 1 ? "file" : "files") + "?\n");
                    char choice = SyncIO.userCharPrompt("  (Y)es/(N)o/(A)lways/Neve(R): ", "YNAR");
                    if (choice == 'Y') {
                        syncTime = true;
                    } else if (choice == 'A') {
                        defaultActionOnTimeSyncMatched = (char)89;
                        syncTime = true;
                    } else if (choice == 'R') {
                        defaultActionOnTimeSyncMatched = (char)78;
                    }
                }
                if (syncTime) {
                    for (FileUnit u : sFilesMatched) {
                        FileUnit t = u.match;
                        if (t.sameTime) continue;
                        SyncIO.printFlush("\n [T" + ++reportNumSyncTime + "] \"" + t.name + "\"\n  " + t.getTimeString() + " ---> " + u.getTimeString());
                        if (simulateOnly) continue;
                        error = SyncIO.setFileTime(t.file, u.time);
                        if (error == null) {
                            ++reportNumSyncTimeSuccess;
                            continue;
                        }
                        if (error.isEmpty()) continue;
                        Sync.reportWarning("Failed to set last-modified time of matched target file \"" + t.file.getPath() + "\":\n " + t.getTimeString() + " ---> " + u.getTimeString() + ":\n" + error);
                    }
                }
            }
            if (numSyncName > 0) {
                boolean syncName = false;
                if (defaultActionOnRenameMatched == 'Y') {
                    SyncIO.print("\n\n Renaming " + numSyncName + " matched target " + (numSyncName == 1 ? "file:" : "files:"));
                    syncName = true;
                } else if (defaultActionOnRenameMatched == 'N') {
                    SyncIO.print("\n\n Skipping renaming of " + numSyncName + " matched target " + (numSyncName == 1 ? "file" : "files"));
                } else if (defaultActionOnRenameMatched == '\u0000') {
                    SyncIO.print("\n\n Rename " + numSyncName + " matched target " + (numSyncName == 1 ? "file" : "files") + "?\n");
                    char choice = SyncIO.userCharPrompt("  (Y)es/(N)o/(A)lways/Neve(R): ", "YNAR");
                    if (choice == 'Y') {
                        syncName = true;
                    } else if (choice == 'A') {
                        defaultActionOnRenameMatched = (char)89;
                        syncName = true;
                    } else if (choice == 'R') {
                        defaultActionOnRenameMatched = (char)78;
                    }
                }
                if (syncName) {
                    ArrayList<FilePair> renamePairs = new ArrayList<FilePair>();
                    for (FileUnit u : sFilesMatched) {
                        if (u.sameName) continue;
                        renamePairs.add(new FilePair(u.match.file, new File(targetDir, u.name)));
                    }
                    List<FilePair> renameOperations = Sync.getRenameOperations(renamePairs);
                    for (FilePair p : renameOperations) {
                        SyncIO.printFlush("\n [R" + ++reportNumRenameOperations + "] \"" + p.source.getName() + "\" ---> \"" + p.target.getName() + "\"");
                        if (simulateOnly) continue;
                        String error2 = SyncIO.renameFile(p.source, p.target);
                        if (error2 == null) {
                            ++reportNumRenameOperationsSuccess;
                            tFilesDirsUnmatched.remove(p.target);
                            continue;
                        }
                        if (error2.isEmpty()) continue;
                        Sync.reportWarning("Failed to rename matched target file \"" + p.source.getPath() + "\" ---> \"" + p.target.getPath() + "\":\n" + error2);
                    }
                }
            }
            if (!sFilesUnmatched.isEmpty()) {
                int numUnmatchedSourceFiles = sFilesUnmatched.size();
                SyncIO.print("\n\n No. of unmatched source files to be copied: " + numUnmatchedSourceFiles);
                for (FileUnit u : sFilesUnmatched) {
                    SyncIO.printFlush("\n [C" + ++reportNumUnmatchedSourceFiles + "] \"" + u.name + "\" (" + u.getSizeString() + ")");
                    if (simulateOnly) continue;
                    File targetFile = new File(targetDir, u.name);
                    error = SyncIO.copyFile(u.file, targetFile);
                    if (error == null) {
                        ++reportNumUnmatchedSourceFilesCopied;
                        tFilesDirsUnmatched.remove(targetFile);
                        continue;
                    }
                    if (error.isEmpty()) continue;
                    Sync.reportWarning("Failed to copy unmatched source file \"" + u.file.getPath() + "\" ---> \"" + targetFile.getPath() + "\":\n" + error);
                }
            }
            if (!tFilesDirsUnmatched.isEmpty()) {
                int numUnmatchedTargetFilesDirs = tFilesDirsUnmatched.size();
                SyncIO.print("\n\n No. of unmatched target files/directories to be deleted: " + numUnmatchedTargetFilesDirs);
                for (boolean isDirectory : new boolean[]{false, true}) {
                    for (FileUnit u : tFilesDirsUnmatched.values()) {
                        if (u.isDirectory != isDirectory) continue;
                        SyncIO.print("\n [D" + ++reportNumUnmatchedTargetFilesDirs + "] ");
                        boolean stillExists = false;
                        if (u.file.exists() && u.file.isDirectory() == u.isDirectory) {
                            String pathname = null;
                            try {
                                pathname = u.file.getCanonicalPath();
                            }
                            catch (Exception e) {
                                pathname = null;
                            }
                            if (pathname != null && pathname.equals(u.file.getPath())) {
                                stillExists = true;
                            }
                        }
                        if (stillExists) {
                            boolean deleteFileDir = false;
                            if (defaultActionOnDeleteUnmatched == 'Y') {
                                SyncIO.printFlush("\"" + u.name + "\"");
                                deleteFileDir = true;
                            } else if (defaultActionOnDeleteUnmatched == 'N') {
                                SyncIO.printFlush("Skipping \"" + u.name + "\"");
                            } else if (defaultActionOnDeleteUnmatched == '\u0000') {
                                SyncIO.print("Delete \"" + u.name + "\"?\n");
                                char choice = SyncIO.userCharPrompt("  (Y)es/(N)o/(A)lways/Neve(R): ", "YNAR");
                                if (choice == 'Y') {
                                    deleteFileDir = true;
                                } else if (choice == 'A') {
                                    defaultActionOnDeleteUnmatched = (char)89;
                                    deleteFileDir = true;
                                } else if (choice == 'R') {
                                    defaultActionOnDeleteUnmatched = (char)78;
                                }
                            }
                            if (!deleteFileDir || simulateOnly) continue;
                            String error3 = SyncIO.deleteFileDir(u.file);
                            if (error3 == null) {
                                ++reportNumUnmatchedTargetFilesDirsDeleted;
                                continue;
                            }
                            if (error3.isEmpty()) continue;
                            Sync.reportWarning("Failed to delete unmatched target " + (u.isDirectory ? "directory" : "file") + " \"" + SyncIO.trimTrailingSeparator(u.file.getPath()) + (u.isDirectory ? Character.valueOf(File.separatorChar) : "") + "\":\n" + error3);
                            continue;
                        }
                        SyncIO.printFlush("\"" + u.name + "\" does not exist anymore");
                    }
                }
            }
            timeStack.push(new FilePair(sourceDir, targetDir));
            contentStack.push(marker);
            if (noRecurse) continue;
            for (int i = sDirs.size() - 1; i >= 0; --i) {
                File sDir = ((FileUnit)sDirs.get((int)i)).file;
                File tDir = new File(targetDir, sDir.getName());
                contentStack.push(new FilePair(sDir, tDir));
            }
        }
        StringBuilder report = new StringBuilder();
        report.append("\n\nSYNCHRONIZATION REPORT");
        if (reportNumWarnings > 0) {
            report.append("\n " + reportNumWarnings + (reportNumWarnings == 1 ? " warning" : " warnings") + " encountered.");
        }
        report.append("\n No. of source subdirectories scanned          : " + reportNumSourceDirsScanned + "\n No. of source files scanned                   : " + reportNumSourceFilesScanned + "\n No. of target files scanned                   : " + reportNumTargetFilesScanned + "\n No. of source files matched [M]               : " + reportNumSourceFilesMatched);
        if (reportNumSyncTime > 0) {
            report.append("\n No. of successful time-sync operations [T]    : " + reportNumSyncTimeSuccess + " of " + reportNumSyncTime);
        }
        if (reportNumRenameOperations > 0) {
            report.append("\n No. of successful file rename operations [R]  : " + reportNumRenameOperationsSuccess + " of " + reportNumRenameOperations);
        }
        report.append("\n No. of unmatched source files [C]             : " + reportNumUnmatchedSourceFiles + " (" + reportNumUnmatchedSourceFilesCopied + " copied)" + "\n No. of unmatched target files/directories [D] : " + reportNumUnmatchedTargetFilesDirs + " (" + reportNumUnmatchedTargetFilesDirsDeleted + " deleted)");
        SyncIO.print(report.toString());
    }

    private static void syncFile() {
        FileUnit targetFile;
        StringBuilder s = new StringBuilder();
        s.append("\n\nFILE SYNCHRONIZATION");
        if (simulateOnly) {
            s.append(" (SIMULATION MODE)");
        }
        if (log != null) {
            s.append("\n\nLog file: \"" + logName + "\"");
        }
        s.append("\n\nSource file: \"" + sourceName + "\"" + "\nTarget file: \"" + targetName + "\"\n");
        s.append("\nFile-matching attributes: " + matchNstcString);
        if (matchTimeTolerance > 0L) {
            s.append(",\n with " + matchTimeTolerance + "-millisecond time-tolerance");
        }
        SyncIO.printFlush(s.toString());
        if (source.equals(target)) {
            throw new TerminatingException("The source file \"" + sourceName + "\" cannot be the same as the target file \"" + targetName + "\".");
        }
        FileUnit sourceFile = new FileUnit(source);
        FileUnit fileUnit = targetFile = target.exists() ? new FileUnit(target) : null;
        if (targetFile == null) {
            SyncIO.printFlush("\n\nTarget file does not exist\n\nCopying \"" + source.getPath() + "\"\n  --->  \"" + target.getPath() + "\"");
            if (!simulateOnly) {
                String error = SyncIO.copyFile(source, target);
                if (error == null) {
                    SyncIO.printFlush("\n\n1 file copied.");
                } else if (!error.isEmpty()) {
                    Sync.reportWarning("Failed to copy source file \"" + source.getPath() + "\" ---> \"" + target.getPath() + "\":\n" + error);
                }
            }
        } else if (matchFileUnitComparator.compare(sourceFile, targetFile) != 0) {
            SyncIO.printFlush("\n\nSource and target files do not match\n\nCopying \"" + source.getPath() + "\"\n  --->  \"" + target.getPath() + "\"");
            if (!simulateOnly) {
                String error = SyncIO.copyFile(source, target);
                if (error == null) {
                    SyncIO.printFlush("\n\n1 file copied.");
                } else if (!error.isEmpty()) {
                    Sync.reportWarning("Failed to copy unmatched source file \"" + source.getPath() + "\" ---> \"" + target.getPath() + "\":\n" + error);
                }
            }
        } else {
            char choice;
            SyncIO.printFlush("\n\nSource and target files have the same ");
            targetFile.sameName = sourceFile.name.equals(targetFile.name);
            targetFile.sameSize = sourceFile.size == targetFile.size;
            boolean bl = targetFile.sameTime = sourceFile.time == targetFile.time;
            targetFile.sameCrc = matchCrc ? sourceFile.getCrc() == targetFile.getCrc() : false;
            SyncIO.printFlush(Sync.getNstcString(targetFile.sameName, targetFile.sameSize, targetFile.sameTime, targetFile.sameCrc));
            if (!targetFile.sameTime) {
                String error;
                boolean syncTime = false;
                if (defaultActionOnTimeSyncMatched == 'Y') {
                    SyncIO.printFlush("\n\n Synchronizing last-modified time of matched target file\n  " + targetFile.getTimeString() + " ---> " + sourceFile.getTimeString());
                    syncTime = true;
                } else if (defaultActionOnTimeSyncMatched == 'N') {
                    SyncIO.printFlush("\n\n Skipping last-modified time synchronization of matched target file");
                } else if (defaultActionOnTimeSyncMatched == '\u0000') {
                    SyncIO.print("\n\n Synchronize last-modified time of matched target file\n  " + targetFile.getTimeString() + " ---> " + sourceFile.getTimeString() + "?\n");
                    choice = SyncIO.userCharPrompt("  (Y)es/(N)o: ", "YN");
                    if (choice == 'Y') {
                        syncTime = true;
                    }
                }
                if (syncTime && !simulateOnly && (error = SyncIO.setFileTime(target, sourceFile.time)) != null && !error.isEmpty()) {
                    Sync.reportWarning("Failed to set last-modified time of matched target file \"" + target.getPath() + "\":\n " + targetFile.getTimeString() + " ---> " + sourceFile.getTimeString() + ":\n" + error);
                }
            }
            if (!targetFile.sameName) {
                File newTarget;
                String error;
                boolean syncName = false;
                if (defaultActionOnRenameMatched == 'Y') {
                    SyncIO.printFlush("\n\n Renaming matched target file\n  \"" + targetFile.name + "\" ---> \"" + sourceFile.name + "\"");
                    syncName = true;
                } else if (defaultActionOnRenameMatched == 'N') {
                    SyncIO.printFlush("\n\n Skipping renaming of matched target file");
                } else if (defaultActionOnRenameMatched == '\u0000') {
                    SyncIO.print("\n\n Rename matched target file\n  \"" + targetFile.name + "\" ---> \"" + sourceFile.name + "\"?\n");
                    choice = SyncIO.userCharPrompt("  (Y)es/(N)o: ", "YN");
                    if (choice == 'Y') {
                        syncName = true;
                    }
                }
                if (syncName && !simulateOnly && (error = SyncIO.renameFile(target, newTarget = new File(target.getParentFile(), sourceFile.name))) != null && !error.isEmpty()) {
                    Sync.reportWarning("Failed to rename matched target file \"" + target.getPath() + "\" ---> \"" + newTarget.getPath() + "\":\n" + error);
                }
            }
        }
        if (reportNumWarnings > 0) {
            SyncIO.print("\n\n" + reportNumWarnings + (reportNumWarnings == 1 ? " warning" : " warnings") + " encountered.");
        }
    }

    private static boolean performSourceTargetFileMatching(List<FileUnit> sFiles, List<FileUnit> tFiles) {
        boolean uniqueMatching = true;
        if (sFiles.isEmpty()) {
            return uniqueMatching;
        }
        Collections.sort(tFiles, searchFileUnitComparator);
        for (FileUnit s : sFiles) {
            FileUnit t;
            FileUnit t2;
            int j;
            int i = Collections.binarySearch(tFiles, s, searchFileUnitComparator);
            if (i < 0) continue;
            int matchIndex = -1;
            for (j = i - 1; j >= 0 && searchFileUnitComparator.compare(s, t2 = tFiles.get(j)) == 0; --j) {
                if (matchTime && Math.abs(s.time - t2.time) > matchTimeTolerance || matchCrc && s.getCrc() != t2.getCrc()) continue;
                if (matchIndex >= 0 || t2.match != null) {
                    uniqueMatching = false;
                    continue;
                }
                matchIndex = j;
            }
            for (j = i; j < tFiles.size() && searchFileUnitComparator.compare(s, t2 = tFiles.get(j)) == 0; ++j) {
                if (matchTime && Math.abs(s.time - t2.time) > matchTimeTolerance || matchCrc && s.getCrc() != t2.getCrc()) continue;
                if (matchIndex >= 0 || t2.match != null) {
                    uniqueMatching = false;
                    continue;
                }
                matchIndex = j;
            }
            if (matchIndex < 0) continue;
            s.match = t = tFiles.get(matchIndex);
            t.match = s;
            s.sameName = s.name.equals(t.name);
            s.sameSize = s.size == t.size;
            boolean bl = s.sameTime = s.time == t.time;
            s.sameCrc = matchCrc ? s.getCrc() == t.getCrc() : false;
            t.sameName = s.sameName;
            t.sameSize = s.sameSize;
            t.sameTime = s.sameTime;
            t.sameCrc = s.sameCrc;
        }
        return uniqueMatching;
    }

    private static void performSourceTargetDirMatching(List<FileUnit> sDirs, List<FileUnit> tDirs) {
        if (sDirs.isEmpty()) {
            return;
        }
        Collections.sort(tDirs, nameOnlyFileUnitComparator);
        for (FileUnit s : sDirs) {
            FileUnit t;
            int i = Collections.binarySearch(tDirs, s, nameOnlyFileUnitComparator);
            if (i < 0) continue;
            s.match = t = tDirs.get(i);
            t.match = s;
        }
    }

    private static List<FilePair> getRenameOperations(List<FilePair> renamePairs) {
        TreeMap<File, FilePair> targetMap = new TreeMap<File, FilePair>();
        for (FilePair p : renamePairs) {
            FilePair q = (FilePair)targetMap.get(p.target);
            if (q == null) {
                targetMap.put(p.target, p);
                continue;
            }
            throw new TerminatingException("(INTERNAL) Target filename clash:\n[1] \"" + q.source.getPath() + "\"\n  ---> \"" + q.target.getPath() + "\"\n" + "[2] \"" + p.source.getPath() + "\"\n  ---> \"" + p.target.getPath() + "\"");
        }
        TreeMap<File, LinkedList> sequenceHeads = new TreeMap<File, LinkedList>();
        TreeMap<File, LinkedList> sequenceTails = new TreeMap<File, LinkedList>();
        for (FilePair p : renamePairs) {
            LinkedList headSequence = (LinkedList)sequenceHeads.get(p.target);
            LinkedList tailSequence = (LinkedList)sequenceTails.get(p.source);
            if (headSequence == null && tailSequence == null) {
                LinkedList<FilePair> s = new LinkedList<FilePair>();
                s.add(p);
                sequenceHeads.put(p.source, s);
                sequenceTails.put(p.target, s);
                continue;
            }
            if (headSequence != null && tailSequence == null) {
                headSequence.addFirst(p);
                sequenceHeads.remove(p.target);
                sequenceHeads.put(p.source, headSequence);
                continue;
            }
            if (headSequence == null && tailSequence != null) {
                tailSequence.addLast(p);
                sequenceTails.remove(p.source);
                sequenceTails.put(p.target, tailSequence);
                continue;
            }
            if (headSequence == null || tailSequence == null) continue;
            if (headSequence == tailSequence) {
                File temp = new File(p.target.getParentFile(), p.target.getName() + ".sync");
                if (temp.exists() || targetMap.containsKey(temp)) {
                    for (long i = 0L; i < Long.MAX_VALUE && ((temp = new File(p.target.getParentFile(), p.target.getName() + ".sync." + i)).exists() || targetMap.containsKey(temp)); ++i) {
                        temp = null;
                    }
                }
                if (temp == null) {
                    throw new TerminatingException("Ran out of suffixes for temporary name of file \"" + p.target.getPath() + "\".");
                }
                targetMap.put(temp, null);
                FilePair tempTail = new FilePair(p.source, temp);
                FilePair tempHead = new FilePair(temp, p.target);
                headSequence.addFirst(tempHead);
                tailSequence.addLast(tempTail);
                sequenceHeads.remove(p.target);
                sequenceHeads.put(temp, headSequence);
                sequenceTails.remove(p.source);
                sequenceTails.put(temp, tailSequence);
                continue;
            }
            tailSequence.addLast(p);
            tailSequence.addAll(headSequence);
            sequenceHeads.remove(p.target);
            sequenceTails.remove(p.source);
            sequenceTails.put(((FilePair)tailSequence.peekLast()).target, tailSequence);
        }
        ArrayList<FilePair> renameOperations = new ArrayList<FilePair>();
        for (LinkedList s : sequenceHeads.values()) {
            Collections.reverse(s);
            renameOperations.addAll(s);
        }
        return renameOperations;
    }

    private static String getNstcString(boolean n, boolean s, boolean t, boolean c) {
        StringBuilder a = new StringBuilder();
        a.append('(');
        if (n) {
            a.append("name,");
        }
        if (s) {
            a.append("size,");
        }
        if (t) {
            a.append("time,");
        }
        if (c) {
            a.append("crc,");
        }
        a.deleteCharAt(a.length() - 1);
        a.append(')');
        return a.toString();
    }

    static void reportWarning(Object message) {
        ++reportNumWarnings;
        if (ignoreWarnings) {
            SyncIO.printToErr("\n\nWARNING: " + message + "\n");
        } else {
            SyncIO.printToErr("\n\nWARNING: " + message + "\nPress ENTER to continue...");
            new Scanner(System.in).nextLine();
        }
    }

    static String getExceptionMessage(Exception e) {
        StringBuilder s = new StringBuilder();
        s.append("\nJava exception information (" + e.getClass() + "):\n\"" + e.getMessage() + "\"");
        for (StackTraceElement t : e.getStackTrace()) {
            s.append("\n  at ");
            s.append(t.toString());
        }
        s.append('\n');
        return s.toString();
    }

    private static void printUsage() {
        SyncIO.print("\n\nSync performs one-way directory or file synchronization.\n\nUSAGE:  java -jar Sync.jar  <switches>  [\"Source\"]  [\"Target\"]\n\nSynchronize [\"Target\"] to match [\"Source\"]. Only [\"Target\"] is modified.\nBy default, the filename, size, last-modified time, and CRC-32 checksum\nare used for file-matching. The synchronization mode depends on [\"Source\"]:\n\n [\"Source\"] is a DIRECTORY: Match source and target directories recursively.\n  Matched target files are time-synced and renamed if necessary,\n  unmatched source files are copied to the target directory, and\n  unmatched target files/directories are deleted.\n\n [\"Source\"] is a FILE: Match source and target files, ignoring filename.\n  If files match, then the target file is time-synced and renamed if necessary.\n  If target file does not exist, then the source file is copied to the target.\n\n<Switches>:\n\n -s, --simulate        Simulate only; do not modify target\n     --ignorewarnings  Ignore warnings; do not pause\n -l, --log:<\"x\">       Create log file x; if x is not specified,\n                        \"sync.yyyyMMdd-HHmmss.log\" is used\n -r, --norecurse       Do not recurse into subdirectories\n\n -n, --noname          Do not use filename for file-matching\n -t, --notime          Do not use last-modified time for file-matching\n -c, --nocrc           Do not use CRC-32 checksum for file-matching\n\n     --time:[x]        Use a x-millisecond time-tolerance for file-matching\n                        (0-millisecond time-tolerance is used by default;\n                         use --time:1000 or more to avoid mismatches across\n                         different file systems)\n\n     --rename:[y|n]    Always[y]/never[n] rename matched target files\n     --synctime:[y|n]  ... synchronize time of matched target files\n     --overwrite:[y|n] ... overwrite existing target files/directories\n     --delete:[y|n]    ... delete unmatched target files/directories\n     --force           Equivalent to the combination:\n                        --rename:y --synctime:y --overwrite:y --delete:y\n\n A subset of source and/or target files/directories can be selected for\n synchronization using GLOB (or REGEX) filename filters. A file/directory is\n selected if it matches any of the \"include\" filters and none of the \"exclude\"\n filters.\n\n -i,  --include:[\"x\"]   Include source and target files/directories with names\n                         matching GLOB expression x\n -x,  --exclude:[\"x\"]   Exclude source and target files/directories with names\n                         matching GLOB expression x\n -is, --includesource:[\"x\"]   Include source files/directories ...\n -xs, --excludesource:[\"x\"]   Exclude source files/directories ...\n -it, --includetarget:[\"x\"]   Include target files/directories ...\n -xt, --excludetarget:[\"x\"]   Exclude target files/directories ...\n -p,  --path            Filter relative pathnames instead of filenames\n                         (e.g. \"work\\report\\jan.txt\" instead of \"jan.txt\")\n -w,  --lower           Use lower case names for filtering\n                         (e.g. \"HelloWorld2007.JPG\" ---> \"helloworld2007.jpg\")\n      --regex           Use REGEX instead of GLOB filename filters\n                         (see Java API for REGEX syntax)\n\n      GLOB syntax:\n       *    Match a string of 0 or more characters\n       ?    Match exactly 1 character\n      [ ]   Match exactly 1 character inside the brackets:\n             [abc]       match a, b, or c\n             [!abc]      match any character except a, b, or c (negation)\n             [a-z0-9]    match any character a through z, or 0 through 9,\n                          inclusive (range)\n      { }   Match exactly 1 comma-delimited string inside the braces:\n             {a,bc,def}  match either a, bc, or def\n\n      To use a construct symbol (e.g. [, {, ?) as a literal character,\n      insert a backslash before it, e.g. use \\[ for the literal character [.\n      Use \\\\ for the literal backslash character \\.\n      The file separator in Windows can be specified by \\\\ or /.\n\nEXAMPLES:\n\n 1. Synchronize target \"C:\\Backup\" to look like source \"C:\\Original\",\n     matching files by (name,size,time,crc):\n    java -jar Sync.jar \"C:\\Original\" \"C:\\Backup\"\n\n 2. As in example 1, but never delete unmatched target files/directories:\n    java -jar Sync.jar --delete:n \"C:\\Original\" \"C:\\Backup\"\n\n 3. As in example 1, but match files by (name,size,time) with a time-tolerance\n     of 2 seconds instead:\n    java -jar Sync.jar --nocrc --time:2000 \"C:\\Original\" \"C:\\Backup\"\n\n 4. As in example 1, but always rename and synchronize time of matched target\n     files, overwrite existing target files, and delete unmatched target\n     files/directories:\n    java -jar Sync.jar --force \"C:\\Original\" \"C:\\Backup\"\n\n 5. As in example 1, but synchronize only jpg and html files:\n    java -jar Sync.jar --include:\"*.{jpg,html}\" \"C:\\Original\" \"C:\\Backup\"\n\n 6. As in example 5, but skip files that begin with a tilde '~':\n    java -jar Sync.jar --include:\"*.{jpg,html}\" --exclude:\"~*\"\n     \"C:\\Original\" \"C:\\Backup\"\n\n");
    }

    static {
        matchName = true;
        matchTime = true;
        matchCrc = true;
        matchTimeTolerance = 0L;
        defaultActionOnRenameMatched = '\u0000';
        defaultActionOnTimeSyncMatched = '\u0000';
        defaultActionOnDeleteUnmatched = '\u0000';
        defaultActionOnOverwrite = '\u0000';
        sourceFilter = null;
        targetFilter = null;
        filterRelativePathname = false;
        filterLowerCase = false;
        reportNumWarnings = 0;
    }

    private static enum SyncMode {
        DIRECTORY,
        FILE;

    }
}

