VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmMain 
   Caption         =   "Browser"
   ClientHeight    =   10455
   ClientLeft      =   3105
   ClientTop       =   465
   ClientWidth     =   8340
   LinkTopic       =   "Form1"
   ScaleHeight     =   10455
   ScaleWidth      =   8340
   Begin VB.Frame frameDirectory 
      Caption         =   "Directory"
      Height          =   2055
      Left            =   240
      TabIndex        =   2
      Top             =   8040
      Width           =   7815
      Begin VB.CommandButton btnDeleteDirectory 
         Caption         =   "Delete directory"
         Height          =   375
         Left            =   120
         TabIndex        =   8
         Top             =   1440
         Width           =   1335
      End
      Begin VB.CommandButton btnCreateDirectory 
         Caption         =   "Create directory"
         Height          =   375
         Left            =   120
         TabIndex        =   7
         Top             =   840
         Width           =   1335
      End
      Begin VB.TextBox txtNewDirectoryName 
         Height          =   375
         Left            =   120
         TabIndex        =   6
         Top             =   360
         Width           =   7455
      End
   End
   Begin VB.Frame frameFiles 
      Caption         =   "Files"
      Height          =   1815
      Left            =   240
      TabIndex        =   1
      Top             =   6120
      Width           =   7815
      Begin VB.CommandButton btnCreateFile 
         Caption         =   "Create file"
         Height          =   375
         Left            =   120
         TabIndex        =   5
         Top             =   720
         Width           =   1215
      End
      Begin VB.CommandButton btnDeleteFile 
         Caption         =   "Delete file"
         Height          =   375
         Left            =   120
         TabIndex        =   4
         Top             =   1320
         Width           =   1215
      End
      Begin VB.TextBox txtNewFileName 
         Height          =   375
         Left            =   120
         TabIndex        =   3
         Top             =   240
         Width           =   7455
      End
   End
   Begin MSComctlLib.StatusBar sbStatusBar 
      Align           =   2  'Align Bottom
      Height          =   270
      Left            =   0
      TabIndex        =   0
      Top             =   10185
      Width           =   8340
      _ExtentX        =   14711
      _ExtentY        =   476
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   3
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   9075
            Text            =   "Status"
            TextSave        =   "Status"
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Style           =   6
            AutoSize        =   2
            TextSave        =   "2/12/2008"
         EndProperty
         BeginProperty Panel3 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Style           =   5
            AutoSize        =   2
            TextSave        =   "6:54 PM"
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.TreeView treeViewFilesFolders 
      Height          =   5055
      Left            =   240
      TabIndex        =   9
      Top             =   480
      Width           =   7815
      _ExtentX        =   13785
      _ExtentY        =   8916
      _Version        =   393217
      Style           =   7
      Appearance      =   1
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim imageTreeViewList As ImageList
Dim errCode As Integer
Private Sub RefreshTree()
    Dim drivesBuffer As Long
    Dim bufLength As Long
    Dim drive As String
    treeViewFilesFolders.Nodes.Clear
    bufLength = GetLogicalDrives()
    Dim i As Integer
    For i = 0 To 30
        Dim IsDrivePresent As Boolean
        IsDrivePresent = bufLength And (2 ^ i)
        If IsDrivePresent Then
            drive = ChrW$(65 + i) + ":\"
            treeViewFilesFolders.Nodes.Add , tvwParent, drive, drive
            FillDirectoryLevel (drive)
            FillFilesLevel (drive)
        End If
    Next
End Sub
Private Sub CheckForTrial(ByVal errCode As Integer)
    If errCode = TRIAL_LIMITED Then
        MsgBox TRIAL_LIMITED_MESSAGE, vbExclamation, ""
    End If
End Sub
Private Sub btnCreateDirectory_Click()
    Dim path As String
    path = treeViewFilesFolders.SelectedItem.Key & txtNewDirectoryName.Text
    CreateDirectoryL StrPtr(path), 0
    RefreshTree
End Sub
Private Sub btnCreateFile_Click()
    Dim path As String
    path = treeViewFilesFolders.SelectedItem.Key & txtNewFileName.Text
    CreateFileL StrPtr(path), GENERIC_WRITE, SHARE_MODE_NONE, ByVal 0&, CREATION_DISPOSITION_CREATE_ALWAYS, 0, 0
    errCode = Err.LastDllError
    CheckForTrial (errCode)
    RefreshTree
End Sub
Private Sub btnDeleteDirectory_Click()
    Dim path As String
    path = Left$(treeViewFilesFolders.SelectedItem.Key, Len(treeViewFilesFolders.SelectedItem.Key) - 1)
    Dim ex As Long
    ex = RemoveDirectoryL(StrPtr(path))
    errCode = Err.LastDllError
    CheckForTrial (errCode)
    RefreshTree
End Sub

Private Sub btnDeleteFile_Click()
    Dim res As Long
    res = DeleteFileL(StrPtr(treeViewFilesFolders.SelectedItem.Key))
    errCode = Err.LastDllError
    CheckForTrial (errCode)
    RefreshTree
End Sub

Private Sub treeViewFilesFolders_Expand(ByVal selNode As Node)
    Dim root As String
    Dim childNode As Node
    root = selNode.FullPath
    'if not drive node
    If Len(root) <> 3 Then
        treeViewFilesFolders.Nodes.Remove (selNode.Child.Key)
        FillDirectoryLevel (selNode.Key)
        FillFilesLevel (selNode.Key)
    End If
End Sub
 
Private Sub treeViewFilesFolders_Collapse(ByVal selNode As Node)
    Dim root As String
    Dim childNode As Node
    root = selNode.FullPath
    'if not drive node
    If Len(root) <> 3 Then
        Dim currNode As Node
        For i = 0 To selNode.Children - 1
            treeViewFilesFolders.Nodes.Remove (selNode.Child.Key)
        Next i
        SetChildNode selNode.Key
    End If
End Sub

Private Sub SetChildNode(ByVal path As String)
    treeViewFilesFolders.Nodes.Add path, tvwChild, path + "*", "*"
End Sub

Private Function RemoveNulls(OriginalString As String) As String
    Dim pos As Long
    pos = InStr(OriginalString, Chr$(0))
    If pos > 1 Then
        RemoveNulls = Mid$(OriginalString, 1, pos - 1)
    Else
        RemoveNulls = OriginalString
    End If
End Function


 Private Sub FillDirectoryLevel(ByVal fPath As String)
    Dim fileHandle As Long
    Dim findData As WIN32_FIND_DATA
    Dim searchPattern As String
    Dim itemKey As String
    
    searchPattern = fPath & "*"
    fileHandle = FindFirstFileL(StrPtr(searchPattern), findData)
    If findHandle <> INVALID_HANDLE_VALUE Then
        Dim found As Boolean
        found = True
        Do While found = True
            Dim currentFileName As String
            currentFileName = findData.cFileName
            currentFileName = RemoveNulls(currentFileName)
            If Left$(currentFileName, 1) <> "." And Left$(currentFileName, 2) <> ".." Then
                itemKey = fPath & currentFileName
                If findData.dwFileAttributes And vbDirectory Then
                    treeViewFilesFolders.Nodes.Add fPath, tvwChild, itemKey + "\", currentFileName
                    SetChildNode (itemKey + "\")
                End If
            End If
            found = FindNextFileL(fileHandle, findData)
        Loop
        FindCloseL (fileHandle)
    End If
End Sub

Private Sub FillFilesLevel(ByVal fPath As String)
    Dim fileHandle As Long
    Dim findData As WIN32_FIND_DATA
    Dim searchPattern As String
    Dim itemKey As String
    
    searchPattern = fPath & "*"
    fileHandle = FindFirstFileL(StrPtr(searchPattern), findData)
    
    If findHandle <> INVALID_HANDLE_VALUE Then
        Dim found As Boolean
        found = True
        Do While found = True
            Dim currentFileName As String
            currentFileName = findData.cFileName
            currentFileName = RemoveNulls(currentFileName)
            If Left$(currentFileName, 1) <> "." And Left$(currentFileName, 2) <> ".." Then
                itemKey = fPath & currentFileName
                If Not findData.dwFileAttributes And vbDirectory Then
                    treeViewFilesFolders.Nodes.Add fPath, tvwChild, itemKey, currentFileName
                End If
            End If
            found = FindNextFileL(fileHandle, findData)
        Loop
        FindCloseL (fileHandle)
    End If
End Sub

Private Sub Form_Load()
    treeViewFilesFolders.Style = tvwTreelinesPlusMinusPictureText
    treeViewFilesFolders.LineStyle = tvwRootLines
    RefreshTree
End Sub


Private Sub Form_Resize()
    treeViewFilesFolders.Width = Me.Width - 500
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Dim i As Integer
    For i = Forms.Count - 1 To 1 Step -1
        Unload Forms(i)
    Next
    If Me.WindowState <> vbMinimized Then
        SaveSetting App.Title, "Settings", "MainLeft", Me.Left
        SaveSetting App.Title, "Settings", "MainTop", Me.Top
        SaveSetting App.Title, "Settings", "MainWidth", Me.Width
        SaveSetting App.Title, "Settings", "MainHeight", Me.Height
    End If
End Sub




