using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.Win32.SafeHandles;
using System.Xml;
using System.Runtime.InteropServices;
using System.IO;

namespace SampleN
{
  public partial class BrowserForm : Form
  {
    public BrowserForm()
    {
      InitializeComponent();
      directoryTree.ImageList = imageTreeviewList;
    }
    private List<string> drives;

    public void RefreshDisplay(TreeView dirTree)
    {
      dirTree.Nodes.Clear();
      // Set the first node.
      for (int i = 0; i < drives.Count; i++)
      {
        TreeNode rootNode = new TreeNode(drives[i]);
        dirTree.Nodes.Add(rootNode);
        rootNode.ImageIndex = 0;
        rootNode.SelectedImageIndex = 1;
        // Fill the first level and expand it.
        Fill(rootNode);
      }
    }

    private void Fill(TreeNode dirNode)
    {
      //because dirNode.FullPath returns doubled slash after drive name (eg c:\\folder)
      //we should fix this
      string directory = dirNode.FullPath;
      if (directory.Length > 3)
        directory = directory.Remove(2, 1);
      foreach (string dirItem in LongFileAndDirectoryManager.GetDirectoriesList(directory))
      {
        // Add node for the directory
        TreeNode newNode = new TreeNode(dirItem.Substring(dirItem.LastIndexOf(Path.DirectorySeparatorChar) + 1));
        dirNode.Nodes.Add(newNode);
        newNode.ImageIndex = 0;
        newNode.SelectedImageIndex = 1;
        //add dummy node 
        newNode.Nodes.Add("*");
      }
      foreach (string fileItem in LongFileAndDirectoryManager.GetFiles(directory))
      {
        TreeNode newNode = new TreeNode(fileItem.Substring(fileItem.LastIndexOf(Path.DirectorySeparatorChar) + 1));
        dirNode.Nodes.Add(newNode);
        newNode.ImageIndex = 2;
        newNode.SelectedImageIndex = 2;
      }
    }

    private void btnCreateDir_Click(object sender, EventArgs e)
    {
      try
      {
        LongFileAndDirectoryManager.CreateDirectory(txbCreateDirectory.Text, IntPtr.Zero);
      }
      catch (Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }

    private void btnRemoveDir_Click(object sender, EventArgs e)
    {
      try
      {
        LongFileAndDirectoryManager.RemoveDirectory(txbRemoveDirectory.Text);
      }
      catch (Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }

    private void btnCreateFile_Click(object sender, EventArgs e)
    {
      try
      {
        SafeFileHandle fileHandle = LongFileAndDirectoryManager.CreateFile(
            txbCreateFile.Text,
            LongFileAndDirectoryManager.EFileAccess.GenericWrite,
            LongFileAndDirectoryManager.EFileShare.None,
            IntPtr.Zero,
            LongFileAndDirectoryManager.ECreationDisposition.CreateAlways,
            0,
            IntPtr.Zero);
      }
      catch (Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }

    private void btnDeleteFile_Click(object sender, EventArgs e)
    {
      try
      {
        LongFileAndDirectoryManager.DeleteFile(txbDeleteFile.Text);
      }
      catch (Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }

    private void btnMoveFile_Click(object sender, EventArgs e)
    {
      try
      {
        LongFileAndDirectoryManager.MoveFile(txbMoveFrom.Text, txbMoveTo.Text);
      }
      catch (Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }

    private void btnCopyFile_Click(object sender, EventArgs e)
    {
      try
      {
        LongFileAndDirectoryManager.CopyFile(txbCopyFrom.Text, txbCopyTo.Text, false);
      }
      catch (Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }

    private void formTestingBrowser_Load(object sender, EventArgs e)
    {
      drives = new List<string>(Environment.GetLogicalDrives());
      RefreshDisplay(directoryTree);
    }

    private void btnRemoveDirBase_Click(object sender, EventArgs e)
    {
      try
      {
        LongFileAndDirectoryManager.RemoveDirectory(directoryTree.SelectedNode.FullPath);
      }
      catch (Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
    }

    private void btnRefresh_Click(object sender, EventArgs e)
    {
      RefreshDisplay(directoryTree);
    }

    private void btnBaseCreateDir_Click(object sender, EventArgs e)
    {
      string dirName = (directoryTree.SelectedNode.FullPath).Remove(2, 1) + Path.DirectorySeparatorChar + txbNewDirName.Text;
      try
      {
        if (!LongFileAndDirectoryManager.DirectoryExists(dirName))
        {
          LongFileAndDirectoryManager.CreateDirectory(dirName, IntPtr.Zero);
        }
      }
      catch (Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
      RefreshDisplay(directoryTree);
      txbNewDirName.Text = "";
    }

    private void btnBaseRemoveDir_Click(object sender, EventArgs e)
    {
      string fullPath = (directoryTree.SelectedNode.FullPath).Remove(2, 1);
      try
      {
        bool removed = LongFileAndDirectoryManager.RemoveDirectory(fullPath);
      }
      catch (Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
      RefreshDisplay(directoryTree);
    }



    private void directoryTree_BeforeExpand(object sender, TreeViewCancelEventArgs e)
    {
      // If a dummy node is found, remove it and read the real directory list.
      if (e.Node.ImageIndex == 0)
      {
        e.Node.ImageIndex = 1;
      }
      if (e.Node.Nodes[0].Text == "*")
      {
        e.Node.Nodes.Clear();
        Fill(e.Node);
      }
    }

    private void btnBaseCreateFile_Click(object sender, EventArgs e)
    {
      string fileName = (directoryTree.SelectedNode.FullPath).Remove(2, 1) + Path.DirectorySeparatorChar + txbNewFileName.Text;
      try
      {
        SafeFileHandle safeFileHandle = LongFileAndDirectoryManager.CreateFile(fileName, LongFileAndDirectoryManager.EFileAccess.GenericWrite, LongFileAndDirectoryManager.EFileShare.None, IntPtr.Zero, LongFileAndDirectoryManager.ECreationDisposition.CreateAlways, 0, IntPtr.Zero);
      }
      catch (Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
      RefreshDisplay(directoryTree);
      txbNewFileName.Text = "";
    }

    private void btnBaseDeleteFile_Click(object sender, EventArgs e)
    {
      string fullPath = (directoryTree.SelectedNode.FullPath).Remove(2, 1);
      try
      {
        LongFileAndDirectoryManager.DeleteFile(fullPath);
      }
      catch (Exception ex)
      {
        MessageBox.Show(ex.Message);
      }
      RefreshDisplay(directoryTree);
    }

    private void directoryTree_BeforeCollapse(object sender, TreeViewCancelEventArgs e)
    {
      e.Node.ImageIndex = 0;
    }
  }
}