;**************************************************************************
; STANDARD INCLUDE FILE FOR MASM 5.1 MODULES LINKED WITH 'C' PROGRAMS
;  defines common equates
;**************************************************************************
IF1

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

;------ Define external procedures/variables macros -----

IMPORT  macro   typ, list
ifdifi  <typ>,<PTRS>
        irp     x,<list>
        extrn   x:typ
        endm
endif
ifidni  <typ>,<PTRS>
  if @DataSize
        irp     x,<list>
        extrn   x:DWORD
        endm
  else
        irp     x,<list>
        extrn   x:WORD
        endm
  endif
endif
        endm

GLOBE   macro   typ, list
ifidni      <typ>,<BYTE>
        irp     x,<list>
  x     LABEL   typ
        public  x
        db      0
        endm
elseifidni  <typ>,<WORD>
        irp     x,<list>
  x     LABEL   typ
        public  x
        dw      0
        endm
else
        irp     x,<list>
  x     LABEL   typ
        public  x
        endm
endif
        endm

;------- Mixed memory model macros ----------------------
;  Compatible with MicroSoft's MIXED.INC macros except
; this ifFP works with multiple operand instructions.
; Also an ifNP (if Near Pointers) macro is added.
IF @DataSize                ;FAR DATA MODEL
    FP      EQU     <es:>
    ifFP    MACRO   a,b,c,d,e
            IFNB <c>
        a b,c d e
            ELSE
        a b
            ENDIF
            ENDM
    ifNP    MACRO   a,b,c,d,e
            ENDM
    pLes    MACRO   a,b
        les     a,b
            ENDM
    pLds    MACRO   a,b
        lds     a,b
            ENDM
ELSE                        ;NEAR DATA MODEL
    FP      EQU     <>
    ifFP    MACRO   a,b,c,d,e
            ENDM
    ifNP    MACRO   a,b,c,d,e
            IFNB <c>
        a b,c d e
            ELSE
        a b
            ENDIF
            ENDM
    pLes    MACRO   a,b
        mov     a,b
            ENDM
    pLds    MACRO   a,b
        mov     a,b
            ENDM
ENDIF

;--- Macro to fix problem with naming the code segment --
_CODE   MACRO   textname
IF @CodeSize
        ASSUME cs:textname
        .CODE   textname
ELSE
        .CODE
ENDIF
        ENDM

;------- Procedure macros -------------------------------
publicproc      macro   pname
        public  pname
if @CodeSize
pname           LABEL   far
else
pname           LABEL   near
endif
        endm

localproc       macro   pname
pname           LABEL   near
        endm

locpubproc      macro   pname
        public  pname
pname           LABEL   near
        endm

calln           macro   tname
        call    NEAR PTR tname
        endm

callf           macro tname
        call    FAR PTR tname
        endm

if @CodeSize
 BOFST  =       6
else
 BOFST  =       4
endif

;------- Useful equates -------------------------------
s       equ     <short>
n       equ     <not>
ofst    equ     <offset>
bptr    equ     <Byte Ptr>
wptr    equ     <Word Ptr>
bbp     equ     <Byte Ptr [BP]>
wbp     equ     <Word Ptr [BP]>
bbx     equ     <Byte Ptr [BX]>
wbx     equ     <Word Ptr [BX]>
bsi     equ     <Byte Ptr [SI]>
wsi     equ     <Word Ptr [SI]>
bdi     equ     <Byte Ptr [DI]>
wdi     equ     <Word Ptr [DI]>
bDG     equ     <Byte Ptr DGROUP>
wDG     equ     <Word Ptr DGROUP>
ofDG    equ     <offset DGROUP>
DG      equ     <DGROUP>
ENDIF
