

title 32 BIT CRC FUNCTION
page 75,132

; Mike Dumdei, 6 Holly Lane, Texarkana TX  75503

comment |======================================================================

NO TABLE VERSION.

ulong blk32crc(ulong *CrcIn, char *blk, int count);   /* block at a time */
ulong upd32crc(ulong *CrcIn, char databyte);          /* byte at a time */

Both functions update the pointed to CRC value and return it as the
return value of the function.  If 'blk32crc' is passed a NULL pointer
for the pointer to CRC value, the CRC is calculated using 0xFFFFFFFF
as the initial CRC value, the return value is the resulting CRC, and
the CRC is not stored at the pointer location.

These functions calculate a 32 bit CRC using the polynomial:

   X^32+X^26+X^23+X^22+X^16+X^12+X^11+X^10+X^8+X^7+X^5+X^4+X^2+X^1+X^0
     1 0000 0100 1100 0001 0001 1101 1011 0111        1 04C11DB7
 or    1110 1101 1011 1000 1000 0011 0010 0000 1        EDB88320 1 (reversed)

Since the function is intended for use with UARTs which transmit the LSB
of each byte as the first bit sent, the LSB is treated as the MSB when
calculating the CRC.  This conforms with the method used by Zmodem.  To
convert the function to work under the assumption the MSB is to be the
high order bit, change the shift and rotate instructions to move left and
un-reverse the polynomial values (use 04C11DB7).

==============================================================================|
IFNDEF  model
        .MODEL  small, c
ELSE
  %     .MODEL  model, c
ENDIF
        include         casm.inc

        .CODE

;---- Block CRC function ----
blk32crc PROC USES si di, CRCin:PTR, Block:PTR BYTE, BlkSz
 ifFP   push    ds              ;save DS if far data
        pLds    si,CRCin        ;DS:SI is pointer to initial CRC value
ifNP    xor     ax,ax
ifFP    mov     ax,ds
        or      ax,si           ;test for NULL pointer
        jz      useFFFFFFFF     ;use 0xFFFFFFFF as initial value if NULL ptr
        mov     ax,[si]
        mov     dx,[si+2]       ;else get beginning CRC value
        jmp s   getBlkPtr
useFFFFFFFF:
        dec     ax
        mov     dx,ax
getBlkPtr:
        pLds    si,Block        ;DS:SI = pointer to block
        mov     di,BlkSz        ;DI = nbr bytes in the block
        or      di,di
        jz      done            ;done if block count was zero
        push    bp
        mov     bp,di           ;else save BP & set BP = block size
        xor     ch,ch
        mov     di,0edb8h       ; for MSB crc use:   mov di,04c1h
        mov     bx,8320h        ;                    mov bx,1db7h
byte_loop:
        xor     al,[si]
        inc     si
        mov     cl,8
bit_loop:
        shr     dx,1            ; for MSB crc use:   shl ax,1
        rcr     ax,1            ;                    rcl dx,1
        jnc     lp_contin
        xor     dx,di
        xor     ax,bx
lp_contin:
        loop    bit_loop
        dec     bp
        jnz     byte_loop       ;calculate the CRC value
        pop     bp              ;restore BP
        pLds    si,CRCin
 ifFP   mov     cx,ds
 ifFP   or      cx,si
 ifNP   mov     cx,si
        jcxz    done            ;don't store CRC if had a NULL ptr
        mov     [si],ax
        mov     [si+2],dx       ;else store updated CRC value
done:
 ifFP   pop     ds              ;restore DS if far data pointers
        ret                     ;back to caller with CRC still in DX:AX
blk32crc ENDP
        
;---- Byte CRC function ----
upd32crc PROC USES di si, CRCin:PTR, DataByte:BYTE
ifFP    push    ds
        pLds    si,CRCin
        mov     ax,[si]
        mov     dx,[si+2]       ;get passed CRC to be updated
        xor     al,DataByte     ;get byte to add to passed CRC
        mov     cx,8            ;looping for 8 bits in a byte
        mov     di,0edb8h       ; for MSB crc use:   mov di,04c1h
        mov     bx,8320h        ;                    mov bx,1db7h
updt_loop:
        shr     dx,1            ; for MSB crc use:   shl ax,1
        rcr     ax,1            ;                    rcl dx,1
        jnc     updt_contin
        xor     dx,di
        xor     ax,bx
updt_contin:
        loop    updt_loop       ;update the CRC
        mov     [si],ax
        mov     [si+2],dx       ;store updated CRC value
 ifFP   pop     ds
        ret                     ;back to caller with CRC still in DX:AX
upd32crc ENDP

        END

