
title FAST 32 BIT CRC FOR MSC OR TURBO C
page 75,132

; Mike Dumdei, 6 Holly Lane, Texarkana TX  75503

comment |====================================================================

LOOKUP TABLE VERSION.

Fast 32 bit CRC functions.  UpdCrc32 is for byte at a time CRCs.  BlkCrc32
calculates a CRC for an entire block.  BlkCrc32 pre-initializes the CRC to
0xFFFFFFFF.  UpdBlkCrc32 also is a block CRC function but it takes a 3rd
argument which is the beginning CRC.  It can be used if you don't want the
CRC initialized to 0xFFFFFFFF or if you are running an ongoing CRC that
processes blocks at a time.

  unsigned long UpdCrc32(char byte, unsigned long crc);
  unsigned long BlkCrc32(char *block, unsigned count);
  unsigned long UpdBlkCrc32(char *block, unsigned count, unsigned long crc);

These functions calculate a 32 bit CRC using the polynomial:

   X^32+X^26+X^23+X^22+X^16+X^12+X^11+X^10+X^8+X^7+X^5+X^4+X^2+X^1+X^0
     1 0000 0100 1100 0001 0001 1101 1011 0111        1 04C11DB7
 or    1110 1101 1011 1000 1000 0011 0010 0000 1        EDB88320 1 (reversed)

Since the function is intended for use with UARTs which transmit the LSB
of each byte as the first bit sent, the LSB is treated as the MSB when
calculating the CRC.  This conforms with the method used by Zmodem.  For
generating high bit first CRCs see the non-table driven version.

=============================================================================|
IFNDEF model
        .MODEL  small, C
ELSE
 %      .MODEL  model, C
ENDIF

        INCLUDE casm.inc

        .CODE

UpdCrc32 PROC, Char:BYTE, Crc32:BYTE  ; 4 crc BYTEs make a DWORD
        xor     bh,bh
        mov     bl,Char
        xor     bl,Crc32[0]     ;BX ==  [(int)c ^ b & 0xff]
        shl     bx,1
        shl     bx,1            ;shift for DWORD index into crc table
IF2
%OUT
%OUT **** IGNORE THE '32CRC.ASM(54): Operands types must match' WARNING
ENDIF
        mov     ax,WPTR Crc32[1] ;--- THIS LINE CAUSES A WARNING, IGNORE IT
        mov     dl,Crc32[3]
        xor     dh,dh           ;DX:AX ==  ((c >> 8) & 0x00FFFFFF)
        xor     ax,WPTR crc32tbl[bx]
        xor     dx,WPTR crc32tbl[bx+2]  ;DX:AX == updated CRC
        ret
UpdCrc32 ENDP

BlkCrc32 PROC USES si di, Block:PTR, Count
 ifFP   push    ds
        pLds    si,Block        ;DS:SI = pointer to data block
        mov     cx,-1
        mov     dx,cx           ;CX:DX = initialized CRC == 0xffffffff
        mov     di,Count        ;get number of bytes to calc CRC on
        or      di,di
        jz      done            ;exit if 0 bytes
        cld
        xor     ah,ah
blkloop:
        lodsb
        mov     bx,ax
        xor     bl,cl           ;BX ==  [(int)c ^ b & 0xff]
        shl     bx,1
        shl     bx,1            ;shift for DWORD index into crc table
        mov     cl,ch
        mov     ch,dl
        mov     dl,dh
        mov     dh,ah           ;DX:CX ==  ((c >> 8) & 0x00FFFFFF)
        xor     cx,WPTR crc32tbl[bx]
        xor     dx,WPTR crc32tbl[bx+2]  ;DX:CX == updated CRC
        dec     di
        jnz     blkloop         ;loop till block is finished
done:
        mov     ax,cx           ;DX:AX = final CRC value
 ifFP   pop     ds
        ret                     ;back to caller
BlkCrc32 ENDP

UpdBlkCrc32 PROC USES si di, Block:PTR, Count, Crc32
 ifFP   push    ds
        pLds    si,Block        ;DS:SI = pointer to data block
        mov     cx,WPTR Crc32
        mov     dx,WPTR Crc32[2] ;CX:DX = passed CRC
        mov     di,Count        ;get number of bytes to calc CRC on
        or      di,di
        jz      done            ;exit if 0 bytes
        cld
        xor     ah,ah
blkloop:
        lodsb
        mov     bx,ax
        xor     bl,cl           ;BX ==  [(int)c ^ b & 0xff]
        shl     bx,1
        shl     bx,1            ;shift for DWORD index into crc table
        mov     cl,ch
        mov     ch,dl
        mov     dl,dh
        mov     dh,ah           ;DX:CX ==  ((c >> 8) & 0x00FFFFFF)
        xor     cx,WPTR crc32tbl[bx]
        xor     dx,WPTR crc32tbl[bx+2]  ;DX:CX == updated CRC
        dec     di
        jnz     blkloop         ;loop till block is finished
done:
        mov     ax,cx           ;DX:AX = final CRC value
 ifFP   pop     ds
        ret                     ;back to caller
UpdBlkCrc32 ENDP


        .DATA

crc32tbl LABEL DWORD
        
  DD    000000000h, 077073096h, 0EE0E612Ch, 0990951BAh, 0076DC419h, 0706AF48Fh
  DD    0E963A535h, 09E6495A3h, 00EDB8832h, 079DCB8A4h, 0E0D5E91Eh, 097D2D988h
  DD    009B64C2Bh, 07EB17CBDh, 0E7B82D07h, 090BF1D91h, 01DB71064h, 06AB020F2h
  DD    0F3B97148h, 084BE41DEh, 01ADAD47Dh, 06DDDE4EBh, 0F4D4B551h, 083D385C7h
  DD    0136C9856h, 0646BA8C0h, 0FD62F97Ah, 08A65C9ECh, 014015C4Fh, 063066CD9h
  DD    0FA0F3D63h, 08D080DF5h, 03B6E20C8h, 04C69105Eh, 0D56041E4h, 0A2677172h
  DD    03C03E4D1h, 04B04D447h, 0D20D85FDh, 0A50AB56Bh, 035B5A8FAh, 042B2986Ch
  DD    0DBBBC9D6h, 0ACBCF940h, 032D86CE3h, 045DF5C75h, 0DCD60DCFh, 0ABD13D59h
  DD    026D930ACh, 051DE003Ah, 0C8D75180h, 0BFD06116h, 021B4F4B5h, 056B3C423h
  DD    0CFBA9599h, 0B8BDA50Fh, 02802B89Eh, 05F058808h, 0C60CD9B2h, 0B10BE924h
  DD    02F6F7C87h, 058684C11h, 0C1611DABh, 0B6662D3Dh, 076DC4190h, 001DB7106h
  DD    098D220BCh, 0EFD5102Ah, 071B18589h, 006B6B51Fh, 09FBFE4A5h, 0E8B8D433h
  DD    07807C9A2h, 00F00F934h, 09609A88Eh, 0E10E9818h, 07F6A0DBBh, 0086D3D2Dh
  DD    091646C97h, 0E6635C01h, 06B6B51F4h, 01C6C6162h, 0856530D8h, 0F262004Eh
  DD    06C0695EDh, 01B01A57Bh, 08208F4C1h, 0F50FC457h, 065B0D9C6h, 012B7E950h
  DD    08BBEB8EAh, 0FCB9887Ch, 062DD1DDFh, 015DA2D49h, 08CD37CF3h, 0FBD44C65h
  DD    04DB26158h, 03AB551CEh, 0A3BC0074h, 0D4BB30E2h, 04ADFA541h, 03DD895D7h
  DD    0A4D1C46Dh, 0D3D6F4FBh, 04369E96Ah, 0346ED9FCh, 0AD678846h, 0DA60B8D0h
  DD    044042D73h, 033031DE5h, 0AA0A4C5Fh, 0DD0D7CC9h, 05005713Ch, 0270241AAh
  DD    0BE0B1010h, 0C90C2086h, 05768B525h, 0206F85B3h, 0B966D409h, 0CE61E49Fh
  DD    05EDEF90Eh, 029D9C998h, 0B0D09822h, 0C7D7A8B4h, 059B33D17h, 02EB40D81h
  DD    0B7BD5C3Bh, 0C0BA6CADh, 0EDB88320h, 09ABFB3B6h, 003B6E20Ch, 074B1D29Ah
  DD    0EAD54739h, 09DD277AFh, 004DB2615h, 073DC1683h, 0E3630B12h, 094643B84h
  DD    00D6D6A3Eh, 07A6A5AA8h, 0E40ECF0Bh, 09309FF9Dh, 00A00AE27h, 07D079EB1h
  DD    0F00F9344h, 08708A3D2h, 01E01F268h, 06906C2FEh, 0F762575Dh, 0806567CBh
  DD    0196C3671h, 06E6B06E7h, 0FED41B76h, 089D32BE0h, 010DA7A5Ah, 067DD4ACCh
  DD    0F9B9DF6Fh, 08EBEEFF9h, 017B7BE43h, 060B08ED5h, 0D6D6A3E8h, 0A1D1937Eh
  DD    038D8C2C4h, 04FDFF252h, 0D1BB67F1h, 0A6BC5767h, 03FB506DDh, 048B2364Bh
  DD    0D80D2BDAh, 0AF0A1B4Ch, 036034AF6h, 041047A60h, 0DF60EFC3h, 0A867DF55h
  DD    0316E8EEFh, 04669BE79h, 0CB61B38Ch, 0BC66831Ah, 0256FD2A0h, 05268E236h
  DD    0CC0C7795h, 0BB0B4703h, 0220216B9h, 05505262Fh, 0C5BA3BBEh, 0B2BD0B28h
  DD    02BB45A92h, 05CB36A04h, 0C2D7FFA7h, 0B5D0CF31h, 02CD99E8Bh, 05BDEAE1Dh
  DD    09B64C2B0h, 0EC63F226h, 0756AA39Ch, 0026D930Ah, 09C0906A9h, 0EB0E363Fh
  DD    072076785h, 005005713h, 095BF4A82h, 0E2B87A14h, 07BB12BAEh, 00CB61B38h
  DD    092D28E9Bh, 0E5D5BE0Dh, 07CDCEFB7h, 00BDBDF21h, 086D3D2D4h, 0F1D4E242h
  DD    068DDB3F8h, 01FDA836Eh, 081BE16CDh, 0F6B9265Bh, 06FB077E1h, 018B74777h
  DD    088085AE6h, 0FF0F6A70h, 066063BCAh, 011010B5Ch, 08F659EFFh, 0F862AE69h
  DD    0616BFFD3h, 0166CCF45h, 0A00AE278h, 0D70DD2EEh, 04E048354h, 03903B3C2h
  DD    0A7672661h, 0D06016F7h, 04969474Dh, 03E6E77DBh, 0AED16A4Ah, 0D9D65ADCh
  DD    040DF0B66h, 037D83BF0h, 0A9BCAE53h, 0DEBB9EC5h, 047B2CF7Fh, 030B5FFE9h
  DD    0BDBDF21Ch, 0CABAC28Ah, 053B39330h, 024B4A3A6h, 0BAD03605h, 0CDD70693h
  DD    054DE5729h, 023D967BFh, 0B3667A2Eh, 0C4614AB8h, 05D681B02h, 02A6F2B94h
  DD    0B40BBE37h, 0C30C8EA1h, 05A05DF1Bh, 02D02EF8Dh

        END

