/*
    Filename: C:\DAVE\CPP\IO\filepath.cpp
    Author  : Dave Nelson
    Created : Fri 04-Dec-1998 19:15:21
    Modified: Mon 22-Mar-1999 19:27:35 - Dave Nelson
*/

#include <string.h>
#include <ctype.h>
#include <filepath.hpp>

filepath& filepath::operator=(char *f){
filepath tmp = f;
    return operator=(tmp);
    }

filepath& filepath::operator=(filepath& fp){
    if(p) delete p;
    if(fp.p){
        p = new char[strlen(fp.p)+1];
        strcpy(p, fp.p);
        }
    else p = NULL;
    d = fp.d;
    memcpy(b,fp.b,sizeof(b));
    memcpy(e,fp.e,sizeof(e));
    return *this;
    }

filepath::filepath(filepath& fp){
    operator=(fp);
    }

char filepath::drive(){                 // this is not inline so ctype.h
    return toupper(d);                  // need be included only here.
    }

char * filepath::setbase(char *bs){     // setbase, setext, and setpath are
    return (strncpy(b,bs,sizeof(b)));   // not inline so string.h need be
    }                                   // included only here.

char * filepath::setext(char *ex){
    if(ex==NULL){
        *ex = 0;
        return ex;
        }
    else return (strncpy(e,ex,sizeof(e)));
    }

char * filepath::setpath(char *pt){
    if(p) delete p;
    int l = strlen(pt);
    p = new char[l+1];
    strcpy(p,pt);
    if(p[l-1]=='\\' && l>1) p[l-1]=0;
    return p;
    }

char * filepath::namext(){              // filename.ext
    if(!w) w = new char[128];
    strcpy(w, b);
    strcat(w, e);
    return w;
    }

char * filepath::full(){                // d:\path\filename.ext
char *cp = location();
    if(p && strlen(p)>1) strcat(cp, "\\");
    strcat(cp, b);
    strcat(cp, e);
    return w;
    }

char * filepath::location(){            // d:\path
    if(!w) w = new char[128];
    char *cp = w;
    if(d) {
        *cp++ = d;
        *cp++ = ':';
        }
    *cp = 0;
    if(p) strcat(cp, p);
    return w;
    }

filepath::filepath(char *fn){
char wkbuf[128];
    if(fn==NULL) {
        w = p = NULL;
        d = *b = *e = 0;
        }
    else {
        strcpy(wkbuf,fn);
        char *cp = wkbuf, *c2;
        d = 0;
        if(*(cp+1)==':'){
            cp += 2;
            d = *wkbuf;
            }

        w = p = NULL;
        if((c2=strrchr(cp, '\\'))!=NULL){   // got path information?
            if(c2==cp){                     // root directory?
                p = new char[2];
                *p = *cp;
                *(p+1) = 0;
                }
            else {                          // if more than just root, truncate
                *c2 = 0;                    // the final backslash.
                p = new char[strlen(cp)+1];
                strcpy(p, cp);
                }
            cp = c2+1;                      // point cp to the rest of the name.
            }

        strcpy(e,".");                      // e == a dot and a zero.
        if((c2=strchr(cp, '.'))!=NULL){     // got an extension?
            *c2 = 0;                        // truncate the basename in cp
            memcpy(e+1, c2+1, 3);           // use memcpy to avoid trouble
            e[4] = 0;                       // make sure it's terminated
            }
        memcpy(b, cp, 8);
        b[8] = 0;
        }
    }

filepath::~filepath(){
    if(w) delete w;
    if(p) delete p;
    }

#if 0
#include <stdio.h>

void main(int argc, char **argv){
filepath f;
    for(int i=0; i<argc; i++){
        f = argv[i];
        printf("\nDrive:\t\t%c:",  f.drive());          // A, B, C, etc.
        printf("\nPath:\t\t%s",    f.path());           // \path
        printf("\nLocation:\t%s",  f.location());       // d:\path
        printf("\nBase:\t\t%s",    f.base());           // filename
        printf("\nExtension:\t%s", f.ext());            // .ext
        printf("\nName/Ext:\t%s",  f.namext());         // filename.ext
        printf("\nFull:\t\t%s",    f.full());           // d:\path\filename.ext
        }
    }
#endif
