/*
**	RM - remove files
*/

#include    <stdio.h>
#include    <errno.h>
#include    "formatch.h"
#include    "option.h"
#include    "ascii.h"
#include    "askreply.h"

char copyright[] =
"(c) 1988,89,90,91 by Otto Makela, Jyvaskyla, Finland\r\n"
"Distributed under the GNU General Licence -- see file COPYING for details\r\n"
"Call JyBox +358 41 211 562, V.32bis/HST/V.42/V.42bis, 24h/day\r\n";

#define OPTMASK     (OPTIONA|OPTIONF|OPTIONI|OPTIONQ|OPTIONR)

#define ATTRIBUTE   (DOTHIDDEN)
#define DIRECTORYS  (DIRECTORY|RECURSIVE)
#define SAFEATTR    (READONLY|SYSTEM|HIDDEN)

int rm();
OPTION optset=0L;

int readchar();
char *progname,*getenv();

main(argc,argv)
int argc;
char *argv[];   {
    register int loop;
    int i,matches=0;
    char *p;

    progname="rm";

    if((p=getenv("RMFLAGS")) && ((optset=option(p,OPTMASK,NULL))&OPTERR))
        fprintf(stderr,
	    "%s: unknown option %s in environment variable RMFLAGS\n",
	    progname,p);

        /* If stdin is redirected, fake a stdin argument just in case */
    if(!isatty(fileno(stdin))) argv[argc++]="-";

    initmatch();
    for(loop=1; loop<argc; loop++)
        if(argv[loop][0]==*optsepar && argv[loop][1])	{
	    if((optset^=option(++argv[loop],OPTMASK,NULL))&OPTERR)  {
		fprintf(stderr,"%s: unknown option %s\n",
		    progname,argv[loop]);
		goto usage;
	    }
        } else if(argv[loop][0]=='-' && !argv[loop][1])	{
	    char filename[BUFSIZ];
	    while(scanf("%s",filename)==1)
		if(!(i=formatch(filename, SAFEATTR |
		    ((optset&OPTIONR)?DIRECTORYS:0), rm)))	{
		    if(!(optset&OPTIONF))
			fprintf(stderr,"%s: no match for %s\n",
				progname,filename);
		} else if(i>0)
		    matches+=i;
		else
		    goto exit;
        } else	{
            if(!(i=formatch(argv[loop], SAFEATTR |
                ((optset&OPTIONR)?DIRECTORYS:0), rm)))	{
                if(!(optset&OPTIONF))
		    fprintf(stderr,"%s: no match for %s\n",progname,argv[loop]);
            } else if(i>0)
                matches+=i;
            else
                goto exit;
	}

    if(!matches)	{
usage:	fprintf(stderr,"usage: %s [%s%safiqr] {filename}...\n",
	    progname,optsepar,optsepar);
	return(1);
    }

exit:
    return(0);
}


/*
**	rm does the actual removing
*/
unsigned int notrmd=0;

rm(file_match)
FILE_MATCH *file_match; {
    unsigned register char attribute=file_match->attribute;

	/* We get all names, but react to SAFEATTR files only on -a option */
    if( !(optset&OPTIONA) && (attribute&SAFEATTR))	{
	if(attribute&DIRECTORY)
	    notrmd=0;
	else
	    notrmd++;
	return(0);
    }

    if( optset&OPTIONI || (attribute&SAFEATTR && !(optset&OPTIONF)) ) {
        if(optset&OPTIONI)
            printf("%s %s\t? ",progname,file_match->filename);
        else
            printf("%s: override mode %02x for %s\t? ",progname,
                attribute,file_match->filename);
        switch(askreply(NO))	{
        case QUIT:
            return(1);
        case NO:
	    if(attribute&DIRECTORY)
    		notrmd=0;
	    else
		notrmd++;
            return(0);
	case ALL:
	    if(optset&OPTIONI)
		optset &= ~OPTIONI;
	    else
	    	optset |= OPTIONF;
        }
    }

	/* MS-DOS does not need write permission on directory to rmdir() it */
    if(!(attribute & DIRECTORY) && (attribute & SAFEATTR) &&
        chmod(file_match->filename,attribute&(~SAFEATTR)))  {
	if(!(optset&OPTIONF))
	    fprintf(stderr,"%s: cannot chmod \"%s\" from %02x (status %d)\n",
		progname,file_match->filename,attribute,errno);
        return(1);
    } else if(attribute&DIRECTORY)  {
        if(notrmd)
	    return(notrmd=0);
	else if(rmdir(file_match->filename) && !(optset&OPTIONF))   {
            fprintf(stderr,"%s: cannot rmdir \"%s\" (status %d)\n",
                progname,file_match->filename,errno);
            return(1);
        }
    } else if(unlink(file_match->filename) && !(optset&OPTIONF))    {
        fprintf(stderr,"%s: cannot remove \"%s\" (status %d)\n",
            progname,file_match->filename,errno);
        return(1);
    }

    if(!(optset&(OPTIONQ|OPTIONI)))
        printf("%s: %s\n",progname,file_match->filename);

    return(0);
}
