unit Files;

{ ͻ }
{  interface }
{ ͼ}
{  ͼ}

interface

uses

  DOS;

{public declarations}

type

  FileInfo  = record

          Fill        : array[1..21] of byte;       {searchrec.Fill}
          Attr        : byte;                       {searchrec.Attr}
          PackedTime  : longint;                    {searchrec.Time}
          Year        : word;                   {year   (1980..2099)}
          Month       : word;                   {month  (1..12))}
          Day         : word;                   {day    (1..31)}
          Hour        : word;                   {hour   (0..23)}
          Min         : word;                   {min    (0..59)}
          Sec         : word;                   {sec    (0..59)}
          Size        : longint;                    {searchrec.Size}
          Fullname    : DirStr;                 {drive & dir & filename & ext}
          Path        : DirStr;                 {drive & directory & backslash}
          Drive       : string[2];              {drive}
          Dir         : DirStr;                 {backslash & dir & backslash}
          NameExt     : string[12];                 {searchrec.Name}
          Name        : NameStr;                {filename}
          Ext         : ExtStr;                 {extension with preceding dot}


  end;



function FirstFile (    FilePath      : OpenString;
                        FileAttr      : Word;
                    var rc_FileInfo   : FileInfo)               : Integer;


function NextFile  (var rc_FileInfo   : FileInfo)               : Integer;


function EraseFile (    s_File        : string)                 : boolean;



{ ͻ }
{  implementation }
{ ͼ}
{  ͼ}

implementation



{ ---------------------------------------------------------------------------- }
{ ͻ }
{  FileInfo_to_SearchRec  }
{ ͼ }
{ ---------------------------------------------------------------------------- }

procedure fileinfo_to_searchrec (var rc_fileinfo : FileInfo;
                                 var rc_DOSRec   : searchrec)  ;


          {
            private procedure that copies the data in FileInfo into SearchRec
          }

          {
            needs:

            unit              DOS

          }


var
  dt                  : datetime;         {date & time unpacked}
  scratchdir          : DirStr;           {scratch variable}
  loopcnt             : integer;          {loopcounter}

{ ---------------------------------------------------------------------------- }

BEGIN {fileinfo_to_searchrec}

  with rc_fileinfo do

  Begin {with rc_fileinfo}
    for loopcnt := 1 to sizeof (Fill) do
      rc_DOSRec.Fill[loopcnt] := fill[loopcnt];
    rc_DOSRec.Attr := Attr;
    rc_DOSRec.Time := PackedTime;
    rc_DOSRec.Size := Size;
    rc_DOSRec.Name := NameExt;
  End;  {with rc_fileinfo}

END;  {fileinfo_to_searchrec}




{ ---------------------------------------------------------------------------- }
{ ͻ }
{  SearchRec_to_FileInfo  }
{ ͼ }
{ ---------------------------------------------------------------------------- }

procedure searchrec_to_fileinfo (var rc_fileinfo : FileInfo;
                                 var rc_DOSRec   : searchrec)  ;


          {
            private procedure that copies the data in Searchrec into FileInfo
          }

          {
            needs:

            unit              DOS

          }


var
  dt                  : datetime;         {date & time unpacked}
  scratchdir          : DirStr;           {scratch variable}
  loopcnt             : integer;          {loopcounter}

{ ---------------------------------------------------------------------------- }

BEGIN {searchrec_to_fileinfo}

  with rc_fileinfo do

  Begin {with rc_fileinfo}
    for loopcnt := 1 to sizeof (Fill) do
      fill[loopcnt] := rc_DOSRec.Fill[loopcnt];
    Attr      := rc_DOSRec.Attr;
    PackedTime:= rc_DOSRec.Time;
    Size      := rc_DOSRec.Size;
    NameExt   := rc_DOSRec.Name;
    FSplit      (rc_DOSRec.Name, scratchdir, Name, Ext);
    Fullname  := Path + Name + Ext;
   {Path      := must be defined before}
    Drive     := copy (Path, 1, 2);
    Dir       := copy (Path, 3, length (path) -2);
    UnpackTime  (rc_DOSRec.Time, dt);
    Year      := dt.year;
    Month     := dt.month;
    Day       := dt.day;
    Hour      := dt.hour;
    Min       := dt.min;
    Sec       := dt.sec;
  End;  {with rc_fileinfo}

END;  {searchrec_to_fileinfo}




{ ---------------------------------------------------------------------------- }
{ ͻ }
{  FirstFile  }
{ ͼ }
{ ---------------------------------------------------------------------------- }

function FirstFile;

          {
            replacement for FindFirst
            adds more filedata to the record; uses FileInfo instead of
            searchrec

            returns DOSError as an integer

          }

          {
            needs:

            unit              DOS

          }


var

  rc_DOSRec           : searchrec;        {defined in DOS unit}

{ ---------------------------------------------------------------------------- }

BEGIN {FirstFile}

  {$i-}
  with rc_FileInfo do

  Begin {with rc_FileInfo}
    FilePath := FExpand   (FilePath);
    Fsplit    (FilePath, Path, Name, Ext);
    FindFirst (FilePath, FileAttr, rc_DOSRec);
    searchrec_to_fileinfo (rc_fileinfo, rc_DOSRec)
  End;  {with rc_FileInfo}

  {$i+}
  FirstFile := IOResult;
  FirstFile := DOSError;

END;  {FirstFile}





{ ---------------------------------------------------------------------------- }
{ ͻ }
{  NextFile  }
{ ͼ }
{ ---------------------------------------------------------------------------- }

function NextFile;

          {
            replacement for FindNext
            adds more filedata to the record; uses FileInfo instead of
            searchrec

            returns DOSError as an integer

          }

          {
            needs:

            unit              DOS

          }

var

  rc_DOSRec           : searchrec;        {defined in DOS unit}

{ ---------------------------------------------------------------------------- }

BEGIN {NextFile}

  {$i-}
  with rc_FileInfo do

  Begin {with rc_Fileinfo}
    fileinfo_to_searchrec (rc_FileInfo, rc_DOSRec);
    FindNext (rc_DOSRec);
    searchrec_to_fileinfo (rc_FileInfo, rc_DOSRec);
  End;  {with rc_Fileinfo}

  {$i+}
  NextFile := IOResult;
  NextFile := DOSError;

END;  {NextFile}





{ ---------------------------------------------------------------------------- }
{ ͻ
{  EraseFile 
{ ͼ
{ ---------------------------------------------------------------------------- }

function EraseFile;

          {
            FileExists taken from Turbo Pascal 7.0 Programmers
            Reference p.143 and changed

            returns True if the file was erased successfully, otherwise
            returns False

          }

          {
            needs:
          }

var

  f_File              : file;             {file handle}

{ ---------------------------------------------------------------------------- }

BEGIN

  EraseFile := False;
  {$i-}
  Assign (f_File, s_File);
  FileMode := 0;
  Reset (f_File);
  Close (f_File);
  {$i+}
  If (IOResult = 0) and (s_File <> '') then
  Begin {erase it}
    {$i-}
    Erase (f_File);
    {$i+}
    if IOResult = 0 then
      EraseFile := True;
  End;  {erase it}

END;




END. {unit files}
