(* TURBO pascal version of MSBPCT                          *)
(*                                                         *)
(* Author: Helmut Waelder (ZRWA001 at DTUZDV1.BITNET)      *)
(*         Zentrum fuer Datenverarbeitung                  *)
(*         Brunnenstr. 27                                  *)
(*         D-7400 Tuebingen                                *)
(*                                                         *)
(* Version 1.0 of 87/07/10                                 *)
(*                                                         *)
(* Decodes the mskermit.boo file about 2 times faster than *)
(* the C version.                                          *)

(*$c-,k-,d-*)
program msbpct;
const nullchr = 78; (* ord('tilde') - ord('0') *)
var a,b,c,d:byte;
    ch:char;
    i,index:integer;
    rptcnt,len:integer;
    infilename:string(.63.); (* maximum path length in DOS *)
    outfilename:string(.12.);
    line:string(.132.);
    infile,outfile:text(.32000.);
function fixchr(x:char):byte;
begin
  fixchr:=ord(x)-48; (* ord('0') *)
end;

Begin
If paramcount > 1 then
 Begin
  writeln('Too many arguments. Usage:  MSBPCT <inputfile> ');
  halt(1);
 end;
if paramcount = 0 then infilename:='MSKERMIT.BOO'
 else
 begin
  infilename:=paramstr(1);
  if pos('.',infilename)=0 then infilename:=infilename+'.BOO';
 end;
assign(infile,infilename);
(*$I-*) reset(infile); (*$I+*)
if IOResult <> 0 then
 begin
  writeln(infilename,' not found.');
  halt(1);
 end;
readln(infile,outfilename);
assign(outfile,outfilename);
(*$I-*) reset(outfile); (*$I+*)
if IOResult=0 then
 begin
  write('Outputfile ',outfilename,' already exists. Continue (y/n)? ');
  repeat
   read(kbd,ch);
   ch:=upcase(ch);
  until ch in (.'N','Y'.);
  writeln;
  if ch = 'N' then halt(1);
 end;
(*$I-*) rewrite(outfile); (*$I+*)
if IOResult<>0 then
 begin
  writeln('Could not open ',outfilename);
  halt(1);
 end;
writeln('Decoding ',infilename,', creating ',outfilename);
while not eof(infile) do
 begin
  readln(infile,line);
(*i:=pos(' ',line); *) (* uncomment this 2 lines, if you have problems with *)
(*if i>0 then delete(line,i,length(line)); *) (* trailing blanks *)
  len:=length(line);
  index:=1;
  while index<len do
   begin
    a:=fixchr(line(.index.));
    index:=succ(index);
    b:=fixchr(line(.index.));
    index:=succ(index);
    if a=nullchr then for i:=1 to b do write(outfile,#0)
     else
     begin
      c:=fixchr(line(.index.));
      index:=succ(index);
      d:=fixchr(line(.index.));
      index:=succ(index);
      write(outfile,chr(a shl 2 or b shr 4));
      write(outfile,chr(b shl 4 or c shr 2));
      write(outfile,chr(c shl 6 or d));
     end;
  end;
 end;
(* write(outfile,#26); *) (* there is no need to append a ctrl-z *)
close(infile);
close(outfile);
end.
