///////////////////////////////////////////////////////////
// WINDW.H: Header file ffor the DOS window classes.
///////////////////////////////////////////////////////////

#ifndef _WINDW_H
#define _WINDW_H

#include <string.h>
#include "event.h"

#define OK        1
#define YES       2
#define NO        3
#define CANCEL    4
#define OKALT     0x1c0d
#define CANCELALT 0x011b

//////////////////////////////////////////////////////////
// WINDW
///////////////////////////////////////////////////////////
class Windw
{
private:
   int *buffer; // Pointer to screen buffer.

protected:
   int WindowX, WindowY, WindowWidth, WindowHeight; // Window coords.
   int border,         // Flag for border.
       buffered;       // Flag for buffer.
   EventMsg eventMsg;  // Event message.

public:
   Windw(int X, int Y, int width, int height, int BordrFlag, int BuferFlag);
   virtual ~Windw();
   virtual void DrawWindow();
   virtual void RunWindow();

private:
   void WindwError(char *string);
};

///////////////////////////////////////////////////////////
// CAPWINDW
///////////////////////////////////////////////////////////
class CapWindw: public Windw
{
protected:
   char label[61];

public:
   CapWindw(int X, int Y, int width, int height,
      int BordrFlag, int BuferFlag, char *string);
   virtual void DrawWindow();
   void SetCaption(char *string);

private:
   void DrawCapBar();
};

///////////////////////////////////////////////////////////
// CAPTWINDW
///////////////////////////////////////////////////////////
class CapTWindw: public CapWindw
{
protected:
   char *line1, *line2;
   int button;

public:
   CapTWindw(char *string1, char *string2, char *string3);
   virtual void DrawWindow();
   int GetButton() { return button; }
};

///////////////////////////////////////////////////////////
// BUTTON
///////////////////////////////////////////////////////////
class Button: public Windw
{
private:
   char label[20];
   unsigned hotkey;
   int altkey;

public:
   Button(int X, int Y, char *string, int size);
   void DrawWindow();
   int Clicked(EventMsg eventMsg);
   void ClickButton();
};

///////////////////////////////////////////////////////////
// OKWINDW
///////////////////////////////////////////////////////////
class OKWindw: public CapTWindw
{
private:
   Button *butn;

public:
   OKWindw(char *string1, char *string2, char *string3);
   virtual ~OKWindw();
   virtual void DrawWindow();
   virtual void RunWindow();
};

///////////////////////////////////////////////////////////
// YESNOWINDW
///////////////////////////////////////////////////////////
class YesNoWindw: public CapTWindw
{
protected:
   Button *butn1, *butn2;

public:
   YesNoWindw(char *string1, char *string2, char *string3);
   virtual ~YesNoWindw();
   virtual void DrawWindow();
   virtual void RunWindow();
};

///////////////////////////////////////////////////////////
// YESNOCANWINDW
///////////////////////////////////////////////////////////
class YesNoCanWindw: public CapTWindw
{
private:
   Button *butn1, *butn2, *butn3;

public:
   YesNoCanWindw(char *string1, char *string2, char *string3);
   virtual ~YesNoCanWindw();
   virtual void DrawWindow();
   virtual void RunWindow();
};

///////////////////////////////////////////////////////////
// INPUTWINDW
///////////////////////////////////////////////////////////
class InputWindw: public CapTWindw
{
private:
   char input[81];
   Button *butn1, *butn2;

public:
   InputWindw(char *string1, char *string2, char *string3);
   virtual ~InputWindw();
   void GetInput(char *string) { strcpy(string, input); }
   virtual void DrawWindow();
   virtual void RunWindow();

private:
   void HandleInput(char KeyValue);
};

/*ķ*\
   The ItemWindw class's declaration. 
\*Ľ*/
class ItemWindw: public CapTWindw
{
private:
   char input[81];

public:
   ItemWindw(char *string1, char *string2, char *string3);
   virtual ~ItemWindw();
   void GetInput(char *string)
   {
     strcpy(string, input);
   }
   virtual void DrawWindow();
   virtual void RunWindow();

private:
   void HandleInput(char KeyValue);
};

#endif
