/*ͻ*\
   Filename:  FILE\SEARCH.CPP              
   Name:      John Wiggins                 
   Course:    Programming II               
   Function:  Search for a record to view. 
\*ͼ*/
#include <stdio.h>
#include <stdlib.h>
#include "medusa.h"
#include "msi_wndw.h"
#include "windw.h" // string.h and event.h is in here.

// Only used in this function.
void NotFound();

void SearchRecord(ProgramPtr SearchHead)
{
  char Choice;
  // This new struct is ONLY used for easier comparison.
  program_info Comp;
  // Make a temporary head.
  ProgramPtr CurProgram, FoundSearchHead;
  char Buffer[81];
  Choice = SelectField();
  switch (Choice)
  {
    case 'T':
    {
      InputWindw *TitleWndw;
      TitleWndw = new InputWindw("Search: Title", "Enter title name:", "");
      TitleWndw->DrawWindow();
      TitleWndw->RunWindow();
      if (TitleWndw->GetButton() == OK)
      {
        TitleWndw->GetInput(Buffer);
        strncpy(Comp.Title, Buffer, TITLE_LENGTH);
        delete TitleWndw;
        // Reset everything.
	CurProgram = SearchHead;
	FoundSearchHead = NULL;
	do
	{
  	  while ((CurProgram != NULL) && ((stricmp(CurProgram->Title, Comp.Title) != 0)))
	    CurProgram = CurProgram->next;
          // Found the record.
	  if (CurProgram != NULL)
          {
            // Add to linked list.
	    Add2List(CurProgram, FoundSearchHead);
            CurProgram = CurProgram->next;
          }
	} while (CurProgram !=NULL);
        // Only view the list if it exists.
        if (FoundSearchHead != NULL)
          ViewAll(FoundSearchHead);
        // Send the item not found to an error dispatcher.
        else
	  NotFound();
      }
      // Cancel, do nothing.
      break;
    }
    case 'L':
    {
      InputWindw *PublishWndw;
      PublishWndw = new InputWindw("Search: Publisher", "Enter publisher name:", "");
      PublishWndw->DrawWindow();
      PublishWndw->RunWindow();
      if (PublishWndw->GetButton() == OK)
      {
        PublishWndw->GetInput(Buffer);
 	strncpy(Comp.PublisherName, Buffer, PUBLISHER_LENGTH);
        Comp.PublisherName[strlen(Buffer)+1] = '\0';
	delete PublishWndw;
        // Reset everything.
	CurProgram = SearchHead;
	FoundSearchHead = NULL;
	do
	{
          // Loop through list until list is gone or item is found.
    	  while ((CurProgram != NULL) && ((stricmp(CurProgram->PublisherName, Comp.PublisherName) != 0)))
	    CurProgram = CurProgram->next;
          // Found the record.
	  if (CurProgram != NULL)
          {
            // Add to linked list.
	    Add2List(CurProgram, FoundSearchHead);
            CurProgram = CurProgram->next;
          }
	} while (CurProgram !=NULL);
        // Only view the list if it exists.
        if (FoundSearchHead != NULL)
          ViewAll(FoundSearchHead);
        // Send the item not found to an error dispatcher.
        else
	  NotFound();
      }
      // Cancel, do nothing.
      break;
    }
    case 'C':
    {
      InputWindw *ComputerWndw;
      ComputerWndw = new InputWindw("Search: Computer", "Enter computer type:", "");
      ComputerWndw->DrawWindow();
      ComputerWndw->RunWindow();
      if (ComputerWndw->GetButton() == OK)
      {
        ComputerWndw->GetInput(Buffer);
 	strncpy(Comp.ComputerType, Buffer, COMPUTER_TYPE_LENGTH);
        Comp.ComputerType[strlen(Buffer)+1] = '\0';
 	delete ComputerWndw;
	// Reset everything.
	CurProgram = SearchHead;
	FoundSearchHead = NULL;
	do
	{
          // Loop through list until list is gone or item is found.
    	  while ((CurProgram != NULL) && ((stricmp(CurProgram->ComputerType, Comp.ComputerType) > 0)))
            CurProgram = CurProgram->next;
          // Found the record.
          if (CurProgram != NULL)
          {
            // Add to linked list.
            Add2List(CurProgram, FoundSearchHead);
            CurProgram = CurProgram->next;
          }
        } while (CurProgram !=NULL);
        // Only view the list if it exists.
        if (FoundSearchHead != NULL)
          ViewAll(FoundSearchHead);
        // Send the item not found to an error dispatcher.
        else
          NotFound();
      }
      // Cancel, do nothing.
      break;
    }
    case 'V':
    {
      InputWindw *VersionWndw;
      VersionWndw = new InputWindw("Search: Version", "Enter program version:", "");
      VersionWndw->DrawWindow();
      VersionWndw->RunWindow();
      if (VersionWndw->GetButton() == OK)
      {
        VersionWndw->GetInput(Buffer);
        strncpy(Comp.Version, Buffer, VERSION_LENGTH);
        Comp.Version[strlen(Buffer)+1] = '\0';
        delete VersionWndw;
        // Reset everything.
        CurProgram = SearchHead;
        FoundSearchHead = NULL;
        do
        {
          // Loop through list until list is gone or item is found.
  	  while ((CurProgram != NULL) && ((stricmp(CurProgram->Version, Comp.Version) != 0)))
	    CurProgram = CurProgram->next;
          // Found the record.
	  if (CurProgram != NULL)
          {
            // Add to linked list.
	    Add2List(CurProgram, FoundSearchHead);
            CurProgram = CurProgram->next;
          }
	} while (CurProgram !=NULL);
        // Only view the list if it exists.
        if (FoundSearchHead != NULL)
          ViewAll(FoundSearchHead);
        // Send the item not found to an error dispatcher.
        else
	  NotFound();
      }
      // Cancel, do nothing.
      break;
    }
    case 'Y':
    {
      InputWindw *TypeWndw;
      TypeWndw = new InputWindw("Search: Type", "Enter program type:", "");
      TypeWndw->DrawWindow();
      TypeWndw->RunWindow();
      if (TypeWndw->GetButton() == OK)
      {
        TypeWndw->GetInput(Buffer);
	strncpy(Comp.ProgramType, Buffer, PROGRAM_TYPE_LENGTH);
        Comp.ProgramType[strlen(Buffer)+1] = '\0';
	delete TypeWndw;
	// Reset everything.
	CurProgram = SearchHead;
	FoundSearchHead = NULL;
  	do
	{
          // Loop through list until list is gone or item is found.
          while ((CurProgram != NULL) && ((stricmp(CurProgram->ProgramType, Comp.ProgramType) != 0)))
            CurProgram = CurProgram->next;
          // Found the record.
     	  if (CurProgram != NULL)
          {
            // Add to linked list.
	    Add2List(CurProgram, FoundSearchHead);
            CurProgram = CurProgram->next;
          }
	} while (CurProgram !=NULL);
        // Only view the list if it exists.
        if (FoundSearchHead != NULL)
          ViewAll(FoundSearchHead);
        // Send the item not found to an error dispatcher.
        else
	  NotFound();
      }
     // Cancel, do nothing.
     break;
    }
    case 'M':
    {
      char WhatMedia=MediaButtons("Search: ");
      switch (WhatMedia)
      {
        case 'A': strcpy(Comp.DiskType, "3.5 HD"); break;
        case 'B': strcpy(Comp.DiskType, "3.5 DD"); break;
        case 'C': strcpy(Comp.DiskType, "5.25 HD"); break;
        case 'D': strcpy(Comp.DiskType, "5.25 DD"); break;
        case 'E': strcpy(Comp.DiskType, "CD-ROM"); break;
        case 'F': strcpy(Comp.DiskType, "Hard Drive"); break;
      }
      // Reset everything.
      CurProgram = SearchHead;
      FoundSearchHead = NULL;
      do
      {
        // Loop through list until list is gone or item is found.
	while ((CurProgram != NULL) && (strcmp(CurProgram->DiskType, Comp.DiskType) != 0))
	  CurProgram = CurProgram->next;
        // Found the record.
	if (CurProgram != NULL)
        {
          // Add to linked list.
	  Add2List(CurProgram, FoundSearchHead);
          CurProgram = CurProgram->next;
        }
      } while (CurProgram !=NULL);
      // Only view the list if it exists.
      if (FoundSearchHead != NULL)
        ViewAll(FoundSearchHead);
      // Send the item not found to an error dispatcher.
      else
        NotFound();
      // Cancel, do nothing.
      break;
    }
    case 'R':
    {
      InputWindw *CopyrightWndw;
      CopyrightWndw = new InputWindw("Search: Copyright", "Enter copyright date:", "");
      CopyrightWndw->DrawWindow();
      CopyrightWndw->RunWindow();
      if (CopyrightWndw->GetButton() == OK)
      {
        CopyrightWndw->GetInput(Buffer);
	strncpy(Comp.Copyright, Buffer, COPYRIGHT_LENGTH);
        Comp.Copyright[strlen(Buffer)+1] = '\0';
        // Remove window.
	delete CopyrightWndw;
	// Reset everything.
	CurProgram = SearchHead;
	FoundSearchHead = NULL;
        do
	{
          // Loop through list until list is gone or item is found.
    	  while ((CurProgram != NULL) && ((stricmp(CurProgram->Copyright, Comp.Copyright) != 0)))
            CurProgram = CurProgram->next;
          // Found the record.
	  if (CurProgram != NULL)
          {
            // Add to linked list.
	    Add2List(CurProgram, FoundSearchHead);
            CurProgram = CurProgram->next;
          }
  	} while (CurProgram !=NULL);
        // Only view the list if it exists.
        if (FoundSearchHead != NULL)
          ViewAll(FoundSearchHead);
        // Send the item not found to an error dispatcher.
        else
          NotFound();
      }
      // Cancel, do nothing.
      break;
    }
    case 'S':
    {
      InputWindw *CostWndw;
      CostWndw = new InputWindw("Search: Cost", "Enter program price:", "");
      CostWndw->DrawWindow();
      CostWndw->RunWindow();
      if (CostWndw->GetButton() == OK)
      {
        CostWndw->GetInput(Buffer);
        strncpy(Comp.Cost, Buffer, COST_LENGTH);
        Comp.Cost[strlen(Buffer)+1] = '\0';
        delete CostWndw;
	// Reset everything.
	CurProgram = SearchHead;
	FoundSearchHead = NULL;
	do
	{
          // Loop through list until list is gone or item is found.
    	  while ((CurProgram != NULL) && ((stricmp(CurProgram->Cost, Comp.Cost) != 0)))
	    CurProgram = CurProgram->next;
          // Found the record.
	  if (CurProgram != NULL)
          {
            // Add to linked list.
	    Add2List(CurProgram, FoundSearchHead);
            CurProgram = CurProgram->next;
          }
	} while (CurProgram !=NULL);
        // Only view the list if it exists.
        if (FoundSearchHead != NULL)
          ViewAll(FoundSearchHead);
        // Send the item not found to an error dispatcher.
        else
	  NotFound();
      }
      // Cancel, do nothing.
      break;
    }
    // User selected cancel.
    case 'Z':
      break;
  }
}

// Simply displays a 'not found' message.
void NotFound()
{
  OKWindw NotFoundWnd("Bad search:", "Not Found!", "Try again.");
  NotFoundWnd.DrawWindow();
  NotFoundWnd.RunWindow();
}
