/*
        UASM.H
        Universal Cross Assembler Header File
        Custom Computer Consultants
        5 April 1985
*/

#define EOS     '\000'
#define ETX     '\003'
#define BELL    '\007'
#define ESC     '\033'
#define DEL     '\177'

#define ERROR -1
#define OK 0
#define CPMEOF 0x1a
#define MAXLINE 135
#define TRUE 1
#define FALSE 0

#define AL      31      /* identifier length                    */
#define NSYM    300     /* Number of Symbols                    */
#define MAXB    34      /* Maximum Bytes Per Record             */

/*
        TOKENS
*/

#define NUL     '\200'
#define IDENT   '\201'
#define NUMBER  '\202'

#define NSEG    4

struct symbol  {
       char            *name ;
       char            flags ;
       unsigned        value ;
       int             link ;
       } ;







