#include <io.h>
#include <fcntl.h>
#include <alloc.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <iostream.h>
#include "flilib.h"

// Written by Ivo Bosticky 17-7-94
// for more info see the flilib.h file
// no optimisations done yet
// 8-10-94 extended to play flc files
// only support flcs that have sizex*sizey < 64000
// 22-1-95 added access to the color palette from external modules

#define LINE_SKIP 0xc000

unsigned char * fli_pal;
int		fli_use_pal = 1;

fli *	load_fli(char *filename,fli_source playtype) {

	int handle;
	fli huge *ptr,huge *ptr1;
	struct fli_header header;
	frame_header pfix;
	flc_header *flc;

	// load the 128 byte fli/flc header
	if((handle=open(filename,O_RDONLY | O_BINARY))==-1) return NULL;
	read(handle,&header,sizeof(fli_header));
	flc=(flc_header *)&header;
	switch (header.magic) {
		case fli_magic:	break;
		case flc_magic:
			lseek(handle,flc->oframe1,SEEK_SET);
			break;
		default	      :	close(handle);return (NULL);
		}
	if(playtype!=DISK) {
	// try to allocate ram for the entire fli
		if((ptr=(fli *)farmalloc(header.size-sizeof(fli_header)+sizeof(fli)))==NULL) {
			if (playtype==RAM) {close(handle);return NULL;}
			playtype=DISK;}
		else playtype=RAM;
	}

	// try to allocate ram just for the fli descriptor
	if(playtype==DISK)
		if((ptr=(fli *)farmalloc(sizeof(fli)))==NULL) {
			close(handle);return NULL;}

	// initialise the fli descriptor
	if (header.magic==fli_magic) {
		ptr->frames=header.frames;
		ptr->width=header.width;
		ptr->height=header.height;
		ptr->speed=header.speed;
	} else {
		ptr->frames=flc->frames;
		ptr->width=flc->width;
		ptr->height=flc->height;
		ptr->speed=(flc->speed*7/100);
		if (ptr->speed<1) ptr->speed=1;
	}
	ptr->current=0;
	ptr->crntoff=(long)sizeof(fli);

	if (playtype==RAM) ptr->handle=0;
	else ptr->handle=handle;

	if (playtype==RAM) {
	// load the entire fli into ram
		(char huge *)ptr1=(char huge *)ptr+sizeof(fli);
		while(read(handle,ptr1,32700)==32700) (char huge *)ptr1+=32700;
		close(handle);
		}

	// return the pointer to the fli
	return (fli *)ptr;
	}

void	flicolor(char *data)
{
	int i,j,sg,ofs,change;
	unsigned char current=0;
	i=*data;
	data+=2;
	if (fli_use_pal) {
		for (j=0; j<i; j++) {
			current+=*data++;
			change=*data++;
			if (!change) change=256;
			sg=FP_SEG(data);
			ofs=FP_OFF(data);
			data+=(int)change*3;
			asm {
				mov ax,0x1012
				mov bl,current
				xor bh,bh
				mov cx,change
				mov dx,ofs
				mov ax,sg
				push es
				mov es,ax
				mov ax,0x1012
				int 0x10
				pop es
			}
		}
	} else {
		for (j=0; j<i; j++) {
			current+=*data++;
			change=*data++;
			if (!change) change=256;
			for (sg = 0; sg < change * 3; sg++)
				fli_pal[(int)current * 3 + sg] = data[sg];
			data+=(int)change*3;
		}
	}
}


void	flicolor256to64(char *data) {
// this just converts from 0 to 255 range to 0 to 64 color range for each
// r,g,b color
	int i,j,k,change;
	i=*data;
	data+=2;
	for (j=0; j<i; j++) {
		data++;
		change=*data++;
		if (!change) change=256;
		for (k=0; k<change*3; k++)
			(unsigned char )*(data++) /= 4;

	}
}

void flibrun(char *data,char *dest,int xsize,int ysize) {
	int i,j,k;
	char ppl,sc,dt,*dest1;
	for (i=0; i<ysize; i++) {
		ppl=*(data++);
		dest1=dest;
		for (j=0;j<ppl;j++) {
			sc=*(data++);
			if (sc<0) for(k=0;k<-sc;k++) *(dest++)=*(data++);
			else {  dt=*(data++);
				for(k=0;k<sc;k++) *(dest++)=dt;
				}
			}
		dest=dest1+xsize;
		}
	}

void flilc(char *data,char *dest,int xsize,char *finaldata) {
	int j,k,l,m;
	char sc,dt,*dest1;
	unsigned char ppl;
	do {
	    j=*(int *)(data);
	    data+=2;
	    dest+=j*xsize;
	    m=*(int *)(data);
	    data+=2;
	    for (l=0;l<m;l++) {
		ppl=*(data++);
		dest1=dest;
		for (j=0;j<ppl;j++) {
			dest+=(unsigned char)*(data++);
			sc=*(data++);
			if (sc>0) for(k=0;k<sc;k++) *(dest++)=*(data++);
			if (sc<0) {  dt=*(data++);
				for(k=0;k<-sc;k++) *(dest++)=dt;
				}
			if (data>=finaldata) return;
			}
		dest=dest1+xsize;
		}
	    }while(data<finaldata);
	}

void fliss2(char *data,char *dest,int xsize) {
	int j,k,cl,l,m,p,ppl,ppl1,dt;
	char sc,*dest1;

	cl=*((int *)data)++;
	for (l=0; l<cl; l++) {
		ppl=*((int *)data)++;
		while ((ppl & LINE_SKIP) == LINE_SKIP)
			{
			dest -= xsize*(unsigned int)ppl;
			ppl = *((int *)data)++;
			}
		dest1 = dest;
		ppl1 = ppl;
		if (ppl < 0)
			ppl1 =*((int *)data)++;
		for (p=0;p<ppl1;p++) {
			dest+=(unsigned char)*(data++);
			sc=*(data++);
			if (sc>0) for(k=0;k<sc;k++)
				*((int *)dest)++=*((int *)data)++;
			if (sc<0) {  dt=*((int *)data)++;
			for(k=0;k<-sc;k++) *((int *)dest)++=dt;
			}
		}
		if (ppl < 0)
			*dest = ppl;
		dest=dest1+xsize;
	}
}

int	play_frame(fli *fliptr,char *dest,int sizex){
	frame_header *frame,frame1;
	chunk_header *chunk;
	int	i;

	if (fliptr->handle==0) {
	// if playing from ram, setup pointers for the next frame
		(char huge *)frame=(char huge *)fliptr+fliptr->crntoff;
		(char *)chunk=(char *)frame+sizeof(frame_header);
		fliptr->current++;
		if (fliptr->current==fliptr->frames) {
			fliptr->current=0;
			fliptr->crntoff=(long)sizeof(fli);
			}
		else {
			fliptr->crntoff+=frame->size;
		     }
	}
	else {
	// if playing from disk, read the next frame
		read(fliptr->handle,&frame1,sizeof(frame_header));
		frame=&frame1;
		if (frame1.chunks>0) {
			// if there are chunks to load, load em
			if((chunk=(chunk_header *)malloc(frame1.size-sizeof(frame_header)))==NULL) return 1;
			read(fliptr->handle,chunk,frame1.size-sizeof(frame_header));
			}
		fliptr->current++;
		if (fliptr->current==fliptr->frames) {
			fliptr->current=0;
			if (lseek(fliptr->handle,sizeof(fli_header),SEEK_SET)==-1) return 1;
			}
	}

	// play the current frame into the destination buffer
	if (frame->magic == frame_magic)
	   for (i=0; i<frame->chunks;i++) {
		switch(chunk->type) {
		case FLI_COLOR256:
			// this fixes up the color pal and if playing from ram
			// this is done only once
			flicolor256to64((char *)chunk+sizeof(chunk_header));
			chunk->type = FLI_COLOR;
			flicolor((char *)chunk+sizeof(chunk_header));
			break;
		case FLI_SS2:
			fliss2((char *)chunk+sizeof(chunk_header),dest,sizex);
			break;
		case FLI_COLOR:
			flicolor((char *)chunk+sizeof(chunk_header));
			break;
		case FLI_LC:
			flilc((char *)chunk+sizeof(chunk_header),dest,sizex,(char *)chunk+chunk->size-1);
			break;
		case FLI_BLACK:
			break; // have to make this one day
		case FLI_BRUN:
			flibrun((char *)chunk+sizeof(chunk_header),dest,sizex,fliptr->height);
			break;
		case FLI_COPY:
			break; // have to make this one day
		case FLI_PSTAMP:
			break; // ignore the stamps
		default:
			cout<<"undefined chunk type";
		}
		(char *)chunk+=chunk->size;
	   }

	// if playing from the disk, free the previous frame data
	if (fliptr->handle!=0&&frame1.chunks!=0) free(chunk);
	return 0;
}

void	close_fli(fli *fliptr) {
	if (fliptr->handle!=0) close(fliptr->handle);
	free(fliptr);
	}

