// This program exercises most features of the super_precision class library.
//              Copyright (c) 1997 William T. Wyatt, Jr.

#include "super.cc"

main ()
{
//int izq;
//cin>>izq;
//int izr;
//cin>>izr;
//	super_precision :: setup ( izq, izr);	// Initialize thru static fn
	super_precision :: setup ( 53, 10);	// Initialize thru static fn
	super_precision c = 143;
	int32 i, jtrash, nf = 6;

	c += 1;

	cout << "Hello, super world!\n";

	c = exp ( c);
	cout<<"c="; c.super_dump ();
	super_precision a, b;

	a=2;
	b=sqrt(a);
	c=b*b;
	b=a-c;
	b.super_dump ();

	a=2;
	b=cbrt(a);
	c=b*b*b;
	b=a-c;
	b.super_dump ();

	cout << "c="; c.super_dump ();

	cout <<"\ntest of super_fill, super_shift_public, super_norm_public:\n";
	b.super_fill ( -1, +1);
	b.super_fill ( 0, 5);
	for ( i = 1; i <= nf; i++) b.super_fill ( i, i+10*(i+10*i));
	b.super_dump ();
	a = b;
	a.super_dump ();
	a.super_shift_public ( 2);
	a.super_dump ();
	a.super_shift_public ( -2);
	a.super_dump ();
	a.super_shift_public ( -19);
	a.super_dump ();
	a.super_norm_public ( i);
	cout << "shift_cnt=" << i << endl;
	a.super_dump ();
	b.super_fill ( -1, -1);
	b.super_fill ( 0, 9);
	for ( i = 2; i <= nf; i++) b.super_fill ( i, 0);
	b.super_fill ( 1, 1);
	b.super_dump ();
	b.super_norm_public ( i);
	b.super_dump ();	// b = -1

	cout << "\ntest of +, +=, unary -, -= operators:\n";
	c = a + b;
	c.super_dump ();
	a = b;
	a += a;
	cout << "before neg, b="; b.super_dump ();
	c = -b;
	cout << "after neg, c="; c.super_dump ();
	for ( i = 0; i < 3; i++)
	{
		cout << "i=" << i << endl;
		a -= b;
		b += b;
		b = -b;
		cout << "a="; a.super_dump ();
		cout << "b="; b.super_dump ();
	}

	cout <<"\ntest construction conversion, assignment of int to super:\n";
	super_precision d ( 6);
	cout << "d="; d.super_dump ();
	d = 7;
	cout << "d="; d.super_dump ();

	cout << "\ntest += int, multiple assignment, *, *=:\n";
	d += 8;
	cout << "d="; d.super_dump ();
	cout << "address b=" << (int32) &b << endl;
	cout << "address a=" << (int32) &a << endl;
	a = b = 1;
	cout << "b="; a.super_dump ();
	cout << "a="; a.super_dump ();
	a = b = d;
	cout << "b="; a.super_dump ();
	cout << "a="; a.super_dump ();
	cout << "multiplying next\n";
	d = a * b;
	cout << "d="; d.super_dump ();
	b = 80;
	d = a * b;
	cout << "d"; d.super_dump ();
	b.super_fill ( -1, +1);
	b.super_fill ( 0, 1);		// use for *=, /=, += timing loops
	b.super_fill ( 1, 101000000);	// ditto
//	b.super_fill ( 0, -6);		// use for -= timing loop
//	b.super_fill ( 1, 100001000);
	for ( i = 2; i <= nf; i++) b.super_fill ( i, 0);
	b.super_dump ();
//	jtrash = 0;			// use for bare loop timing
	a = 1;
//	a = 10;				// use for sqrt timing loop
//int32 ilim;
//cin >> ilim;
//	for ( i = 0; i < ilim; i++)	// use for variable-length timing runs
//	for ( i = 0; i < 0; i++)	// use for no-loop timing runs
//	for ( i = 0; i < 10; i++)	// use for very slow timing runs
	for ( i = 0; i < 100; i++)	// use for non-timing runs
//	for ( i = 0; i < 1000; i++)	// use for slow timing runs
//	for ( i = 0; i < 100000; i++)	// use for timing runs
	{
		a *= b;						// test *
//		a /= b; if ( i % 100 == 299) b = a * 20;	// test /
//		a += b;						// test +
//		a -= b;						// test -
//		a = sqrt ( a) + 1;					// test sqrt
//jtrash++;				// use for bare loop timing
	}
	a.super_dump ();
//exit (1);				// use for timing runs

	cout << "\ntest of mixed mode arithmetic (with int type):\n";
	a = 33;
	b = a * 20;
	cout << "a*20="; b.super_dump ();
	a = 12 * b;
	cout << "12*b="; a.super_dump ();
	b = 1;
	a = b / 6;
	cout << "1/6="; a.super_dump ();
	a /= 6;
	cout << "a/=6="; a.super_dump ();
	b = a;
	a *= 6;
	cout << "a*=6="; a.super_dump ();
	b = 6;
	a = a * b;
	cout << "a*6.0="; a.super_dump ();
	a = 1;
	a /= 6;
	b = 1;
	b /= 12;

	cout << "\ntest divide and divide int by super:\n";
	c = b / a;
	cout << "c=(1/12)/(1/6)="; c.super_dump ();
	c = (super_precision) 45 / a;
	cout << "c=45/(1/6)="; c.super_dump ();
	c = 30 / a;
	cout << "c=30/(1/6)="; c.super_dump ();

	cout << "\ntest of relationals (super with super):\n";
	a = 1000;
	cout << "a="; a.super_dump ();
	cout << "a<c=" << ( a < c) << endl;
	cout << "a>c=" << ( a > c) << endl;
	cout << "a<a+1=" << ( a < a+1) << endl;
	cout << "a>a+1=" << ( a > a+1) << endl;
	cout << "a==a=" << ( a == a) << endl;
	cout << "a==a+1=" << ( a == a+1) << endl;
	cout << "a!=a=" << ( a != a) << endl;
	cout << "a!=a+1=" << ( a != a+1) << endl;
	cout << "a>a=" << ( a > a) << endl;
	cout << "a<a=" << ( a < a) << endl;
	cout << "c<a=" << ( c < a) << endl;
	cout << "c>a=" << ( c > a) << endl;
	cout << "a+1<a=" << ( a+1 < a) << endl;
	cout << "a+1>a=" << ( a+1 > a) << endl;
	cout << "a==-a=" << ( a == -a) << endl;
	cout << "a+1==a=" << ( a+1 == a) << endl;
	cout << "a!=-a=" << ( a != -a) << endl;
	cout << "a+1!=a=" << ( a+1 != a) << endl;

	a = 0;
	cout << "a="; a.super_dump ();
	cout << "a<c=" << ( a < c) << endl;
	cout << "a>c=" << ( a > c) << endl;
	cout << "a<a+1=" << ( a < a+1) << endl;
	cout << "a>a+1=" << ( a > a+1) << endl;
	cout << "a==a=" << ( a == a) << endl;
	cout << "a==a+1=" << ( a == a+1) << endl;
	cout << "a!=a=" << ( a != a) << endl;
	cout << "a!=a+1=" << ( a != a+1) << endl;
	cout << "a>a=" << ( a > a) << endl;
	cout << "a<a=" << ( a < a) << endl;
	cout << "c<a=" << ( c < a) << endl;
	cout << "c>a=" << ( c > a) << endl;
	cout << "a+1<a=" << ( a+1 < a) << endl;
	cout << "a+1>a=" << ( a+1 > a) << endl;
	cout << "a==-a=" << ( a == -a) << endl;
	cout << "a+1==a=" << ( a+1 == a) << endl;
	cout << "a!=-a=" << ( a != -a) << endl;
	cout << "a+1!=a=" << ( a+1 != a) << endl;

	a = -1000;
	cout << "a="; a.super_dump ();
	cout << "a<c=" << ( a < c) << endl;
	cout << "a>c=" << ( a > c) << endl;
	cout << "a<a+1=" << ( a < a+1) << endl;
	cout << "a>a+1=" << ( a > a+1) << endl;
	cout << "a==a=" << ( a == a) << endl;
	cout << "a==a+1=" << ( a == a+1) << endl;
	cout << "a!=a=" << ( a != a) << endl;
	cout << "a!=a+1=" << ( a != a+1) << endl;
	cout << "a>a=" << ( a > a) << endl;
	cout << "a<a=" << ( a < a) << endl;
	cout << "c<a=" << ( c < a) << endl;
	cout << "c>a=" << ( c > a) << endl;
	cout << "a+1<a=" << ( a+1 < a) << endl;
	cout << "a+1>a=" << ( a+1 > a) << endl;
	cout << "a==-a=" << ( a == -a) << endl;
	cout << "a+1==a=" << ( a+1 == a) << endl;
	cout << "a!=-a=" << ( a != -a) << endl;
	cout << "a+1!=a=" << ( a+1 != a) << endl;

	cout << "\ntest of relational with int type:\n";
	a = 5;
	a.super_dump ();
	if ( a < 10)
	{
		cout << "a < 10\n";
	}
	else
	{
		cout << "error in a > 10\n";
	}
	if ( 10 > a)
	{
		cout << "10 > a\n";
	}
	else
	{
		cout << "error in 10 < a\n";
	}

	cout << "\ntest of super_to_i:\n";
	a = 101;
	i = super_to_i ( a);  cout << "i=" << i << endl;
	a = -1234;
	i = super_to_i ( a);  cout << "i=" << i << endl;
	a = 0;
	i = super_to_i ( a);  cout << "i=" << i << endl;
	a = 99999; a *= a *=a;
	cout << "a="; a.super_dump ();
	// i = super_to_i ( a);  cout << "i=" << i << endl;

	cout << "\ntest of super_to_approx_double:\n";
	double dd = super_to_approx_double ( a);
	cout << "dd = " << dd << endl;
	cout << "or = " << setprecision ( 15) << dd << endl;

	cout << "\nsqrt tests:\n";
	a = 1000;
	b = sqrt ( a);
	cout << "sqrt(1000)="; b.super_dump ();
	b *= b;
	cout << "squared="; b.super_dump ();

	b = 20 * sqrt ( a);
	cout << "sq*20="; b.super_dump ();
	a = -a;

	cout << "\nfabs test:\n";
	b = fabs ( a);
	cout << "fabs="; b.super_dump ();

	cout << "conversion constructor (from int type) test:\n";
	a = ( (super_precision) 2 + (super_precision) 3) *
			( (super_precision) 4 + (super_precision) 5);
	cout << "a="; a.super_dump ();

	cout << "\npow test:\n";
	b = 1 / (super_precision) 6;
	a = pow ( b, 25);
	cout << "(1/6)^25="; a.super_dump ();
	cout << "ditto = " << setprecision ( 15) << pow ( (double) 1 / 6, 25);
	cout << endl;

	cout << "\npi, log_10, log_radix tests:\n";
	a = pi ();
	cout << "pi="; a.super_dump ();
	a = sqrt ( (super_precision) 2);
	cout << "sqrt(2)="; a.super_dump ();

	a = log_10 ();
	cout << "log_10="; a.super_dump ();

	a = log_radix ();
	cout << "log_radix="; a.super_dump ();

	cout << "\ntrunc tests:\n";
	a = -10000 / (super_precision) 3;
	a = trunc ( a);
	cout << "\ntrunc(-3333.3)="; a.super_dump ();
	a = 1 / (super_precision) 2;
	a = trunc ( a);
	cout << "trunc(0.5)="; a.super_dump ();

	cout << "\nmodulo arithmetic (%, %=) tests:\n";
	a = (super_precision) 100 % (super_precision) 14;
	cout << "\n100%14="; a.super_dump ();
	a = (super_precision) -100 % (super_precision) 14;
	cout << "-100%14="; a.super_dump ();
	a = (super_precision) 100 % (super_precision) -14;
	cout << "100%-14="; a.super_dump ();
	a = (super_precision) -100 % (super_precision) -14;
	cout << "-100%-14="; a.super_dump ();
	a = 100;
	a %= (super_precision) -14;
	cout << "a%=-14="; a.super_dump ();
	a = 100 % (super_precision) -14;
	cout << "100%-14="; a.super_dump ();

	a = 100 % (super_precision) 0;
	cout << "100%0s="; a.super_dump ();
	a = 1;
	a %= (super_precision) 0;
	cout << "1%0s%="; a.super_dump ();

	cout << "\nceil test:\n";
	a = 0;
	b = ceil ( a);
	cout << "ceil(0)="; b.super_dump ();
	a = 1;
	b = ceil ( a);
	cout << "ceil(1)="; b.super_dump ();
	a = -1;
	b = ceil ( a);
	cout << "ceil(-1)="; b.super_dump ();
	a = 1;
	b = ceil ( a/2);
	cout << "ceil(1/2)="; b.super_dump ();
	a = -1;
	b = ceil ( a/2);
	cout << "ceil(-1/2)="; b.super_dump ();
	a = 9;
	b = ceil ( a/2);
	cout << "ceil(9/2)="; b.super_dump ();
	a = -9;
	b = ceil ( a/2);
	cout << "ceil(-9/2)="; b.super_dump ();

	cout << "\nfloor test:\n";
	a = 0;
	b = floor ( a);
	cout << "floor(0)="; b.super_dump ();
	a = 1;
	b = floor ( a);
	cout << "floor(1)="; b.super_dump ();
	a = -1;
	b = floor ( a);
	cout << "floor(-1)="; b.super_dump ();
	a = 1;
	b = floor ( a/2);
	cout << "floor(1/2)="; b.super_dump ();
	a = -1;
	b = floor ( a/2);
	cout << "floor(-1/2)="; b.super_dump ();
	a = 9;
	b = floor ( a/2);
	cout << "floor(9/2)="; b.super_dump ();
	a = -9;
	b = floor ( a/2);
	cout << "floor(-9/2)="; b.super_dump ();

	cout << "\nlog, log10, exp tests:\n";
	a = 2;
	b = exp ( a);
	cout << "exp(2)="; b.super_dump ();
	a = log_10 ();
	cout << "l10="; a.super_dump ();
	a = 1 / log_10 ();
	cout << "1/l10="; a.super_dump ();
	b = exp ( 1 / log_10 ());
	cout << "exp(1/.43~)="; b.super_dump ();

	a = 20;
	b = log ( a);
	cout << "log(20)="; b.super_dump ();
	a = exp ( b);
	cout << "explog20="; a.super_dump ();
	a = 20;
	b = log10 ( a);
	cout << "log10(20)="; b.super_dump ();
	a = pow ( 10, b);
	cout << "10^log10(20)="; a.super_dump ();
	a = pow ( (super_precision) 2, (super_precision) 1 / 2);
	cout << "2^(1/2)="; a.super_dump ();

	cout << "\ntesting relational with int type:\n";
	a = 5; cout << "a="; a.super_dump ();
	cout << "a>4=" << ( a > 4) << endl;
	cout << "a<4=" << ( a < 4) << endl;
	cout << "4>a=" << ( 4 > a) << endl;
	cout << "4<a=" << ( 4 < a) << endl;

	cout << "\nfmod test:\n";
	a = fmod ( (super_precision) 25, (super_precision) 7);
	cout << "fmod(25,7)="; a.super_dump ();

	cout << "\nsinh, cosh, tanh tests:\n";
	a = 0;
	b = sinh ( a);
	cout << "sinh(0)="; b.super_dump ();
	b = cosh ( a);
	cout << "cosh(0)="; b.super_dump ();
	b = tanh ( a);
	cout << "tanh(0)="; b.super_dump ();
	a = (super_precision) 1 / 2;
	b = sinh ( a);
	cout << "sinh(1/2)="; b.super_dump ();
	b = cosh ( a);
	cout << "cosh(1/2)="; b.super_dump ();
	b = tanh ( a);
	cout << "tanh(1/2)="; b.super_dump ();
	b = sinh ( a) + cosh ( a) - exp ( a);
	cout << "sinh+cosh-exp(1/2)="; b.super_dump ();
	b = sinh ( a) / cosh ( a) - tanh ( a);
	cout << "sinh/cosh-tanh(1/2)="; b.super_dump ();
	a = -(super_precision) 1 / 2;
	b = sinh ( a);
	cout << "sinh(-1/2)="; b.super_dump ();
	b = cosh ( a);
	cout << "cosh(-1/2)="; b.super_dump ();
	b = tanh ( a);
	cout << "tanh(-1/2)="; b.super_dump ();
	b = sinh ( a) + cosh ( a) - exp ( a);
	cout << "sinh+cosh-exp(-1/2)="; b.super_dump ();
	b = sinh ( a) / cosh ( a) - tanh ( a);
	cout << "sinh/cosh-tanh(-1/2)="; b.super_dump ();
	a = 10;
	b = sinh ( a);
	cout << "sinh(10)="; b.super_dump ();
	b = cosh ( a);
	cout << "cosh(10)="; b.super_dump ();
	b = tanh ( a);
	cout << "tanh(10)="; b.super_dump ();
	b = sinh ( a) + cosh ( a) - exp ( a);
	cout << "sinh+cosh-exp(10)="; b.super_dump ();
	b = sinh ( a) / cosh ( a) - tanh ( a);
	cout << "sinh/cosh-tanh(10)="; b.super_dump ();
	a = -10;
	b = sinh ( a);
	cout << "sinh(-10)="; b.super_dump ();
	b = cosh ( a);
	cout << "cosh(-10)="; b.super_dump ();
	b = tanh ( a);
	cout << "tanh(-10)="; b.super_dump ();
	b = sinh ( a) + cosh ( a) - exp ( a);
	cout << "sinh+cosh-exp(-10)="; b.super_dump ();
	b = sinh ( a) / cosh ( a) - tanh ( a);
	cout << "sinh/cosh-tanh(-10)="; b.super_dump ();

	cout << "\nsin tests:\n";
	a = 0;
	a = sin ( a);
	cout << "sin(0)="; a.super_dump ();
	a = pi ();
	a = sin ( a);
	cout << "sin(pi)="; a.super_dump ();
	a = -pi ();
	a = sin ( a);
	cout << "sin(-pi)="; a.super_dump ();
	a = 2 * pi ();
	a = sin ( a);
	cout << "sin(2pi)="; a.super_dump ();
	a = -2 * pi ();
	a = sin ( a);
	cout << "sin(-2pi)="; a.super_dump ();
	a = pi () / 3;
	a = sin ( a);
	cout << "sin(pi/3)="; a.super_dump ();
	a = -pi () / 3;
	a = sin ( a);
	cout << "sin(-pi/3)="; a.super_dump ();
	a = 2 * pi () / 3;
	a = sin ( a);
	cout << "sin(2pi/3)="; a.super_dump ();
	a = -2 * pi () / 3;
	a = sin ( a);
	cout << "sin(-2pi/3)="; a.super_dump ();

	cout << "\ncos tests:\n";
	a = 0;
	a = cos ( a);
	cout << "cos(0)="; a.super_dump ();
	a = pi ();
	a = cos ( a);
	cout << "cos(pi)="; a.super_dump ();
	a = -pi ();
	a = cos ( a);
	cout << "cos(-pi)="; a.super_dump ();
	a = 2 * pi ();
	a = cos ( a);
	cout << "cos(2pi)="; a.super_dump ();
	a = -2 * pi ();
	a = cos ( a);
	cout << "cos(-2pi)="; a.super_dump ();
	a = pi () / 3;
	a = cos ( a);
	cout << "cos(pi/3)="; a.super_dump ();
	a = -pi () / 3;
	a = cos ( a);
	cout << "cos(-pi/3)="; a.super_dump ();
	a = 2 * pi () / 3;
	a = cos ( a);
	cout << "cos(2pi/3)="; a.super_dump ();
	a = -2 * pi () / 3;
	a = cos ( a);
	cout << "cos(-2pi/3)="; a.super_dump ();

	cout << "\ntan tests:\n";
	a = 0;
	a = tan ( a);
	cout << "tan(0)="; a.super_dump ();
	a = pi ();
	a = tan ( a);
	cout << "tan(pi)="; a.super_dump ();
	a = -pi ();
	a = tan ( a);
	cout << "tan(-pi)="; a.super_dump ();
	a = 2 * pi ();
	a = tan ( a);
	cout << "tan(2pi)="; a.super_dump ();
	a = -2 * pi ();
	a = tan ( a);
	cout << "tan(-2pi)="; a.super_dump ();
	a = pi () / 3;
	a = tan ( a);
	cout << "tan(pi/3)="; a.super_dump ();
	a = -pi () / 3;
	a = tan ( a);
	cout << "tan(-pi/3)="; a.super_dump ();
	a = 2 * pi () / 3;
	a = tan ( a);
	cout << "tan(2pi/3)="; a.super_dump ();
	a = -2 * pi () / 3;
	a = tan ( a);
	cout << "tan(-2pi/3)="; a.super_dump ();

	cout << "\nasin tests:\n";
	b = asin ( (super_precision) 0);
	cout << "asin(0)="; b.super_dump ();
	b = asin ( (super_precision) 1);
	cout << "asin(1)="; b.super_dump ();
	a = (super_precision) 1 / 2;
	b = asin ( a);
	cout << "asin(1/2)="; b.super_dump ();
	a = -(super_precision) 1 / 2;
	b = asin ( a);
	cout << "asin(-1/2)="; b.super_dump ();

	cout << "\nacos tests:\n";
	b = acos ( (super_precision) 0);
	cout << "acos(0)="; b.super_dump ();
	b = acos ( (super_precision) 1);
	cout << "acos(1)="; b.super_dump ();
	a = (super_precision) 1 / 2;
	b = acos ( a);
	cout << "acos(1/2)="; b.super_dump ();
	a = -(super_precision) 1 / 2;
	b = acos ( a);
	cout << "acos(-1/2)="; b.super_dump ();

	cout << "\natan tests:\n";
	b = atan ( (super_precision) 0);
	cout << "atan(0)="; b.super_dump ();
	a = (super_precision) 1 / 2;
	b = atan ( a);
	cout << "atan(1/2)="; b.super_dump ();
	a = -(super_precision) 1 / 2;
	b = atan ( a);
	cout << "atan(-1/2)="; b.super_dump ();

	cout << "\natan2 tests:\n";
	a = atan2 ( (super_precision) 0, (super_precision) 1);
	cout << "atan2(0,1)="; a.super_dump ();
	a = atan2 ( (super_precision) 1, (super_precision) 0);
	cout << "atan2(1,0)="; a.super_dump ();
	a = atan2 ( (super_precision) 0, (super_precision) -1);
	cout << "atan2(0,-1)="; a.super_dump ();
	a = atan2 ( (super_precision) -1, (super_precision) 0);
	cout << "atan2(-1,0)="; a.super_dump ();
	a = atan2 ( (super_precision) -1, (super_precision) 0);
	cout << "atan2(-1,0)="; a.super_dump ();
	a = atan2 ( (super_precision) 1, (super_precision) 1/2);
	cout << "atan2(1,1/2)="; a.super_dump ();
	a = atan2 ( (super_precision) 1, (super_precision) -1/2);
	cout << "atan2(1,-1/2)="; a.super_dump ();
	a = atan2 ( (super_precision) -1, (super_precision) 1/2);
	cout << "atan2(-1,1/2)="; a.super_dump ();
	a = atan2 ( (super_precision) -1, (super_precision) -1/2);
	cout << "atan2(-1,-1/2)="; a.super_dump ();

	cout << "\nhypot test:\n";
	a = hypot ( (super_precision) 3, (super_precision) 4);
	cout << "hypot(3,4)="; a.super_dump ();
	a = hypot ( 3, (super_precision) 4);
	cout << "hypot(int3,4)="; a.super_dump ();

	cout << "\nmax,min tests:\n";
	a = max ( (super_precision) 1, 2);
	cout << "max(1,2)="; a.super_dump ();
	a = min ( (super_precision) 1, 2);
	cout << "min(1,2)="; a.super_dump ();

	cout << "\nnthrt, cbrt tests:\n";
	a = 350000;
	b = nthrt ( a, 5);
	cout << "5throot(350000)="; b.super_dump ();
	b = pow ( b, 5);
	cout << "^5="; b.super_dump ();
	a = -200;
	b = cbrt ( a);
	cout << "cuberoot(-200)="; b.super_dump ();
	b = b * b * b;
	cout << "^3="; b.super_dump ();

	cout << "\nfrexp, ldexp tests:\n";
	a = frexp ( - pi (), i);
	cout << "exponent of -pi=" << i << endl;
	cout << "fraction="; a.super_dump ();
	a = pi ();
	a = -pow ( a, 10);
	cout << "a="; a.super_dump ();
	b = ldexp ( a, 300);
	cout << "b="; b.super_dump ();

	cout << "\nbase conversion from native base to 8 and back again:\n";
	b = -152;  // 67;
	cout << "-152'nativebase="; b.super_dump ();
	a = base_conv ( b, 8, TRUE);
	cout << "-152'8="; a.super_dump ();
	b = base_conv ( a, 8, FALSE);
	cout << "-152'nativebase="; b.super_dump ();

	cout << "\nsuper_precision =double (exact) assignment:\n";
	dd = sqrt ( 2.0);
	cout << "dd=" << setprecision ( 60) << dd << endl;
	a = dd;
	cout << "a(exact)="; a.super_dump ();

	cout << "\nconstructor (double) test:\n";
	super_precision xyz = 1 / 3.0;
	cout << "xyz=1/3="; xyz.super_dump ();
	xyz = (super_precision) ( 1 / 262144.0);
	cout << "1/262144.0="; xyz.super_dump ();
	dd = super_to_double ( xyz);
	cout << "ditto(double)=" << dd << endl;

	cout << "\nrint test:\n";
	b = rint ( -pi ());
	cout << "rint(-pi)="; b.super_dump ();
	b = rint ( (super_precision) 0.1);
	cout << "rint(.1)="; b.super_dump ();
	b = rint ( (super_precision) 0.5);
	cout << "rint(.5)="; b.super_dump ();
	b = rint ( (super_precision) -1.5);
	cout << "rint(-1.5)="; b.super_dump ();

	cout << "\nround_off test:\n";
	a = pi ();
	cout << "pi="; a.super_dump ();
	b = round_off ( a, 33);
	cout << "pi{32}="; b.super_dump ();
	b = round_off ( a, 36);
	cout << "pi{36}="; b.super_dump ();
	b = round_off ( a, 60);
	cout << "pi{60}="; b.super_dump ();

	cout << "\nsuper_output test:\n";
	cout << super_output ( (super_precision) 0, i) << endl;

	cout << "\ntest of overloaded insertion operator <<:\n";
	super_precision :: std_ios_manip = FALSE;
	cout << setprecision ( 6);
	cout << (super_precision) 0 << endl;
	cout << "pi*1000=\n" << pi () * 1000 << endl;
	cout << "pi*10^21=\n" << pi () * pow ( (super_precision) 10, 21) <<endl;
	cout << "pi*10^200=\n"<< pi () * pow ( (super_precision) 10,200) <<endl;
	cout << "pi/1000=\n" << pi () / 1000 << endl;
	a = pow ( (super_precision) 10, -21);
	cout << "pow(-21)="; a.super_dump ();
	cout << "pi*10^-21=\n" << pi () * pow ( (super_precision) 10,-21)<<endl;
	cout << "pi*10^-200=\n"<< pi () *pow ( (super_precision) 10,-200)<<endl;
	cout << "-pi*1000=\n" << -pi () * 1000 << endl;
	cout << "-pi*10^21=\n" << -pi () *pow ( (super_precision) 10, 21)<<endl;
	cout << "-pi*10^200=\n"<< -pi () *pow ( (super_precision) 10,200)<<endl;
	cout << "-pi/1000=\n" << -pi () / 1000 << endl;
	cout << "-pi*10^-21=\n" << -pi()*pow ( (super_precision) 10,-21) <<endl;
	cout << "-pi*10^-200=\n"<< -pi()*pow ( (super_precision) 10,-200)<<endl;

	cout << "\nnonstd ios manip:\n";
	super_precision :: std_ios_manip = FALSE;
	cout << "1.23456789e3=" << (super_precision) 1.23456789e3 << endl;

	cout << "\nstd ios manip:\n";
	super_precision :: std_ios_manip = TRUE;
	cout << "zero=" << (super_precision) 0 << endl;
	cout << "1.23456789e3=" << (super_precision) 1.23456789e3 << endl;
	cout << "float format:\n";
	cout << "1.23456789e3=" << 1.23456789e3 << endl;
	dd = 1.2345e0;
	cout << dd << " " << (super_precision) dd << endl;
	dd /= 10;
	cout << dd << " " << (super_precision) dd << endl;
	dd /= 10;
	cout << dd << " " << (super_precision) dd << endl;
	dd /= 10;
	cout << dd << " " << (super_precision) dd << endl;
	dd /= 10;
	cout << dd << " " << (super_precision) dd << endl;
	dd /= 10;
	cout << dd << " " << (super_precision) dd << endl;
	dd = 1.2345e0;
	cout << dd << " " << (super_precision) dd << endl;
	dd *= 10;
	cout << dd << " " << (super_precision) dd << endl;
	dd *= 10;
	cout << dd << " " << (super_precision) dd << endl;
	dd *= 10;
	cout << dd << " " << (super_precision) dd << endl;
	dd *= 10;
	cout << dd << " " << (super_precision) dd << endl;
	dd *= 10;
	cout << dd << " " << (super_precision) dd << endl;
	dd *= 10;
	cout << dd << " " << (super_precision) dd << endl;
	dd = 1e-20;
	cout << "\nShow base:\n";
	super_precision :: show_output_base = TRUE;
	cout << dd << " " << (super_precision) dd << endl;
	super_precision :: std_ios_manip = FALSE;
	cout << "1.23456789e3=" << (super_precision) 1.23456789e3 << endl;
	cout << "std ios manip:\n";
	super_precision :: std_ios_manip = TRUE;
	cout << "zero=" << (super_precision) 0 << endl;
	cout << "1.23456789e3=" << (super_precision) 1.23456789e3 << endl;
	cout << "float format:\n";
	cout << "1.23456789e3=" << 1.23456789e3 << endl;
	dd = 1.2345e0;
	cout << dd << " " << (super_precision) dd << endl;
	super_set_output_base ( 8);
	cout << "Set output base to 8:\n";
	super_precision :: std_ios_manip = FALSE;
	cout << "1.23456789e3=" << (super_precision) 1.23456789e3 << endl;
	cout << "std ios manip:\n";
	super_precision :: std_ios_manip = TRUE;
	cout << "zero=" << (super_precision) 0 << endl;
	cout << "1.23456789e3=" << (super_precision) 1.23456789e3 << endl;
	cout << "float format:\n";
	cout << "1.23456789e3=" << 1.23456789e3 << endl;
	dd = 1.2345e0;
	cout << dd << " " << (super_precision) dd << endl;
	super_set_output_base ( 0);

	cout << "\nTest ++ and -- operators:\n";
	a = 5;
	b = a++;
	cout << "a++="; a.super_dump ();
	cout << "b="; b.super_dump ();
	b = ++a;
	cout << "++a="; a.super_dump ();
	cout << "b="; b.super_dump ();
	b = a--;
	cout << "a--="; a.super_dump ();
	cout << "b="; b.super_dump ();
	b = --a;
	cout << "--a="; a.super_dump ();
	cout << "b="; b.super_dump ();

	cout << "\nArray test:\n";
	super_precision array [10];
	array [0] = 0;
	for ( i = 1; i < 10; i++)
	{
		array [i] = i + array [i-1];
		array [i].super_dump ();
	}
	
	cout << "\nNon-default radix output roundoff test:\n";
	a = (super_precision) 1 / 5;
	super_precision :: std_ios_manip = FALSE;
	cout << "a=1/5<10>=" << a << endl;
	super_set_output_base ( 8);
	cout << "a=<8>=" << a << endl;
	super_set_output_count ( 14);
	cout << "14digits=" << a << endl;
	super_set_output_base ( 16);
	cout << "a=<16>=" << a << endl;
	cout << "14digits=" << a << endl;
	super_set_output_count ( 0);
	super_set_output_base ( 8);
	cout << "alldigits=" << a << endl;
	super_set_output_base ( 16);
	cout << "alldigits=" << a << endl;
	super_set_output_base ( 0);
	super_precision :: std_ios_manip = TRUE;

	cout << "\nOverload >> test:\n";
	cin >> setiosflags ( ios::skipws);
	cout << "standard ios manipulators = " << cin.flags () << endl;
	do {
	cout << "Enter a number (0 = quit loop):\n";
	cin >> a;
	cout << "a=" << a << endl;
	} while ( a != 0);
	cin >> resetiosflags ( ios::skipws);
	cout << "standard ios manipulators = " << cin.flags () << endl;
	do {
	cout << "Enter a number (0 = quit loop):\n";
	cin >> a;
	cout << "a=" << a << endl;
	} while ( a != 0);
	super_precision :: std_ios_manip = FALSE;
	cin >> setiosflags ( ios::skipws);
	cout << "non-standard ios manipulators = " << cin.flags () << endl;
	do {
	cout << "Enter a number (0 = quit loop):\n";
	cin >> a;
	cout << "a=" << a << endl;
	} while ( a != 0);
	cin >> resetiosflags ( ios::skipws);
	cout << "non-standard ios manipulators = " << cin.flags () << endl;
	do {
	cout << "Enter a number (0 = quit loop):\n";
	cin >> a;
	cout << "a=" << a << endl;
	} while ( a != 0);
	super_precision :: std_ios_manip = TRUE;

	cout << "Test increment/decrement mantissa:" << endl;
	b = 1;
	b.decrement_mantissa ();
	cout<<"decremented b="; b.super_dump ();
	b.decrement_mantissa ();
	cout<<"decremented b="; b.super_dump ();
	b.increment_mantissa ();
	cout<<"incremented b="; b.super_dump ();
	b.increment_mantissa ();
	cout<<"incremented b="; b.super_dump ();
	b.increment_mantissa ( 22);
	cout<<"incremented b="; b.super_dump ();
	b.decrement_mantissa ( 30);
	cout<<"decremented b="; b.super_dump ();

	cout << "Test get/put digit:" << endl;
	a = 1 / (super_precision) 7;
	a.super_dump ();
	cout << "Getting 0'th digit=" << a.get_digit ( 0) << endl;
	cout << "Putting 0'th digit=" << 7 << endl;
	a.put_digit ( 0, 7);
	a.super_dump ();
	cout << "Getting 22'nd digit=" << a.get_digit ( 22) << endl;
	cout << "Putting 22'nd digit=" << 7 << endl;
	a.put_digit ( 22, 7);
	a.super_dump ();
	cout << "Getting -1'nd digit=" << a.get_digit ( -1) << endl;
	cout << "Putting -1'nd digit=" << 7 << endl;
	a.put_digit ( -1, 7);
	a.super_dump ();
	cout << "Getting -11'nd digit=" << a.get_digit ( -11) << endl;
	cout << "Putting -11'nd digit=" << 7 << endl;
	a.put_digit ( -11, 7);
	a.super_dump ();

	ofstream outfile;
	outfile.open ( "scratch", ios::out, 0);
	cout<<"Opened file named scratch"<<endl;
	outfile << a << " " << b << " " << c << endl;
	outfile.close ();
	cout<<"wrote a,b,c to scratch"<<endl;
	cout << "a="; a.super_dump ();
	cout << "b="; b.super_dump ();
	cout << "c="; c.super_dump ();
	ifstream infile;
	infile.open ( "scratch", ios::in, 0);
	infile >> a >> b >> c;
	a.super_dump ();
	b.super_dump ();
	c.super_dump ();
	infile.close ();

	cout << "Goodbye, super world.\n";
}
