
/*
	TIME.CPP
	Created 1995 by Dejvid Zaninovic
*/

#include <dos.h>
#include <bios.h>
#include "c.hpp"
#include "time.hpp"
#include "system.hpp"


/*
	xtime::xtime();

	- init time to 00:00:00
*/

xtime::xtime() 
{
	xtime::set();
}


/*
	xtime::xtime (byte hour, byte minute, double second, byte day);

	- init all
*/

xtime::xtime (byte hour, byte minute, double second, byte day)
{
	if (!xtime::set (hour, minute, second, day))
		xtime::set();
}


/*
	~xtime();								

	- deinstall all
*/

xtime::~xtime()
{
	stop();
}


/*
	double xtime::getsecond() const;

	- return second
*/

double xtime::getsecond() const
{
	return second + ms * .000001;
}


/*
	byte xtime::sethour (byte n);

	- set hour, return hour
	- on error return 24
*/

byte xtime::sethour (byte n) 
{					 
	if (n < 24) {
		hour = n;
		return n;
	} else
		return 24;
}


/*
	byte xtime::setminute (byte n);

	- set minute, return minute
	- on error return 60
*/

byte xtime::setminute (byte n) 
{
	if (n < 60) {
		minute = n;
		return n;
	} else
		return 60;
}


/*
	double xtime::setsecond (double n);

	- set second, return second
	- on error return 60
*/

double xtime::setsecond (double n) 
{				 
	if (n < 60) {
		second = (byte) n;
		ms = n - second;
		return n;
	} else
		return 60;
}


/*
	boolean xtime::set (byte hour, byte minute, double second, byte day);

	- set hour, minute, second and day
*/

boolean xtime::set (byte hour, byte minute, double second, byte day)
{
	if (::istime (hour, minute, second)) {
		xtime::hour = hour;
		xtime::minute = minute;
		setsecond (second);
		xtime::day = day;
		return TRUE;
	} else
		return FALSE;
}


/*
	boolean istime (byte hour, byte minute, double second);

	- is time correct
*/

boolean istime (byte hour, byte minute, double second)
{
	if ((hour < 24) && (minute < 60) && (second < 60))
		return TRUE;
	else
		return FALSE;
}


/*
	double xtime::tton() const;

	- return seconds from time
*/

double xtime::tton() const
{
	return (dword)day * 86400 + (dword)hour * 3600 + (word)minute * 60 + getsecond();
}


/*
	xtime xtime::ntot (double n);

	- set time from numeric
*/

xtime xtime::ntot (double n)
{
	day = n / 86400;
	n -= 86400l * day;

	hour = n / 3600;
	n -= 3600l * hour;

	minute = n / 60;
	n -= 60 * minute;

	setsecond (n);

	return *this;
}


/*
	xtime now();

	- get present time
*/

xtime now()
{
	xtime t;
	
	return t.now();
}


/*
	xtime xtime::now();

	- set time to now
*/

xtime xtime::now()
{
	long t;
	
	t = biostime (0, 0);
	ntot (double (biostime (0, 0)) / 18.2);

	return *this;
}


/*
	xtime xtime::operator + (double n);

	- add seconds to time
*/

xtime xtime::operator + (double n)
{
	return ntot (tton() + n);
} 


/*
	xtime xtime::operator - (double n);

	- sub seconds from time
*/

xtime xtime::operator - (double n)
{
	return ntot (tton() - n);
} 


/*
	long xtime::operator - (xtime t);

	- sub time from time
*/

long xtime::operator - (xtime t) 
{
	return tton() - t.tton();
} 


/*
	boolean xtime::operator > (xtime t) const;

	- compare times
*/

boolean xtime::operator > (xtime t) const
{
	return tton() > t.tton();
}


/*
	boolean xtime::operator < (xtime t) const;	

	- compare times
*/

boolean xtime::operator < (xtime t) const
{
	return tton() < t.tton();
}


/*
	boolean xtime::operator >= (xtime t1, xtime t2) const;

	- compare times
*/

boolean xtime::operator >= (xtime t) const
{
	return tton() >= t.tton();
}


/*
	boolean xtime::operator <= (xtime t) const;

	- compare times
*/

boolean xtime::operator <= (xtime t) const
{
	return tton() <= t.tton();
}


/*
	boolean xtime::operator == (xtime t) const;

	- compare times
*/

boolean xtime::operator == (xtime t) const
{
	return tton() == t.tton();
}


/*
	boolean xtime::operator != (xtime t) const;

	- compare times
*/

boolean xtime::operator != (xtime t) const
{
	return tton() == t.tton();
}


/*
	boolean xtime::start (boolean high)

	- start timer
    - if high is set to true, use high resolution timer with 1 ms
      precision else use 55 ms precision
    - high timer slows down computer for about 30 %
*/

boolean xtime::start (boolean high)
{
	stimer *t, *tnew;

	t = timer;

	while ((t != NULL) && (t->p != this) && (t->next != NULL))
		t = t->next;

	if (t->p == this)
		return FALSE;

	tnew = new stimer;
	disable();
	if (t != NULL)
		t->next = tnew;
	else
		timer = tnew;
	tnew->p = this;
    tnew->next = NULL;
	tnew->high = high;
	enable();

	if (!high && (old08 == NULL)) {
		old08 = getvect (8);
		setvect (8, xtime::new08);
	}

	if (high && (old70 == NULL)) {
		old70 = getvect (0x70);
		setvect (0x70, xtime::new70);
		enable70();
	}

	tnew->p->ms -= 977;
	return TRUE;
}


/*
	boolean xtime::stop()

	- stop timer
*/

boolean xtime::stop()
{
	stimer *t, *prev;
	boolean high;

	t = timer;
	prev = NULL;

	while (t->p != this) {
		prev = t;
		t = t->next;
		if (t->next == NULL)
			return FALSE;
	}

	disable();
	if (prev != NULL)
		prev->next = t->next;
	else
		timer = t->next;
	enable();
	high = t->high;
	delete t;

	t = timer;
	while ((t != NULL) && (t->next != NULL))
		if (t->high == high)
			return TRUE;

	if (!high) {
		setvect (8, old08);
		old08 = NULL;
	} else {
		disable70();
		setvect (70, old70);
		old70 = NULL;
	}

	return TRUE;
}


/*
	void interrupt xtime::new08();

	- new int 08
*/

void interrupt xtime::new08()
{
	stimer *t;

	old08();
	t = timer;
	while (t != NULL) {
		if (!t->high)
			t->p->addms (55000);
		t = t->next;
	}
}


/*
	void interrupt xtime::new70();

	- new int 70
*/

void interrupt xtime::new70()
{
	stimer *t;

	old70();
	t = timer;
	while (t != NULL) {
		if (t->high)
			t->p->addms (977);
		t = t->next;
	}

}


/*
	dword xtime::addms (dword nms);

	- add microseconds without use of floating point, for call from 
	  interrupts
*/

dword xtime::addms (dword nms)
{
	dword n;

	ms += nms;

	if (ms >= 1000000) {
		second++;
		ms -= 1000000;
	}

	n = (dword)day * 86400 + hour * 3600 + (word)minute * 60 + second;

	day = n / 86400;
	n -= 86400l * day;

	hour = n / 3600;
	n -= 3600l * hour;

	minute = n / 60;
	n -= 60 * minute;

	second = n;

	return nms;
}
