
/*
	SYSTEM.CPP
	Created 1995 by Dejvid Zaninovic
*/

#include <bios.h>
#include <string.h>
#include <alloc.h>
#include <dos.h>
#include <stdlib.h>
#include <dir.h>
#include <ctype.h>
#include <stdio.h>
#include "c.hpp"
#include "misc.hpp"
#include "system.hpp"


/*
	int getboot (int drive, struct boot *boot);

	- get boot info into struct boot of bios drive
	- return 0 if ok
	- bios drive
*/

int getboot (int drive, struct boot *boot)
{
	int err;
	char *buf;

	buf = (char *) malloc (0x200);
	if (buf == NULL)
		error (E_NOMEM);
	if ((err = absread (drive, 1, 0, buf)) == 0) {
		memcpy (&boot->sectorsize, &buf[0xb], 2);
		boot->clustersize = buf[0xd];
		memcpy (&boot->reservedsectors, &buf[0xe], 2);
		boot->fatcnt = buf[0x10];
		memcpy (&boot->rootsize, &buf[0x11], 2);
		memcpy (&boot->totalsectors, &buf[0x13], 2);
		boot->media = buf[0x15];
		memcpy (&boot->fatsize, &buf[0x16], 2);
		memcpy (&boot->tracksize, &buf[0x18], 2);
		boot->heads = buf[0x1a];
		memcpy (&boot->hiden, &buf[0x1b], 2);
		memcpy (&boot->oem, &buf[0x3], 8);
		boot->oem[8] = 0;
		boot->extsign = buf[0x26];
		memcpy (&boot->serial, &buf[0x27], 4);
		memcpy (&boot->label, &buf[0x2b], 11);
		boot->label[11] = 0;
		memcpy (&boot->sysid, &buf[0x36], 8);
		boot->sysid[8] = 0;
		memcpy (&boot->total, &buf[0x20], 4);
		memcpy (&boot->num, &buf[0x24], 2);
	}
	free (buf);
	return err;
}


/*
	int biosver (date &d)

	- get bios date at F000:FFF5 in dos.h struct date
	- return year
*/

int biosver (date &d)
{
	char far *p = (char far *) MK_FP (0xf000, 0xfff5);
	char tmp [3];

	tmp [2] = 0;
	tmp [0] = *p;
	tmp [1] = *(p+1);
	d.da_mon = atoi (tmp);
	tmp [0] = *(p+3);
	tmp [1] = *(p+4);
	d.da_day = atoi (tmp);
	tmp [0] = *(p+6);
	tmp [1] = *(p+7);
	d.da_year = atoi (tmp);
	return d.da_year;
}


/*
	unsigned machid()

	- return machine id at F000:FFFE
*/

unsigned machid()
{
	return *((unsigned char far *) MK_FP (0xf000, 0xfffe));
}


/*
	void icaget (char *buf)

	- put 16 bytes from Intra-application Communications Area to buf
*/

void icaget (char *buf)
{
	char far *ica = (char far *) MK_FP (0x0040, 0x00f0);
	int a;

	for (a=0; a<16; a++)
		*(ica+a) = *(buf+a);
}


/*
	void icaput (char *buf)

	- put 16 bytes from buf to Intra-application Communications Area
*/

void icaput (char *buf)
{
	char far *ica = (char far *) MK_FP (0x0040, 0x00f0);
	int a;

	for (a=0; a<16; a++)
		*(buf+a) = *(ica+a);
}


/*
	boolean drvready (int drv);	

	- da li je drive drv spreman za citanje
	- bios drive
*/

boolean drvready (int drv)
{
	char *buf;
	int ret, a;
	
	buf = (char *) malloc (0x200);
	a = 0;
	do {
		ret = biosdisk (BIOS_VERIFY, drv, 0, 0, 1, 1, buf);
		a++;
	} while (a<=3 && ret!=0);
	if (ret == 0) 
		ret = TRUE;
	else 
		ret = FALSE;
	free (buf);
	return ret;
}


/*
	boolean drvwrite (int drv);	

	- da li je na drive drv moguce pisanje 
	- bios drive
*/

boolean drvwrite (int drv)
{
	char *buf;
	int ret, a;
	
	buf = (char *) malloc (0x200);
	a = 0;
	do
	{
		ret = biosdisk (BIOS_READ, drv, 0, 0, 1, 1, buf);
		a++;
	} while (a<=3 && ret!=0);
	if (ret == 0) {
		ret = biosdisk (BIOS_WRITE, drv, 0, 0, 1, 1, buf);
		if (ret != 0) 
			ret = FALSE;
		else
			ret = TRUE;
	}
	else
		ret = FALSE;
	free (buf);
	return ret;
}


/*
	long getdiskfree (int drv);		

	- koliko je byteova slobodno na disku 
	- dos drive
	- return -1 ako je krivi drv
*/

long getdiskfree (int drv)
{
	REGS r;

	r.h.ah = 0x36;
	r.h.dl = drv;
	intdos (&r, &r);
	if (r.x.ax == 0xffff)
		return -1;
	return (long) r.x.ax * (long) r.x.bx * (long) r.x.cx;
}


/*
	void filedel (char fname[])

	- obrisi sve sa maskom fname bez obzira na atribut 
*/

void filedel (char fname[])
{
	ffblk ff;
	boolean done;
	char path [MAXPATH];
	char drive [MAXDRIVE];
	char dir [MAXDIR];
	char name [MAXFILE];
	char ext [MAXEXT];

	done = findfirst (fname, &ff, FA_ALL);
	while (!done) {
		fnsplit (fname, drive, dir, name, ext);
		strcpy (path, drive);
		strcat (path, dir);
		strcat (path, ff.ff_name);
		_chmod (path, 1, FA_NORMAL);
		unlink (path);
		done = findnext (&ff);
	}
}


/*
	int truename (char fname[])
	
	- transforms a filename into a full reduced filename,
	  resolves all SUBST's, JOIN's, network names,...
	- return 0 if ok
	- sizeof (fname) = 128
*/

int truename (char fname[])
{
	REGS r;
	SREGS sr;
	int ret;

	sr.ds = FP_SEG (fname);
	r.x.si = FP_OFF (fname);
	sr.es = FP_SEG (fname);
	r.x.di = FP_OFF (fname);
	r.h.ah = 0x60;
	ret = intdosx (&r, &r, &sr);
	if (r.x.cflag) 
		return ret;
	return 0;
}


/*
	int setcwd (char dir[])

	- set directory across disks
	- return 0 if ok
*/

int setcwd (char dir[])
{
	char drive [MAXDRIVE];
	char buf [MAXPATH];
	int disk;

	fnsplit	(dir, drive, buf, buf, buf);
	if (*drive) {
		disk = toupper (*drive) - 'A';
		setdisk (disk);
		if (disk != getdisk())
			return -1;
	}
	if (chdir (dir) != 0) 
		return -1;
	return 0;
}


/*
	long filelength (FILE *f);

	- get file length
*/

long filelength (FILE *f)
{
	long pos, len;

	pos = ftell (f);
	fseek (f, 0L, SEEK_END);
	len = ftell (f);
	fseek (f, pos, SEEK_SET);
	return len;
}


/*
	long filelength (char name[]);

	- get file length
*/

long filelength (char name[])
{
	long len = -1;
	FILE *f;

	if ((f = fopen (name, "r")) != NULL) {
		len = filelength (f);
		fclose (f);
	}
	return len;
}


/*
	int dostobios (int drive);

	- dos to bios drive number translation
*/

int dostobios (int drive)
{
	if (drive > 1)
		drive += 0x80 - 2;
	return drive;
}


/*
	int biostodos (int drive);

	- bios to dos drive number translation
*/

int biostodos (int drive)
{
	if (drive >= 0x80)
		drive = drive - 0x80 + 2;
	return drive;
}


/*
	byte getcmos (byte n);					   

	- get cmos memory
*/

byte getcmos (byte m)
{
	byte d;

	disable();
	outportb (0x70, m);
	d = inportb (0x71);
	enable();

	return d;
}


/*
	byte setcmos (byte n);

	- set cmos memory
*/

byte setcmos (byte m, byte d)
{
	disable();
	outportb (0x70, m);
	outportb (0x71, d);
	enable();

	return d;
}


/*
	void enable70();

	- enable int 70
*/

void enable70()
{
	setcmos (0x0B, getcmos (0x0B) | BIT6);
	disable();
	outportb (0xA1, inportb (0xA1) & ~BIT0);
	enable();
}


/*
	void disable70()

	- disable int 70
*/

void disable70()
{
	setcmos (0x0B, getcmos (0x0B) & ~BIT6);
	disable();
	outportb (0xA1, inportb (0xA1) | BIT0);
	enable();
}
