
;
;	MOUSE.ASM
;	Created 1994 by Dejvid Zaninovic
;

IDEAL
INCLUDE "ASM.INC"

PUBLIC mouse_text, mouse_buttons

PUBLIC mouse_init, mouse_show, mouse_hide, mouse_button, mouse_push, 	\
	mouse_x, mouse_y, mouse_setxy, mouse_press, mouse_release, 			\
	mouse_range, mouse_gshape, mouse_tshape, mouse_distance, mouse_pen, \
	mouse_unpen, mouse_setspeed, mouse_getspeed, mouse_exclude, 		\
	mouse_setdoubling, mouse_getdoubling, mouse_statsize, mouse_getstat,\
	mouse_setstat, mouse_setrate, mouse_setpage, mouse_getpage, 		\
	mouse_disable, mouse_enable, mouse_reset, mouse_getver,				\
	mouse_gettype, mouse_getirq

CODESEG

mouse_text		DW		TRUE			; text or graph mode
mouse_buttons	DW		0				; how many buttons


;
;	boolean mouse_init();
;
;	Resets the mouse
;	mouse_buttons = number of mouse buttons on mouse
;	return TRUE if mouse driver installed
;
;	It performs a hardware and software reset (see mouse_reset for a way
;	to performs just a software reset). 
;
;	For text-mode applications, this function does the following:
;
;	Moves the mouse pointer to the center of the screen
;	Hides the pointer (use mouse_show to display it).
;	Clears any "exclusion area" set via mouse_exclude.
;	Sets the pointer mask to the default: inverse-attribute of character at
;	  	pointer (use mouse_tshape to change the appearance of the pointer).
;	Sets the range to the height and width of the entire screen (use 
;		mouse_range or mouse_exclude to limit the mouse pointer display area).
;	Sets up for pointer drawing on video page 0 (see mouse_setpage).
;	Enables Lightpen emulation (see mouse_pen and mouse_unpen).
;	Sets pointer speed ratio to horizontal: 8 to 8; vertical 8 to 16 and sets
;	  	the maximum doubling threshold to 64 mickeys.
;

PROC		mouse_init
			
			XOR AX,AX
			INT 33
			MOV [CS:mouse_buttons],BX
			OR AX,AX
			JE @@J1
			MOV AX,TRUE
@@J1:
			RET
ENDP


;
;	void mouse_show();
;
;	Show mouse pointer
;
;	This increments an internal counter used by the mouse support to 
;	determine when to show the pointer.  That counter starts as -1 
;	(after a mouse_init).  This call increments it to 0.  Whenever the 
;	counter is 0, the mouse pointer is displayed and tracked on-screen.  
;	Subsequent calls (when the counter is 0) are ignored.  Calls to 
;	mouse_hide decrement the counter.
; 	This logic relieves programs of the burden of global tracking of the
;	hidden/displayed state.  A subroutine may always use mouse_show at the
;	beginning and mouse_hide at the end, without affecting the shown/hidden 
;	state of the calling routine.
;	This function also resets the "exclusion area" set via mouse_exclude.
;

PROC 		mouse_show
			
			MOV AX,1
			INT 33

			RET
ENDP


;
;	void mouse_hide();
;
;	Hide mouse pointer
;
;	This removes the mouse pointer from the screen (if it is currently 
;	visible).  It actually decrements an internal pointer-display cursor.
;  	If that counter is 0 before the call, the mouse pointer is removed 
;	from the screen.
;	Use this function before performing any direct writes to the video 
;	display (if doing so will overwrite the mouse pointer) and call 
;	mouse_show after writing to the screen.  
;

PROC 		mouse_hide
			
			MOV AX,2
			INT 33

			RET
ENDP


;
;	ms_buttons mouse_buttons();
;
;	Get mouse button status
;	return which button is down
;

PROC 		mouse_button
			
			MOV AX,3
			INT 33
			MOV AX,BX

			RET
ENDP


;
;	boolean mouse_push();
;
;	Is any button pushed
;

PROC 		mouse_push
			
			MOV AX,3
			INT 33
			MOV AX,BX
			OR AX,AX
			JZ @@1
			MOV AX,TRUE
@@1:
			RET
ENDP


;
;	word mouse_x();
;
;	Get current position of the mouse x pointer coordinate
;

PROC 		mouse_x
			
			MOV AX,3
			INT 33
			MOV AX,CX
			CMP [CS:mouse_text],TRUE
			JNE @@J1
			SHR AX,3
@@J1:
			INC AX
			RET
ENDP


;
;	word mouse_y();
;
;	Get current position of the mouse y pointer coordinate
;

PROC 		mouse_y
			
			MOV AX,3
			INT 33
			MOV AX,DX
			CMP [CS:mouse_text],TRUE
			JNE @@J1
			SHR AX,3
@@J1:
			INC AX
			RET
ENDP


;
;	void mouse_setxy (word x, word y);
;
;	Set mouse x and y coordinate
;

PROC 		mouse_setxy
ARG			x, y
			
			MOV AX,4
			MOV CX,[x]
			MOV DX,[y]
			CMP [CS:mouse_text],TRUE
			JNE @@J1
			SHL CX,3
			SHL DX,3
@@J1:
			DEC CX
			DEC DX
			INT 33

			RET
ENDP


;
;	void mouse_press (word button, word far *count, word far *x, word far *y);
;
;	Get press status
;	button - button to query (0 - left, 1 - right, 2 - center)
;	count - count of times that button was pressed since last call
;	x, y - coordinates at last press
;

PROC 		mouse_press
ARG			button, count:FAR PTR WORD, x:FAR PTR WORD, y:FAR PTR WORD
USES		DI
			
			MOV AX,5
			MOV BX,[button]
			INT 33
			LES DI,[count]
			MOV [ES:DI],BX
			CMP [CS:mouse_text],TRUE
			JNE @@J1
			SHR CX,3
			SHR DX,3
@@J1:
			INC CX
			INC DX
			LES DI,[x]
			MOV [ES:DI],CX
			LES DI,[y]
			MOV [ES:DI],DX

			RET
ENDP


;
;	void mouse_release (word button, word far *count, word far *x, word far *y);
;
;	Get release status
;	button - button to query (0 - left, 1 - right, 2 - center)
;	count - count of times that button was released since last call
;	x, y - coordinates at last release
;

PROC 		mouse_release
ARG			button, count:FAR PTR WORD, x:FAR PTR WORD, y:FAR PTR WORD
USES		DI
			
			MOV AX,6
			MOV BX,[button]
			INT 33
			LES DI,[count]
			MOV [ES:DI],BX
			CMP [CS:mouse_text],TRUE
			JNE @@J1
			SHR CX,3
			SHR DX,3
@@J1:
			INC CX
			INC DX
			LES DI,[x]
			MOV [ES:DI],CX
			LES DI,[y]
			MOV [ES:DI],DX

			RET
ENDP


;
;	void mouse_range (word x1, word y1, word x2, word y2);
;
;	Set range out of which the mouse pointer will not be able to move
;

PROC 		mouse_range
ARG			x1, y1, x2, y2
			
			MOV AX,7
			MOV CX,[x1]
			MOV DX,[x2]
			DEC CX
			DEC DX
			CMP [CS:mouse_text],TRUE
			JNE @@J1
			SHL CX,3
			SHL DX,3
@@J1:
			INT 33

			MOV AX,8
			MOV CX,[y1]
			MOV DX,[y2]
			DEC CX
			DEC DX
			CMP [CS:mouse_text],TRUE
			JNE @@J2
			SHL CX,3
			SHL DX,3
@@J2:
			INT 33

			RET
ENDP


;
;	void mouse_gshape (word x, word y, word far *s[]);
;
;	Set mouse graphics shape
;	x, y - hot spot
;	s - 0x20 16-bit rows AND mask, 0x20 16-bit rows XOR mask
;

PROC 		mouse_gshape
ARG			x, y, s:FAR PTR WORD
USES 		SI
			
			LES DX,[s]
			MOV AX,9
			MOV BX,[x]
			MOV CX,[y]
			DEC BX
			DEC CX
			INT 33

			RET
ENDP


;
;	void mouse_tshape (word type, word p1, word p2);
;
;	Set mouse text shape
;
;	type 0 - software pointer
;		p1 - AND attr under cursor with 
;		p2 - XOR p1 with
;
;	type 1: hardware pointer
;		p1 - start line
;		p2 - end line
;

PROC 		mouse_tshape
ARG			t, p1, p2
			
			MOV AX,0A
			MOV BX,[t]
			MOV CX,[p1]
			MOV DX,[p2]
			INT 33

			RET
ENDP


;
;	void mouse_distance (int *x, int *y);
;
;	Get distance of mouse before last call to this function in mickeys
;

PROC 		mouse_distance
ARG			x:FAR PTR WORD, y:FAR PTR WORD
USES 		DI
			
			MOV AX,0Bh
			INT 33
			LES DI,[x]
			MOV [ES:DI],CX
			LES DI,[y]
			MOV [ES:DI],DX

			RET
ENDP


;
;	void mouse_pen();
;
;	Enable lightpen emulation
;

PROC 		mouse_pen
			
			MOV AX,0Dh
			INT 33

			RET
ENDP


;
;	void mouse_unpen();
;
;	Disable lightpen emulation
;

PROC 		mouse_unpen
			
			MOV AX,0Eh
			INT 33

			RET
ENDP


;
;	void mouse_setspeed (word h, word v);
;
;	Set horizontal and vertical mouse speed
;

PROC 		mouse_setspeed
ARG			h, v
			
			MOV AX,0Fh
			MOV CX,[h]
			MOV DX,[v]
			INT 33

			RET
ENDP


;
;	void mouse_getspeed (word *h, word *v);
;
;	Get mouse vertical and horizontal speed
;

PROC 		mouse_getspeed
ARG			h:FAR PTR WORD, v:FAR PTR WORD
USES 		DI
			
			MOV AX,1Bh
			INT 33
			LES DI,[h]
			MOV [ES:DI],BX
			LES DI,[v]
			MOV [ES:DI],CX

			RET
ENDP


;
;	void mouse_exclude (word x1, word y1, word x2, word y2);
;
;	Set range out of which the mouse pointer will not be able to move
;

PROC 		mouse_exclude
ARG			x1, y1, x2, y2
USES 		SI, DI
			
			MOV AX,10
			MOV CX,[x1]
			MOV DX,[y1]
			MOV SI,[x2]
			MOV DI,[y2]
			DEC CX
			DEC DX
			DEC SI
			DEC DI
			CMP [CS:mouse_text],TRUE
			JNE @@J1
			SHR CX,3
			SHR DX,3
			SHR SI,3
			SHR DI,3
@@J1:
			INT 33

			RET
ENDP


;
;	void mouse_setdoubling (word limit);
;
;	Set speed-doubling
;

PROC 		mouse_setdoubling
ARG			limit
			
			MOV AX,13
			MOV DX,[limit]
			INT 33

			RET
ENDP


;
;	word mouse_getdoubling();
;
;	Get mouse doubling
;

PROC 		mouse_getdoubling
			
			MOV AX,1Bh
			INT 33
			MOV AX,DX

			RET
ENDP


;
;	word mouse_statsize();
;
;	- get size of mouse status
;

PROC 		mouse_statsize
			
			MOV AX,15
			INT 33
			MOV AX,BX

			RET
ENDP


;
;	void mouse_getstat (char far *buf);
;
;	Get mouse status
;

PROC 		mouse_getstat
ARG			buf:FAR PTR WORD
USES 		DI
			
			MOV AX,16
			LES DI,[buf]
			MOV DX,DI
			INT 33

			RET
ENDP


;
;	void mouse_setstat (char far *buf);
;
;	Set mouse status
;

PROC 		mouse_setstat
ARG			buf:FAR PTR WORD
USES 		DI
			
			MOV AX,17
			LES DI,[buf]
			MOV DX,DI
			INT 33

			RET
ENDP


;
;	void mouse_setrate (word rate);
;
;	Set interrupt rate 
;		1 - none
;		2 - 30 Hz
;		4 - 50 Hz
;		8 - 100 Hz
;		16 - 200 Hz
;

PROC 		mouse_setrate
ARG			rate
			
			MOV AX,1C
			MOV BX,[rate]
			INT 33

			RET
ENDP


;
;	void mouse_setpage (word page);
;
;	Set page number to display mouse cursor
;

PROC 		mouse_setpage
ARG			page
			
			MOV AX,1D
			MOV BX,[page]
			INT 33

			RET
ENDP


;
;	word mouse_getpage();
;
;	Get page number upon which mouse cursor is displayed
;

PROC 		mouse_getpage
			
			MOV AX,1E
			INT 33
			MOV AX,BX

			RET
ENDP


;
;	boolean mouse_disable (void far *adr);
;
;	Deactivate mouse driver and get adress of previous handler
;

PROC 		mouse_disable
ARG			adr:FAR PTR WORD
USES		DS, DI
			
			MOV AX,1F
			INT 33
			LDS DI,[adr]
			MOV [DS:DI],DX
			MOV [DS:DI+2],ES
			CMP AX,1F
			JNE @@1
			MOV AX,TRUE
			JMP @@2
@@1:
			MOV AX,FALSE
@@2:
			RET
ENDP


;
;	void mouse_enable();
;
;	Activate mouse driver
;

PROC 		mouse_enable
			
			MOV AX,20
			INT 33

			RET
ENDP


;
;	boolean mouse_reset();
;
;	Reset mouse driver
;

PROC 		mouse_reset
			
			MOV AX,21
			INT 33
			CMP AX,21
			JNE @@1
			MOV AX,TRUE
			JMP @@2
@@1:
			MOV AX,FALSE
@@2:
			RET
ENDP


;
;	void mouse_getver (byte *major, byte *minor);
;
;	Get version
;

PROC 		mouse_getver
ARG			major:FAR PTR BYTE, minor:FAR PTR BYTE
USES		DI
			
			MOV AX,24
			INT 33
			LES DI,[major]
			MOV [ES:DI],BH
			LES DI,[minor]
			MOV [ES:DI],BL

			RET
ENDP


;
;	byte mouse_gettype();
;
;	Get mouse type
;

PROC 		mouse_gettype
			
			MOV AX,24
			INT 33
			MOV AL,CH

			RET
ENDP


;
;	byte mouse_getirq();
;
;	Get mouse IRQ number
;

PROC 		mouse_getirq
			
			MOV AX,24
			INT 33
			MOV AL,CL

			RET
ENDP

END
