/*
**  int segment  = dosalloc(long bufferlength)
**  int ok       = dosfree(segment)
*/


#include <dos.h>

/*
** allocate a new buffer for (long) bufflen bytes
** return -1 if not success
** else return bufferdescriptor (int)
*/

void far * dosalloc(long);
int        dosfree(void far *);

void far *dosalloc(length)
long length;
    {
    union REGS ir;
    ir.x.ax = 0x4800;
    ir.x.bx = (length+15)>>4;
    intdos(&ir, &ir);
    if (ir.x.ax < 10)                   /* fehlermeldungen : eigentlich CARRY */
        return 0;
    return (void far *)((long)ir.x.ax<<16);
    }

void far *dosrealloc(seg,length)
long length;
void far *seg;
    {
    union REGS ir;
    struct SREGS sr;
    ir.x.ax = 0x4a00;
    ir.x.bx = (length+15)>>4;
    sr.es = FP_SEG(seg);

    intdosx( &ir, &ir, &sr);
    if (ir.x.ax < 10)                   /* fehlermeldungen : eigentlich CARRY */
        return 0;
    return (void far *)((long)ir.x.ax<<16);
    }


int dosfree(seg)
void far *seg;
    {
    union REGS ir;
    struct SREGS sr;
    ir.x.ax = 0x4900;
    sr.es = FP_SEG(seg);

    intdosx( &ir, &ir, &sr);

    return ir.x.ax;
    }
