#include <dos.h>
#include <stdio.h>

#define BYTE unsigned char
#define WORD unsigned int

char tbuf[4096];
char copyr[] = "HiTerm   memory resident terminal program\
	Version 2.2   04-09-87\n\
Copyright (c) Hans Irtel & Karl Gegenfurtner\n";

main(argc, argv)
int argc;
char **argv;
{
   char *tfile;
   unsigned char linepar = 227;
   unsigned char fg = 0x74;
   unsigned char bg = 0x47;
   unsigned int port = 2;
   unsigned int sw = 0x3400;
   int i, baud, stop, word;
   int td, tlen;
   char parity;
   BYTE getlpar();
   WORD getcode();

   printf(copyr);
   printf("\nInstallation procedure\n");
   if (argc > 1)
	  tfile = argv[1];
   else
	  tfile = "term.com";

   if ((td = open(tfile, 0x8000)) == -1) {
	  printf("File %s not found\n", tfile);
	  exit(1);
   }
   tlen = read(td, tbuf, 4096);
   close(td);

   printf("Installing file %s\n", tfile);

	/*
	 * get the comm port
	 */

l1:
   printf("\nWhat comm port are you using (1 or 2) ? ");
   scanf("%d", &i);
   if (i == 1 || i == 2)
	  port = i;
   else {
	  printf("illegal port number, try again");
	  goto l1;
   }

   /*
	* get line parameters
	*/
   
   printf("Enter baudrate: "); scanf("%d", &baud);
   printf("Parity 0 (even) 1 (odd) other values (no): "); scanf("%d", &parity); 
   if (parity == 0) 
	  parity = 'e';
   else if (parity == 1) 
	  parity = 'o';
   else 
	  parity = 'n';
   printf("Word length: ");      scanf("%d", &word);
   printf("Stop bits: ");        scanf("%d", &stop);
   linepar = getlpar(baud, stop, word, parity);

   /*
	* get colors
	*/

   drawcolors();
   printf("Normal Video Color: "); scanf("%d", &fg);
   printf("Reverse Video Color: "); scanf("%d", &bg);

   /*
	* get hotkey
	*/

   printf("Press the key with which to activate term: ");
   sw = getcode();

   /*
	* now patch it
	*/

	tbuf[3] = fg;
	tbuf[4] = bg;
	tbuf[5] = port;
	tbuf[7] = linepar;
	tbuf[8] = (BYTE)(sw & 0xff);
	tbuf[9] = (BYTE)(sw >> 8);

   /*
	* and write it back
	*/
   if ((td = open(tfile, 0x8001)) < 0) {
	  printf("cannot open %s for writing\n", tfile);
	  exit(1);
   }
   write(td, tbuf, tlen);
   close(td);
   printf("\nInstallation complete");

   return(0);
}

drawcolors()
{
   WORD i;
   WORD col, row;

   printf ("\033[J");
   set_cur(0);
   for (i=0,row=0; row<8; row++) {
	   for (col=0; col<16; col++,i++)
		   wr_color(i);
	   nextline();
   }
   nextline();
   nextline();
}


#define NBAUDS	8
static struct baudT {
	WORD rate;
	BYTE pat;
} bT [NBAUDS] = {
  110, 0,
  150, 1,
  300, 2,
  600, 3,
  1200, 4,
  2400, 5,
  4800, 6,
  9600, 7
};

BYTE getlpar(b, s, w, p )
WORD b;
BYTE p, s, w;
{
    int i;
	BYTE actual_pars;

	actual_pars = 0;
	for (i=0; i<NBAUDS; i++)
	   if (bT[i].rate == b) {
			actual_pars &= 31;
			actual_pars |= bT[i].pat << 5;
		}
	actual_pars &= 231;
  	if (p == 'o')
		actual_pars |= 32;
	else if (p == 'e')
		actual_pars |= 96;
	actual_pars &= 251;
	actual_pars |= (s-1) << 2;
	actual_pars &= 252;
	actual_pars |= w - 5;
	return (actual_pars);
}

WORD getcode()
{
   WORD ch, key_get();
   BYTE scan, ascii;
   union REGS kr;

   kr.h.ah = 0;
   int86(0x16, &kr, &kr);
   return kr.x.ax;
}


#define intr(n, r)  int86(n, r, r)
#define VIDEO 	0x10

WORD cur_page()
{
   union REGS vr;

   vr.h.ah = 0x0f;
   intr(VIDEO, &vr);
   return(vr.h.bh);
}
   
set_cur(xy)
WORD xy;
{
   union REGS vr;
   
   vr.h.bh = cur_page();
   vr.h.ah = 0x02;
   vr.x.dx = xy;
   intr(VIDEO, &vr);
}

WORD get_cur()
{
   union REGS vr;

   vr.h.bh = cur_page();
   vr.h.ah = 0x03;
   intr(VIDEO, &vr);
   return (vr.x.dx);
}		    
 
ch_out(c, c_attr)
BYTE c, c_attr;
{
  union REGS vr;

  vr.h.ah = 0x09;
  vr.h.al = c;
  vr.h.bl = c_attr;
  vr.h.bh = cur_page();
  vr.x.cx = 1;
  intr(VIDEO, &vr);
}

wrtty(c)
BYTE c;
{
   union REGS vr;

   vr.h.ah = 0x0e;
   vr.h.al = c;
   vr.h.bh = cur_page();
   intr(VIDEO, &vr);
}

wr_color(i)
WORD i;
{
   char str[4];
   int j;
   WORD xy;

   str[0] = ' ';
   str[1] = i/100 + '0';
   str[2] = (i%100)/10 + '0';
   str[3] = i % 10 + '0';
   for (j=0; j<4;j++) {
	   ch_out(str[j], i);
	   xy = get_cur();
	   set_cur(xy+1);
   }
}

nextline()
{
   WORD xy;

   xy = get_cur();
   set_cur((xy + 256)&0xff00);
}

