unit dosfax;

{ $DEFINE DEBUG} (* Chars from Modem to screen (remove space before $) *)
{ $DEFINE OUTLOG} (* Logdatei von SendChar *)

(* UNIT DosFax: Faxen unter DOS *)
(* Erstellt von:
   Stefan Cordes
   Am Kockshof 24
   40882 Ratingen
   02102 895 816
   Fax: 02102 895 816 (15:00-19:00 MEZ)
   e-mail: cordes@compuserve.com oder scordes@usa.net
   www: http://www.adr.de/Cordes/ *)

(* For documentation see: class2.txt, class2.htm and ccitt_t4.txt *)

{$S+} (* Stack checking *)
{$R-} (* No range check *)
{$Q-} (* No overflow check *)
{$V-} (* No strict VAR checking *)

interface

Procedure InitModem(comNr:Word;TelNr:String);

Procedure Dial(tp:char;nr:String);

Procedure Sendline(hstr:string);

procedure EndPage(MorePages:Boolean);

Const Version = 'DosFax 1.04 (Free-Ware)';

implementation

uses dos,crt;

const ModemPort:word=0;
      wartetick=60;

var ComPorts:Array[1..8] of Word absolute $40:0;

var tick:longint absolute $40:$6c;

Function hex(l:longint):String;
begin
  if l>=16 then
  begin
    hex := hex(l div 16)+hex(l mod 16);
  end
  else
  begin
    if l<10 then hex := chr(ord('0')+l)
            else hex := chr(ord('A')+l-10);
  end;
end;

{$IFDEF OUTLOG}
var outlog:file;
{$ENDIF}

Procedure initport(nr:Word);
var adr:Word;
begin
{$IFDEF OUTLOG}
  assign(outlog,'outlog.dat');
  rewrite(outlog,1);
{$ENDIF}
  adr := comports[nr];
  Port[adr+3]:= $0; {Dlab=0}
  delay(1);
  Port[adr+1] := 0; (* no int allowed *)
  delay(1);
  Port[adr+3]:=$80; {Dlab=1}
  delay(1);
  (* Set Baud *)
  port[adr+1] := 0;
  delay(1);
(*  port[adr] := 96; (* 1200 *)
  port[adr] := 12; (* 9600 *)
(*  port[adr] := 8; (* 14400 *)
(*  port[adr] := 4; (* 28800 *)
  delay(1);
  Port[adr+3]:=3; {Dlab=0, no parity, 1 stop, 8 data}
  delay(1);
  port[adr+4]:=3; (* MCR: DTR=1, RTS=1 *)
  delay(1);
end;

procedure TestCarrier;
Var MSR:Byte; (* Modem Status Reg *)
begin
  MSR := port[ComPorts[ModemPort]+6];
  if (MSR and $80)=0 then (* test again *)
  begin
    asm
        jmp @a  (* Wait a very little time *)
    @a: jmp @b
    @b:
    end;
    MSR := port[ComPorts[ModemPort]+6];
  end;
  if (MSR and $80)=0 then
  begin
    Writeln('Lost Carrier. ERRORLEVEL 6');
    halt(6);
  end;
end;

Procedure Sendchar(c:char);
Var LSR:Byte; (* Line Status Reg *)
begin
{$IFDEF OUTLOG}
  blockwrite(outlog,c,1);
{$ENDIF}
  repeat
    LSR := port[ComPorts[ModemPort]+5];
  until (LSR and $20+$40)=$20+$40;
  asm
      jmp @a  (* Wait a very little time *)
  @a: jmp @b
  @b: jmp @c
  @c:
  end;
  port[ComPorts[ModemPort]] := ord(c);
end;

function charavail:Boolean;
Var LSR:Byte;
begin
  LSR := port[ComPorts[ModemPort]+5];
  charavail := (LSR and $1)=1;
end;

function Getchar:char; (* Charavail has to be checked before *)
Var c:Char;
begin
  c := chr(port[ComPorts[ModemPort]]);
{$IFDEF DEBUG}
  highvideo;
  write(c);
(*  if ord(c)<32 then write('[',ord(c),']');*)
  lowvideo;
{$ENDIF}
  GetChar := c;
end;

Procedure SendStr(s:String);
var i1:Word;
begin
{$IFDEF DEBUG}
  delay(100);
  writeln;  writeln;
  writeln;  writeln;
  writeln;  writeln;
  writeln;  writeln;
  writeln;  writeln;
  writeln;  writeln;
  writeln;  writeln;
  gotoxy(wherex,wherey-12);
{$ELSE}
  delline;
{$ENDIF}
  write(s);
  delay(10);
  for i1 := 1 to length(s) do
  begin
    sendchar(s[i1]);
  end;
end;

function GetString:String;
var hstr:String;
    ende:Boolean;
    endzeit:longint;
    c:char;
begin
  hstr := '';
  endzeit := tick+40;
  ende := false;
  repeat
    if charavail then
    begin
      c := getchar;
      endzeit := tick+40;
      if (c=#13) and (hstr<>'') then ende := true;
      hstr := hstr+c;
      if length(hstr)>200 then ende := true; (* for safety *)
    end;
    if endzeit<tick then ende := true;
  until ende;
  getstring := hstr;
end;

Procedure Timeout;
var c:Char;
begin
  writeln('Modem timeout');
  if not keypressed then delay(1000);
  sendstr('+++');
  delay(1000);
  sendstr('ATH'+#13);
  delay(1);
  port[comports[ModemPort]+4]:=0; (* MCR: DTR=0, RTS=0 *)
  Writeln('ERRORLEVEL 10');
{$IFDEF OUTLOG}
  close(outlog);
{$ENDIF}
  halt(10);
end;

var fax_font:array[0..255] of array[1..16] of Byte; (* 8x16 *)

procedure open_font;
var exe,d,n,e:String;
    o,s,p:Word;
    f:file;
    ok:boolean;
    reg:registers;
begin
  write('Load characters: ');
  ok := false;
  s := memw[prefixseg:$2c];
  o := 0;
  repeat
    inc(o);
  until (mem[s:o]=0) and (mem[s:o+1]=0);
  inc(o,2);
  if memw[s:o]>0 then (* Kein String folgt dem Enviroment *)
  begin
    inc(o,2);
    exe := '';
    while (mem[s:o]<>0) and (length(exe)<255) do
    begin
      exe := exe+chr(mem[s:o]);
      inc(o);
    end;
    fsplit(fexpand(exe),d,n,e);
    assign(f,d+'fax_font.dat');
    {$I-} reset(f,1); {$I+}
    if ioresult = 0 then
    begin
      {$I-} blockread(f,fax_font,sizeof(fax_font)); {$I+}
      if ioresult=0 then
      begin
        ok := true;
        Writeln('Font ',d+'fax_font.dat loaded.');
      end;
      close(f);
    end;
  end;
  if not ok then (* VGA Zeichensatz nehmen *)
  begin
    reg.ax := $1130;
    reg.bh := $06;  (* 06h ROM 8x16 font (MCGA, VGA) *)
    intr($10,reg);
    move(ptr(reg.es,reg.bp)^,fax_font,16*256);
    Writeln('VGA-Font used: 06h ROM 8x16 font (MCGA, VGA)');
  end;
end;

Procedure InitModem(comNr:Word;TelNr:String);
var endzeit:Longint;
    hstr:String;
begin
  open_font;
  ModemPort := ComNr;
  Writeln('Init Com',comNr,' [',hex(Comports[modemport]),']');
  if (Comports[modemport]=0) or (comnr<1) or (comnr>8) then
  begin
    writeln('Port not available: ERRORLEVEL 20');
    halt(20);
  end;
  InitPort(modemport);
  while charavail do getchar;
  endzeit:=tick+WarteTick;
  sendstr('AT'+#13);
  repeat
    repeat
      if endzeit<tick then Timeout;
    until charavail;
    hstr := getstring;
  until pos('OK',hstr)>0;
  while charavail do getchar;
  endzeit:=tick+WarteTick;
  sendstr('AT&FE0'+#13);  (* Standard, No Echo *)
  repeat
    repeat
      if endzeit<tick then Timeout;
    until charavail;
    hstr := getstring;
  until pos('OK',hstr)>0;
  while charavail do getchar;
  endzeit:=tick+WarteTick;
  sendstr('AT+FCLASS=2'+#13); (* Set Class 2 *)
  repeat
    repeat
      if endzeit<tick then Timeout;
    until charavail;
    hstr := getstring;
  until pos('OK',hstr)>0;
  while charavail do getchar;
  endzeit:=tick+WarteTick;
  sendstr('AT+FLID="'+TelNr+'"'+#13); (* Local ID String *)
  repeat
    repeat
      if endzeit<tick then Timeout;
    until charavail;
    hstr := getstring;
  until pos('OK',hstr)>0;
  while charavail do getchar;
  endzeit:=tick+WarteTick;
  (* sendstr('AT+FDCC=0,3,0,2'+#13); (* 98lpi, 9600, 215mm, unlimeted length*)
  sendstr('AT+FDCC=0,3,0,0'+#13); (* 98lpi, 9600, 215mm, A4 *)
  repeat
    repeat
      if endzeit<tick then Timeout;
    until charavail;
    hstr := getstring;
  until pos('OK',hstr)>0;
  while charavail do getchar;
end;

Procedure Dial(tp:char;nr:String);
var endzeit:Longint;
    hstr:String;
begin
  tp := upcase(tp);
  if (tp<>'T') and (tp<>'P') then tp := 'P';
  writeln('Dial: ',nr);
  endzeit:=tick+90*18;
  sendstr('ATX3D'+tp+nr+#13); (* X3= Ignore no dialtone *)
  repeat
    repeat
      if (endzeit<tick) or keypressed then Timeout;
    until charavail;
    hstr := getstring;
    if pos('BUSY',hstr)>0 then
    begin
      writeln(nr+' is BUSY, ERRORLEVEL 1');
      halt(1);
    end;
    if pos('NO DIALTONE',hstr)>0 then
    begin
      writeln('Modem has no Dialtone, ERRORLEVEL 2');
      halt(2);
    end;
    if pos('NO CARRIER',hstr)>0 then
    begin
      writeln('NO Carrier, probably no fax at '+nr+', ERRORLEVEL 3');
      halt(3);
    end;
  until pos('OK',hstr)>0;
  while charavail do getchar;
  endzeit:=tick+30*18;
  sendstr('AT+FDT'+#13);   (* phase C data command *)
  repeat
    repeat
      if endzeit<tick then Timeout;
    until charavail;
    hstr := getstring;
  until pos('CONNECT',hstr)>0;
  if pos(#17,hstr)=0 then (* XON *)
  begin
    endzeit:=tick+10*18;
    repeat
      repeat
        if endzeit<tick then Timeout;
      until charavail;
      hstr := getstring;
    until pos(#17,hstr)>0; (* XON *)
  end;
  delay(10); (* Ein bisschen warten *)
  sendchar(#0); sendchar(#$80); (* EOL *)
  delay(10); (* Ein bisschen warten *)
end;

procedure EndPage(MorePages:Boolean);
var endzeit:longint;
    hstr:string;
begin
  sendstr(#16+#3); (* <DLE> <ETX>  ;return to control *)
  endzeit:=tick+20*18;
  repeat
    repeat
      if endzeit<tick then Timeout;
    until charavail;
    hstr := getstring;
  until pos('OK',hstr)>0;
  delay(100);
  while charavail do getchar;
  endzeit:=tick+90*18;
  if morepages then
    sendstr('AT+FET=0'+#13) (* More pages; same document *)
  else
    sendstr('AT+FET=2'+#13); (* No more pages or documents *)
  repeat
    repeat
      if endzeit<tick then Timeout;
    until charavail;
    hstr := getstring;
  until pos('OK',hstr)>0;
  if morepages then
  begin
    endzeit:=tick+30*18;
    sendstr('AT+FDT'+#13);   (* phase C data command *)
    repeat
      repeat
        if endzeit<tick then Timeout;
      until charavail;
      hstr := getstring;
    until pos('CONNECT',hstr)>0;
    if pos(#17,hstr)=0 then (* XON *)
    begin
      endzeit:=tick+10*18;
      repeat
        repeat
          if endzeit<tick then Timeout;
        until charavail;
        hstr := getstring;
      until pos(#17,hstr)>0; (* XON *)
    end;
    delay(10); (* Ein bisschen warten *)
    sendchar(#0); sendchar(#$80); (* EOL *)
    delay(10); (* Ein bisschen warten *)
  end
  else
  begin
    writeln('Fax sent successfully!');
    while charavail do getchar;
{$IFDEF OUTLOG}
    close(outlog);
{$ENDIF}
  end;
end;

const TerminatingWhiteCodes:
  array[0..63] of array[1..2] of Byte=(
(*      00110101 *) ( 53, 8), (* 0 *)
(*        000111 *) (  7, 6), (* 1 *)
(*          0111 *) (  7, 4), (* 2 *)
(*          1000 *) (  8, 4), (* 3 *)
(*          1011 *) ( 11, 4), (* 4 *)
(*          1100 *) ( 12, 4), (* 5 *)
(*          1110 *) ( 14, 4), (* 6 *)
(*          1111 *) ( 15, 4), (* 7 *)
(*         10011 *) ( 19, 5), (* 8 *)
(*         10100 *) ( 20, 5), (* 9 *)
(*         00111 *) (  7, 5), (* 10 *)
(*         01000 *) (  8, 5), (* 11 *)
(*        001000 *) (  8, 6), (* 12 *)
(*        000011 *) (  3, 6), (* 13 *)
(*        110100 *) ( 52, 6), (* 14 *)
(*        110101 *) ( 53, 6), (* 15 *)
(*        101010 *) ( 42, 6), (* 16 *)
(*        101011 *) ( 43, 6), (* 17 *)
(*       0100111 *) ( 39, 7), (* 18 *)
(*       0001100 *) ( 12, 7), (* 19 *)
(*       0001000 *) (  8, 7), (* 20 *)
(*       0010111 *) ( 23, 7), (* 21 *)
(*       0000011 *) (  3, 7), (* 22 *)
(*       0000100 *) (  4, 7), (* 23 *)
(*       0101000 *) ( 40, 7), (* 24 *)
(*       0101011 *) ( 43, 7), (* 25 *)
(*       0010011 *) ( 19, 7), (* 26 *)
(*       0100100 *) ( 36, 7), (* 27 *)
(*       0011000 *) ( 24, 7), (* 28 *)
(*      00000010 *) (  2, 8), (* 29 *)
(*      00000011 *) (  3, 8), (* 30 *)
(*      00011010 *) ( 26, 8), (* 31 *)
(*      00011011 *) ( 27, 8), (* 32 *)
(*      00010010 *) ( 18, 8), (* 33 *)
(*      00010011 *) ( 19, 8), (* 34 *)
(*      00010100 *) ( 20, 8), (* 35 *)
(*      00010101 *) ( 21, 8), (* 36 *)
(*      00010110 *) ( 22, 8), (* 37 *)
(*      00010111 *) ( 23, 8), (* 38 *)
(*      00101000 *) ( 40, 8), (* 39 *)
(*      00101001 *) ( 41, 8), (* 40 *)
(*      00101010 *) ( 42, 8), (* 41 *)
(*      00101011 *) ( 43, 8), (* 42 *)
(*      00101100 *) ( 44, 8), (* 43 *)
(*      00101101 *) ( 45, 8), (* 44 *)
(*      00000100 *) (  4, 8), (* 45 *)
(*      00000101 *) (  5, 8), (* 46 *)
(*      00001010 *) ( 10, 8), (* 47 *)
(*      00001011 *) ( 11, 8), (* 48 *)
(*      01010010 *) ( 82, 8), (* 49 *)
(*      01010011 *) ( 83, 8), (* 50 *)
(*      01010100 *) ( 84, 8), (* 51 *)
(*      01010101 *) ( 85, 8), (* 52 *)
(*      00100100 *) ( 36, 8), (* 53 *)
(*      00100101 *) ( 37, 8), (* 54 *)
(*      01011000 *) ( 88, 8), (* 55 *)
(*      01011001 *) ( 89, 8), (* 56 *)
(*      01011010 *) ( 90, 8), (* 57 *)
(*      01011011 *) ( 91, 8), (* 58 *)
(*      01001010 *) ( 74, 8), (* 59 *)
(*      01001011 *) ( 75, 8), (* 60 *)
(*      00110010 *) ( 50, 8), (* 61 *)
(*      00110011 *) ( 51, 8), (* 62 *)
(*      00110100 *) ( 52, 8));(* 63 *)

MakeUpWhiteCodes:
  array[1..27] of array[1..2] of Byte=(
(*         11011 *) ( 27, 5), (* 64 *)
(*         10010 *) ( 18, 5), (* 128 *)
(*        010111 *) ( 23, 6), (* 192 *)
(*       0110111 *) ( 55, 7), (* 256 *)
(*      00110110 *) ( 54, 8), (* 320 *)
(*      00110111 *) ( 55, 8), (* 384 *)
(*      01100100 *) (100, 8), (* 448 *)
(*      01100101 *) (101, 8), (* 512 *)
(*      01101000 *) (104, 8), (* 576 *)
(*      01100111 *) (103, 8), (* 640 *)
(*     011001100 *) (204, 9), (* 704 *)
(*     011001101 *) (205, 9), (* 768 *)
(*     011010010 *) (210, 9), (* 832 *)
(*     011010011 *) (211, 9), (* 896 *)
(*     011010100 *) (212, 9), (* 960 *)
(*     011010101 *) (213, 9), (* 1024 *)
(*     011010110 *) (214, 9), (* 1088 *)
(*     011010111 *) (215, 9), (* 1152 *)
(*     011011000 *) (216, 9), (* 1216 *)
(*     011011001 *) (217, 9), (* 1280 *)
(*     011011010 *) (218, 9), (* 1344 *)
(*     011011011 *) (219, 9), (* 1408 *)
(*     010011000 *) (152, 9), (* 1472 *)
(*     010011001 *) (153, 9), (* 1536 *)
(*     010011010 *) (154, 9), (* 1600 *)
(*        011000 *) ( 24, 6), (* 1664 *)
(*     010011011 *) (155, 9));(* 1728 *)

TerminatingBlackCodes:
  array[0..63] of array[1..2] of Byte=(
(*    0000110111 *) ( 55,10), (* 0 *)
(*           010 *) (  2, 3), (* 1 *)
(*            11 *) (  3, 2), (* 2 *)
(*            10 *) (  2, 2), (* 3 *)
(*           011 *) (  3, 3), (* 4 *)
(*          0011 *) (  3, 4), (* 5 *)
(*          0010 *) (  2, 4), (* 6 *)
(*         00011 *) (  3, 5), (* 7 *)
(*        000101 *) (  5, 6), (* 8 *)
(*        000100 *) (  4, 6), (* 9 *)
(*       0000100 *) (  4, 7), (* 10 *)
(*       0000101 *) (  5, 7), (* 11 *)
(*       0000111 *) (  7, 7), (* 12 *)
(*      00000100 *) (  4, 8), (* 13 *)
(*      00000111 *) (  7, 8), (* 14 *)
(*     000011000 *) ( 24, 9), (* 15 *)
(*    0000010111 *) ( 23,10), (* 16 *)
(*    0000011000 *) ( 24,10), (* 17 *)
(*    0000001000 *) (  8,10), (* 18 *)
(*   00001100111 *) (103,11), (* 19 *)
(*   00001101000 *) (104,11), (* 20 *)
(*   00001101100 *) (108,11), (* 21 *)
(*   00000110111 *) ( 55,11), (* 22 *)
(*   00000101000 *) ( 40,11), (* 23 *)
(*   00000010111 *) ( 23,11), (* 24 *)
(*   00000011000 *) ( 24,11), (* 25 *)
(*  000011001010 *) (202,12), (* 26 *)
(*  000011001011 *) (203,12), (* 27 *)
(*  000011001100 *) (204,12), (* 28 *)
(*  000011001101 *) (205,12), (* 29 *)
(*  000001101000 *) (104,12), (* 30 *)
(*  000001101001 *) (105,12), (* 31 *)
(*  000001101010 *) (106,12), (* 32 *)
(*  000001101011 *) (107,12), (* 33 *)
(*  000011010010 *) (210,12), (* 34 *)
(*  000011010011 *) (211,12), (* 35 *)
(*  000011010100 *) (212,12), (* 36 *)
(*  000011010101 *) (213,12), (* 37 *)
(*  000011010110 *) (214,12), (* 38 *)
(*  000011010111 *) (215,12), (* 39 *)
(*  000001101100 *) (108,12), (* 40 *)
(*  000001101101 *) (109,12), (* 41 *)
(*  000011011010 *) (218,12), (* 42 *)
(*  000011011011 *) (219,12), (* 43 *)
(*  000001010100 *) ( 84,12), (* 44 *)
(*  000001010101 *) ( 85,12), (* 45 *)
(*  000001010110 *) ( 86,12), (* 46 *)
(*  000001010111 *) ( 87,12), (* 47 *)
(*  000001100100 *) (100,12), (* 48 *)
(*  000001100101 *) (101,12), (* 49 *)
(*  000001010010 *) ( 82,12), (* 50 *)
(*  000001010011 *) ( 83,12), (* 51 *)
(*  000000100100 *) ( 36,12), (* 52 *)
(*  000000110111 *) ( 55,12), (* 53 *)
(*  000000111000 *) ( 56,12), (* 54 *)
(*  000000100111 *) ( 39,12), (* 55 *)
(*  000000101000 *) ( 40,12), (* 56 *)
(*  000001011000 *) ( 88,12), (* 57 *)
(*  000001011001 *) ( 89,12), (* 58 *)
(*  000000101011 *) ( 43,12), (* 59 *)
(*  000000101100 *) ( 44,12), (* 60 *)
(*  000001011010 *) ( 90,12), (* 61 *)
(*  000001100110 *) (102,12), (* 62 *)
(*  000001100111 *) (103,12));(* 63 *)

MakeUpBlackCodes:
  array[1..27] of array[1..2] of Byte=(
(*    0000001111 *) ( 15,10), (* 64 *)
(*  000011001000 *) (200,12), (* 128 *)
(*  000011001001 *) (201,12), (* 192 *)
(*  000001011011 *) ( 91,12), (* 256 *)
(*  000000110011 *) ( 51,12), (* 320 *)
(*  000000110100 *) ( 52,12), (* 384 *)
(*  000000110101 *) ( 53,12), (* 448 *)
(* 0000001101100 *) (108,13), (* 512 *)
(* 0000001101101 *) (109,13), (* 576 *)
(* 0000001001010 *) ( 74,13), (* 640 *)
(* 0000001001011 *) ( 75,13), (* 704 *)
(* 0000001001100 *) ( 76,13), (* 768 *)
(* 0000001001101 *) ( 77,13), (* 832 *)
(* 0000001110010 *) (114,13), (* 896 *)
(* 0000001110011 *) (115,13), (* 960 *)
(* 0000001110100 *) (116,13), (* 1024 *)
(* 0000001110101 *) (117,13), (* 1088 *)
(* 0000001110110 *) (118,13), (* 1152 *)
(* 0000001110111 *) (119,13), (* 1216 *)
(* 0000001010010 *) ( 82,13), (* 1280 *)
(* 0000001010011 *) ( 83,13), (* 1344 *)
(* 0000001010100 *) ( 84,13), (* 1408 *)
(* 0000001010101 *) ( 85,13), (* 1472 *)
(* 0000001011010 *) ( 90,13), (* 1536 *)
(* 0000001011011 *) ( 91,13), (* 1600 *)
(* 0000001100100 *) (100,13), (* 1664 *)
(* 0000001100101 *) (101,13));(* 1728 *)

Procedure Sendline(hstr:string);

var
    faxrow:Array[1..1728] of Byte;
    faxbit:Word; (* Aktuelles Bit in Faxzeile *)
    faxmask:Word;
    mat:array[1..100,1..16] of byte;

Procedure AddBits(bits,laenge:Word);
var mask:Word;
begin
  mask := 1;
  while laenge>1 do
  begin
    mask := mask*2;
    dec(laenge);
  end;
  while mask>0 do
  begin
    faxmask := faxmask*2;
    if (faxmask = 0) or (faxmask=$100) then
    begin
      faxmask := $1;
      inc(faxbit);
    end;
    if (bits and mask)<>0 then
    begin
      faxrow[faxbit] := faxrow[faxbit] or faxmask;
    end;
    mask := mask div 2;
  end;
end;

procedure AddWhitetoFax(anz:Word);
begin
  if anz>=64 then
  begin (* Startup Char *)
    AddBits(MakeUpWhiteCodes[anz div 64,1],MakeUpWhiteCodes[anz div 64,2]);
    anz := anz mod 64;
  end;
  AddBits(TerminatingWhiteCodes[anz,1],TerminatingWhiteCodes[anz,2]);
end;

procedure AddBlacktoFax(anz:Word);
var bits:word;
    laenge:Byte;
    mask:Word;
begin
  if anz>=64 then
  begin (* Startup Char *)
    AddBits(MakeUpBlackCodes[anz div 64,1],MakeUpBlackCodes[anz div 64,2]);
    anz := anz mod 64;
  end;
  AddBits(TerminatingBlackCodes[anz,1],TerminatingBlackCodes[anz,2]);
end;

procedure AddEol;
begin
  inc(faxbit,60);        (* FILL to delay 40 ms *)
  faxrow[faxbit] := $80;
end;


var
    white,black,sw:Word;
    iswhite:boolean;
    i1,ic,zl,bit,bitmehrfach:Word;

begin (* Sendline *)
  if hstr='' then hstr := ' ';
  writeln(copy(hstr,1,79));
  while length(hstr)>0 do
  begin
    hstr:='          '+hstr; (* Rand *)
    fillchar(mat,sizeof(mat),0);
    for ic := 1 to length(copy(hstr,1,100)) do
    begin
      move(fax_font[ord(hstr[ic])],mat[ic],16);
    end;
    (* Matrix in Faxzeile konvertieren *)
    bitMehrfach := 1;
    for zl := 1 to 16 do
    begin
      sw := 0;
      iswhite := true;
      white := 0;
      black := 0;
      bit := $80;
      faxbit := 0;
      fillchar(faxrow,sizeof(faxrow),0);
      faxmask := 0;
      ic := 1;
      while ic<=length(copy(hstr,1,100)) do
      begin
        if (mat[ic,zl] and bit)=0 then
        begin
          (* Wei *)
          if iswhite then inc(white)
          else
          begin  (* Schwarz abschlieen *)
            AddBlackToFax(black);
            inc(sw,black);
            iswhite := true;
            white := 1;
          end;
        end
        else
        begin
          (* Schwarz *)
          if not iswhite then inc(black)
          else
          begin (* Wei abschlieen *)
            AddWhiteToFax(white);
            inc(sw,white);
            iswhite := false;
            black := 1;
          end;
        end;
        if bitmehrfach>0 then dec(bitmehrfach)
                         else
                         begin
                           bit := bit div 2;
                           bitMehrfach := 1;
                         end;
        if bit=0 then
        begin
          inc(ic);
          bit := $80;
        end;
      end;
      if not iswhite then
      begin
        AddBlackToFax(1);
        inc(sw);
      end;
      if sw<1728 then
      begin
        AddWhiteToFax(1728-sw);
      end;
      AddEol;
      (* Faxrow zum Modem senden *)
      testcarrier;
      for i1 := 1 to faxbit do
      begin
        if faxrow[i1]=16 then (* <DLE> *)
        begin
          sendchar(chr(faxrow[i1]));
        end;
        sendchar(chr(faxrow[i1]));
      end;
      (* while charavail do getchar;*)
    end;
    delete(hstr,1,100);
  end;
end;

end.

