page 48,132
title	COM-AND script machine language subroutine
;-------------------------------------------------------------------
;	Author:      R. McGinnis; Chicago IL
;
;	These routines provide some simple functions in a machine
;	language overlay form for COM-AND scripts.
;
;	Source: OVERLAY.ASM	Source for this module
;	Object: OVERLAY.OBJ	Object derived from assembly of .Asm
;	Exec:	OVERLAY.EXE	Executable derived from LINK of .OBJ
;
;	Note: you'll need entry points for the script SCALL statement
;	Note: no stack segment is required
;-------------------------------------------------------------------

	PUBLIC	Display 		; Display a string

code	segment byte public 'code'
	ASSUME	CS:Code

	jmp	near ptr Display	; A jump table makes it easy
	jmp	near ptr SegAddr	; .. to SCALL a routine

page
;------ Display ----------------------------------------------------
;	This routine displays a string on the screen
;
;	Passed:
;	   One parameter, the string addr
;	Returned:
;	   nothing
;
;	No registers need be preserved...
;-------------------------------------------------------------------

Display proc	far			; MUST be far return !!
;
;	Get passed parameters
;
	mov	BP,SP			; Save current stack ptr

	mov	SI,[BP+4]		; Get offset of last parm
	mov	ax,[BP+6]		; Get segment of last parm
	mov	DS,ax			; And set into DS...

;***	mov	DI,[BP+8]		; Get offset of prev parm
;***	mov	ax,[BP+10]		; Get segment of prev parm
;***	mov	ES,ax			; Set segment into ES
;
;	Initialize
;
	xor	cx,cx			; Make cx = 0
	mov	ah,0eh			; Int 10h subfuntion, TTY write
	xor	bx,bx			; Make bh,bl = 0 (page # and fgnd)
;
;	Display the string one character at a time
;
DISP100:
	mov	al,byte ptr [SI]	; Get a char
	or	al,al			; Test for null terminator
	jz	DISP200 		; Skip if found

	int	10h			; Write TTY (req's ah,al,bh,bl)

	inc	SI			; Point next fetch
	inc	cx			; We'll display it
	cmp	cx,80			; Max length is 80
	jl	DISP100 		; Loop up to 80 times
;
;	And we're done
;
DISP200:
	ret				; FAR return here
Display endp
page
;------ SegAddr ----------------------------------------------------
;	This routine returns the overlay segment address
;
;	Passed:
;	   nothing
;	Returned:
;	   One parameter, the segment value
;
;	No registers need be preserved...
;-------------------------------------------------------------------

SegAddr proc	far			; MUST be far return !!
;
;	Get rtn parameter address
;
	mov	BP,SP			; Save current stack ptr

	mov	DI,[BP+4]		; Get offset of last parm
	mov	ax,[BP+6]		; Get segment of last parm
	mov	DS,ax			; And set into DS...
;
;	Store the segment reg
;
	mov	ax,CS			; Set-up to store
	mov	word ptr DS:[DI],ax	; Store our segment addr
;
;	And we're done
;
	ret				; FAR return here
SegAddr endp
Code	ends
	end
