/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.modules.indxp.ui.NumberInputSet;
import de.admadic.calculator.modules.indxp.ui.NumberInputValidator;
import de.admadic.ui.util.Dialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class NumberInputDialog
extends Dialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JTextArea textMsg;
    JPanel panelInputs;
    NumberInputSet[] inputSets;
    JPanel panelButtons;
    JButton btnOK;
    JButton btnCancel;
    static final String CMD_OK = "nid.ok";
    static final String CMD_CANCEL = "nid.cancel";
    NumberInputValidator validator;

    public NumberInputDialog(String string, NumberInputSet[] numberInputSetArray) throws HeadlessException {
        this.initContents(string, numberInputSetArray);
    }

    public NumberInputDialog(Frame frame, String string, NumberInputSet[] numberInputSetArray) throws HeadlessException {
        super(frame);
        this.initContents(string, numberInputSetArray);
    }

    public NumberInputDialog(java.awt.Dialog dialog, String string, NumberInputSet[] numberInputSetArray) throws HeadlessException {
        super(dialog);
        this.initContents(string, numberInputSetArray);
    }

    private void initContents(String string, NumberInputSet[] numberInputSetArray) {
        if (numberInputSetArray.length < 1) {
            throw new Error("must have at least 1 input set.");
        }
        this.inputSets = numberInputSetArray;
        FormLayout formLayout = new FormLayout("12px, p:grow, 12px", "12px, p, 5px, p:grow, 5px, p, 12px");
        CellConstraints cellConstraints = new CellConstraints();
        this.setLayout((LayoutManager)formLayout);
        String string2 = "0px, p, 5px, p:grow, 5px, p, 0px";
        String string3 = null;
        for (int i = 0; i < numberInputSetArray.length; ++i) {
            string3 = string3 == null ? "0px, p" : string3 + ", 5px, p";
        }
        string3 = string3 + ", 0px";
        FormLayout formLayout2 = new FormLayout(string2, string3);
        CellConstraints cellConstraints2 = new CellConstraints();
        this.panelInputs = new JPanel();
        this.panelInputs.setLayout((LayoutManager)formLayout2);
        this.add(this.panelInputs, cellConstraints.xy(2, 4));
        if (string != null) {
            this.textMsg = new JTextArea();
            this.textMsg.setEditable(false);
            this.textMsg.setOpaque(false);
            this.textMsg.setText(string);
            this.add(this.textMsg, cellConstraints.xy(2, 2));
        }
        for (int i = 0; i < numberInputSetArray.length; ++i) {
            NumberInputSet numberInputSet = numberInputSetArray[i];
            this.panelInputs.add((Component)numberInputSet.label, cellConstraints2.xy(2, 2 + i * 2));
            this.panelInputs.add((Component)numberInputSet.spinner, cellConstraints2.xy(4, 2 + i * 2));
            if (numberInputSet.info == null) continue;
            this.panelInputs.add((Component)numberInputSet.info, cellConstraints2.xy(6, 2 + i * 2));
        }
        this.panelButtons = new JPanel();
        this.add(this.panelButtons, cellConstraints.xy(2, 6));
        this.btnOK = new JButton("OK");
        this.btnOK.setActionCommand(CMD_OK);
        this.btnOK.addActionListener(this);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setActionCommand(CMD_CANCEL);
        this.btnCancel.addActionListener(this);
        this.panelButtons.add(this.btnOK);
        this.panelButtons.add(this.btnCancel);
        this.registerEnterAction(this.btnOK);
        this.setTitle("Number Input");
        this.setModal(true);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_OK)) {
            for (NumberInputSet numberInputSet : this.inputSets) {
                numberInputSet.value = (Integer)numberInputSet.spinner.getValue();
            }
            if (this.validator != null && !this.validator.validate(this.inputSets)) {
                return;
            }
            this.setResultCode(1);
            this.setVisible(false);
        } else if (string.equals(CMD_CANCEL)) {
            this.setResultCode(2);
            this.setVisible(false);
        }
    }

    public NumberInputValidator getValidator() {
        return this.validator;
    }

    public void setValidator(NumberInputValidator numberInputValidator) {
        this.validator = numberInputValidator;
    }
}

