/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.core;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathHelper {
    public static Double calcAvg(List<Double> list) {
        double d = 0.0;
        int n = 0;
        for (Double d2 : list) {
            if (d2 == null || d2.isNaN()) continue;
            d += d2.doubleValue();
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        return d /= (double)n;
    }

    public static Double calcSigma(List<Double> list) {
        Double d = MathHelper.calcAvg(list);
        if (d.isNaN()) {
            return d;
        }
        return MathHelper.calcSigma(list, d);
    }

    public static Double calcSigma(List<Double> list, Double d) {
        if (d.isNaN()) {
            return d;
        }
        double d2 = d;
        double d3 = 0.0;
        int n = 0;
        for (Double d4 : list) {
            if (d4 == null || d4.isNaN()) continue;
            double d5 = d4 - d2;
            d5 *= d5;
            d3 += d5;
            ++n;
        }
        if (n < 2) {
            return Double.NaN;
        }
        d3 /= (double)n;
        d3 = Math.sqrt(d3);
        return d3;
    }
}

